/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.jobrunner.status.StatusAsDOTPrinter;
import com.dataiku.dip.dataflow.kernel.master.BuildService;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.recipes.code.spark.historyserver.SparkHistoryServerManager;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DiagConfigRedactionUtils;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class FlowExecutionController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private FlowExecutionService2 service;
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private AchievementsService achievementsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private SparkHistoryServerManager sparkHistoryServerManager;

    @AuditedCall(value={"msgType", "jobs-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/jobs/list-last-jobs"})
    @ResponseBody
    public List<FlowExecutionService2.JobSummary> listLastJobs(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(required=false, defaultValue="20") int nb) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.service.listLastJobs_NT(projectKey, nb);
    }

    @AuditedCall(value={"msgType", "jobs-list-running-personal"})
    @RequestMapping(value={"/api/flow/jobs/list-running-jobs"})
    @ResponseBody
    public List<FlowExecutionService2.JobSummary> listRunningJobs(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            List<FlowExecutionService2.JobSummary> allJobs = this.service.listAllRunningJobs();
            ArrayList<FlowExecutionService2.JobSummary> myJobs = new ArrayList<FlowExecutionService2.JobSummary>(allJobs.size());
            for (FlowExecutionService2.JobSummary job : allJobs) {
                if (!authCtx.getIdentifier().equals(job.def.initiator)) continue;
                myJobs.add(job);
            }
            Collections.sort(myJobs, new Comparator<FlowExecutionService2.JobSummary>(){

                @Override
                public int compare(FlowExecutionService2.JobSummary a, FlowExecutionService2.JobSummary b) {
                    return -((int)(a.def.initiationTimestamp - b.def.initiationTimestamp));
                }
            });
            ArrayList<FlowExecutionService2.JobSummary> arrayList = myJobs;
            return arrayList;
        }
    }

    @AuditedCall(value={"msgType", "admin-jobs-list-running"})
    @RequestMapping(value={"/api/flow/jobs/list-all-running-jobs"})
    @ResponseBody
    public List<FlowExecutionService2.JobSummary> listAllRunningJobs(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            List<FlowExecutionService2.JobSummary> allJobs = this.service.listAllRunningJobs();
            Collections.sort(allJobs, new Comparator<FlowExecutionService2.JobSummary>(){

                @Override
                public int compare(FlowExecutionService2.JobSummary a, FlowExecutionService2.JobSummary b) {
                    return -((int)(a.def.initiationTimestamp - b.def.initiationTimestamp));
                }
            });
            List<FlowExecutionService2.JobSummary> list = allJobs;
            return list;
        }
    }

    @AuditedCall(value={"msgType", "job-get-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/get-job-status"})
    @ResponseBody
    public EnhancedSerializedJobStatus getJobStatus(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String jobId) throws Exception {
        boolean includeLogs;
        AuthCtx u;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Missing jobProjectKey");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobId), (Object)"Missing jobId");
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            includeLogs = FlowExecutionController.canAccessLogs(u);
        }
        EnhancedSerializedJobStatus status = this.service.getStatus_NT(projectKey, jobId);
        try (Transaction t = this.transactionService.beginRead();){
            this.service.addInitiator(status);
            if (status.baseStatus.state == JobState.FAILED || status.baseStatus.state == JobState.ABORTED) {
                this.achievementsService.win(u, AchievementsService.AchievementId.OH_NOES_JOB_FAILED);
                for (SerializedJobActivityStatus activity : status.baseStatus.activities.values()) {
                    if (activity.recipeType == null || !activity.recipeType.equals("hive")) continue;
                    this.achievementsService.win(u, AchievementsService.AchievementId.STING_OF_THE_BEE);
                }
            } else if (status.baseStatus.state == JobState.DONE) {
                this.achievementsService.win(u, AchievementsService.AchievementId.MY_FIRST_JOB);
                for (SerializedJobActivityStatus activity : status.baseStatus.activities.values()) {
                    if (activity.recipeType == null || !activity.recipeType.equals("spark_sql_query") && !activity.recipeType.equals("spark_scala") && !activity.recipeType.equals("pyspark") && !activity.recipeType.equals("sparkr")) continue;
                    this.achievementsService.win(u, AchievementsService.AchievementId.LIGHT_THE_SPARK);
                }
            }
            if (!includeLogs || DKUApp.hideErrorStacks()) {
                FlowExecutionController.redactLogsAndCallstacks(status, DKUApp.hideErrorStacks(), !includeLogs);
            }
            Iterator<SerializedJobActivityStatus> iterator = status;
            return iterator;
        }
    }

    @AuditedCall(value={"msgType", "job-get-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/cat-job-log"})
    public void catJobLog(HttpServletRequest req, HttpServletResponse resp, String projectKey, String jobId) throws Exception {
        block16: {
            if (!this.checkProjectAndJobId(resp, projectKey, jobId)) {
                return;
            }
            File attemptLogFile = LogsService.getOutputDotLogFile(projectKey, jobId);
            attemptLogFile = DKUFileUtils.getWithAutoDecompress((File)attemptLogFile);
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                if (!FlowExecutionController.checkCanAccessLogs(authCtx, resp)) {
                    return;
                }
                if (attemptLogFile.exists()) {
                    resp.setContentType("text/plain; charset=UTF-8");
                    try (InputStream fis = DKUFileUtils.readWithAutoDecompress((File)attemptLogFile);){
                        IOUtils.copy((InputStream)fis, (OutputStream)resp.getOutputStream());
                        break block16;
                    }
                }
                resp.setStatus(404);
                resp.getWriter().write("job log file not found");
            }
        }
    }

    @AuditedCall(value={"msgType", "job-download-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/download-job-diagnosis"})
    public void downloadLogDiagnosis(HttpServletRequest req, HttpServletResponse resp, String projectKey, String jobId) throws Exception {
        AuthCtx authCtx;
        if (!this.checkProjectAndJobId(resp, projectKey, jobId)) {
            return;
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!FlowExecutionController.canAccessLogs(authCtx)) {
                throw new UnauthorizedException("Access denied", "Logs visibility is restricted. Contact your administrator if you need to access these logs");
            }
        }
        this.service.dumpStacksIfStillRunning_NT(projectKey, jobId);
        File jobDir = LogsService.getJobFolder(projectKey, jobId);
        Object id = "dss-job-diag-" + projectKey + "-" + jobId;
        id = RelFile.ensureValidName((String)id);
        if (jobDir.exists()) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + (String)id + ".zip\"");
            resp.setStatus(200);
            try (ZipWriteFS zipDiag = new ZipWriteFS((OutputStream)resp.getOutputStream(), 1);){
                zipDiag.makeDirectory((String)id);
                DiagConfigRedactionUtils.buildJobDiag(jobDir, zipDiag.directoryView((String)id), authCtx);
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("job logs dir not found");
        }
    }

    @AuditedCall(value={"msgType", "job-fetch-yarn-logs", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/fetch-yarn-logs"})
    @ResponseBody
    public FutureResponse<List<EnhancedSerializedJobStatus.YarnLog>> fetchYarnLogs(HttpServletRequest req, String projectKey, String jobId) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Missing jobProjectKey");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobId), (Object)"Missing jobId");
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            FutureResponse<List<EnhancedSerializedJobStatus.YarnLog>> futureResponse = this.service.fetchYarnLogs(authCtx, projectKey, jobId);
            return futureResponse;
        }
    }

    @AuditedCall(value={"msgType", "job-get-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/cat-activity-log"})
    public void catActivityLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String jobId, String activityId, @RequestParam(required=false) String logId) throws Exception {
        if (!this.checkProjectAndJobId(resp, projectKey, jobId)) {
            return;
        }
        File activityLogFile = null;
        activityLogFile = StringUtils.isBlank((String)logId) ? LogsService.getActivityLogFile(projectKey, jobId, activityId) : LogsService.getActivityLogAdditionalFile(projectKey, jobId, activityId, logId);
        activityLogFile = DKUFileUtils.getWithAutoDecompress((File)activityLogFile);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!FlowExecutionController.checkCanAccessLogs(authCtx, resp)) {
                return;
            }
        }
        if (activityLogFile.exists()) {
            resp.setContentType("text/plain; charset=UTF-8");
            try (InputStream fis = DKUFileUtils.readWithAutoDecompress((File)activityLogFile);){
                IOUtils.copy((InputStream)fis, (OutputStream)resp.getOutputStream());
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("job activity log file not found");
        }
    }

    @AuditedCall(value={"msgType", "job-get-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/cat-yarn-log"})
    public void catYarnLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String jobId, String yarnAppId, String activityId) throws Exception {
        if (!this.checkProjectAndJobId(resp, projectKey, jobId)) {
            return;
        }
        File activityLogFile = LogsService.getYarnLogFile(projectKey, jobId, activityId, yarnAppId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!FlowExecutionController.checkCanAccessLogs(authCtx, resp)) {
                return;
            }
        }
        if (activityLogFile.exists()) {
            resp.setContentType("text/plain; charset=UTF-8");
            try (FileInputStream fis = new FileInputStream(activityLogFile);){
                IOUtils.copy((InputStream)fis, (OutputStream)resp.getOutputStream());
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("job yarn log file not found");
        }
    }

    @AuditedCall(value={"msgType", "job-get-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/cat-k8s-log"})
    public void catK8SLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String jobId, String podName, String activityId) throws Exception {
        if (!this.checkProjectAndJobId(resp, projectKey, jobId)) {
            return;
        }
        File activityLogFile = LogsService.getK8SLogFile(projectKey, jobId, activityId, podName);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!FlowExecutionController.checkCanAccessLogs(authCtx, resp)) {
                return;
            }
        }
        if (activityLogFile.exists()) {
            resp.setContentType("text/plain; charset=UTF-8");
            try (FileInputStream fis = new FileInputStream(activityLogFile);){
                IOUtils.copy((InputStream)fis, (OutputStream)resp.getOutputStream());
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("job k8s log file not found");
        }
    }

    @AuditedCall(value={"msgType", "job-get-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/smart-tail-activity-log"})
    public void smartTailActivityLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String jobId, @RequestParam String activityId, @RequestParam int nbLines) throws Exception {
        if (!this.checkProjectAndJobId(resp, projectKey, jobId)) {
            return;
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!FlowExecutionController.canAccessLogs(authCtx)) {
                FlowExecutionController.writeJSON((HttpServletResponse)resp, (Object)SmartLogTail.restrictedLogTail());
                return;
            }
        }
        File activityLogFile = LogsService.getActivityLogFile(projectKey, jobId, activityId);
        activityLogFile = DKUFileUtils.getWithAutoDecompress((File)activityLogFile);
        if (activityLogFile.exists()) {
            String tail = DKUtils.tailFile((File)activityLogFile, (int)nbLines);
            FlowExecutionController.writeJSON((HttpServletResponse)resp, (Object)FlowJobUtils.getSmartLogTail(tail, activityId));
        } else {
            resp.setStatus(404);
            resp.getWriter().write("job activity log file not found");
        }
    }

    @AuditedCall(value={"msgType", "job-get-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/smart-tail-activity-additional-log"})
    public void smartTailActivityAdditionalLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String jobId, @RequestParam String activityId, @RequestParam String path, @RequestParam int nbLines) throws Exception {
        if (!this.checkProjectAndJobId(resp, projectKey, jobId)) {
            return;
        }
        File activityLogFile = LogsService.getActivityLogAdditionalFile(projectKey, jobId, activityId, path);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!FlowExecutionController.canAccessLogs(authCtx)) {
                FlowExecutionController.writeJSON((HttpServletResponse)resp, (Object)FlowJobUtils.getSmartLogTail("Logs visibility is restricted. Contact your administrator if you need to access these logs", activityId));
                return;
            }
        }
        activityLogFile = DKUFileUtils.getWithAutoDecompress((File)activityLogFile);
        if (activityLogFile.exists()) {
            String tail = DKUtils.tailFile((File)activityLogFile, (int)nbLines);
            FlowExecutionController.writeJSON((HttpServletResponse)resp, (Object)FlowJobUtils.getSmartLogTail(tail, activityId));
        } else {
            resp.setStatus(404);
            resp.getWriter().write("job activity log additional file not found: " + String.valueOf(activityLogFile));
        }
    }

    @AuditedCall(value={"msgType", "job-start-spark-history-server", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/start-spark-history-server"})
    @ResponseBody
    public Id startSparkHistoryServer(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String jobId, @RequestParam String activityId) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Missing jobProjectKey");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobId), (Object)"Missing jobId");
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        return this.sparkHistoryServerManager.startForActivity(projectKey, jobId, activityId);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/spark/check-history-server-access/{projectKey}/{jobId}/{activityId}"})
    public void checkSHSAccess(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String jobId, @PathVariable String activityId) throws Exception {
        block7: {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Missing jobProjectKey");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobId), (Object)"Missing jobId");
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx authCtx = this.authService.getUserNoXSRF(req);
                if (authCtx != null) {
                    this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                    this.sparkHistoryServerManager.updateLastUsage(projectKey, jobId, activityId);
                    resp.setStatus(200);
                    break block7;
                }
                throw new NotAuthenticatedException("Access to project rejected", "spark-history-server-access-failed");
            }
        }
    }

    @AuditedCall(value={"msgType", "job-get-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/get-job-graph"})
    public void getJobGraph(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String jobId, String type) throws Exception {
        block22: {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Missing jobProjectKey");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobId), (Object)"Missing jobId");
            try (Transaction t = this.transactionService.beginRead();){
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            EnhancedSerializedJobStatus status = this.service.getStatus_NT(projectKey, jobId);
            try (Transaction t = this.transactionService.beginRead();){
                this.service.addInitiator(status);
                try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"job-graph-export", (String)"graphviz", (String)"dot");){
                    if (type.equals("png")) {
                        resp.setContentType("image/png");
                        FileUtils.write((File)tmpFile, (CharSequence)StatusAsDOTPrinter.printAsDOT(status.baseStatus));
                        byte[] pngData = DKUtils.execAndGetOutput((String[])new String[]{"dot", "-Tpng", tmpFile.getAbsolutePath()}, null);
                        resp.getOutputStream().write(pngData);
                        break block22;
                    }
                    if (type.equals("svg")) {
                        resp.setContentType("text/plain");
                        FileUtils.write((File)tmpFile, (CharSequence)StatusAsDOTPrinter.printAsDOT(status.baseStatus));
                        byte[] svgData = DKUtils.execAndGetOutput((String[])new String[]{"dot", "-Tsvg", tmpFile.getAbsolutePath()}, null);
                        resp.getOutputStream().write(svgData);
                        break block22;
                    }
                    if (type.equals("graphviz")) {
                        resp.setContentType("text/plain");
                        resp.getWriter().write(StatusAsDOTPrinter.printAsDOT(status.baseStatus));
                        break block22;
                    }
                    throw new IllegalArgumentException("Unknown type");
                }
            }
        }
    }

    @AuditedCall(value={"msgType", "jobs-list-clear", "projectKey", "${jobProjectKey}"})
    @RequestMapping(value={"/api/flow/jobs/clear-logs-with-filter"})
    public void clearJobs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobProjectKey, @RequestParam String filter) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, jobProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.service.clearLogsWithFilter_NT(jobProjectKey, filter);
    }

    @AuditedCall(value={"msgType", "jobs-list-clear", "projectKey", "${jobProjectKey}"})
    @RequestMapping(value={"/api/flow/jobs/clear-logs"})
    public void deleteJob(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobProjectKey, @RequestParam String jobId) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobProjectKey), (Object)"Missing jobProjectKey");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobId), (Object)"Missing jobId");
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, jobProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.service.clearLogs_NT(jobProjectKey, jobId);
    }

    @AuditedCall(value={"msgType", "job-preview"})
    @RequestMapping(value={"/api/flow/jobs/start-preview"})
    @ResponseBody
    public Id simulate(HttpServletRequest req, @RequestParam(value="data") JobDef jd) throws Exception {
        String jobId;
        VariablesContext vc = this.variablesService.getForProject(jd.projectKey);
        jd.expandInPlaceOutputsTargetPartition(vc);
        try (Transaction t = this.transactionService.beginRead();){
            this.licenseService.failIfLocked();
            AuthCtx u = this.authService.getMandatoryUser(req);
            jd.initiationTimestamp = System.currentTimeMillis();
            jd.initiator = u.getIdentifier();
            this.projectsService.checkPerm(req, jd.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            jobId = this.service.startJobPreview(jd, u);
        }
        return new Id(jobId);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/flow/jobs/get-preview-result"})
    @ResponseBody
    public BuildService.PreviewResult getPreviewResult(HttpServletRequest req, @RequestParam String jobProjectKey, @RequestParam String jobId) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobProjectKey), (Object)"Missing jobProjectKey");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobId), (Object)"Missing jobId");
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, jobProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            BuildService.PreviewResult previewResult = this.service.getPreviewResult(jobProjectKey, jobId);
            return previewResult;
        }
    }

    @AuditedCall(value={"msgType", "job-start-after-preview", "projectKey", "${jobProjectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/validate-run-fully"})
    public void runFully(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobProjectKey, @RequestParam String jobId, @RequestParam String skippedActivityIds) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobProjectKey), (Object)"Missing jobProjectKey");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobId), (Object)"Missing jobId");
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, jobProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            List skipped = (List)JSON.parse((String)skippedActivityIds, List.class);
            this.service.validateRunFully(jobProjectKey, jobId, skipped);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/jobs/start"})
    @ResponseBody
    public Id start(HttpServletRequest req, @RequestParam(value="data") JobDef jd) throws Exception {
        VariablesContext vc = this.variablesService.getForProject(jd.projectKey);
        jd.expandInPlaceOutputsTargetPartition(vc);
        try {
            String jobId;
            try (Transaction t = this.transactionService.beginRead();){
                this.licenseService.failIfLocked();
                AuthCtx u = this.authService.getMandatoryUser(req);
                jd.initiationTimestamp = System.currentTimeMillis();
                jd.initiator = u.getIdentifier();
                this.projectsService.checkPerm(req, jd.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                jobId = this.service.startJob(jd, u);
            }
            this.auditTrailService.generic("job-start").with("projectKey", jd.projectKey).with("jobId", jobId).emit();
            return new Id(jobId);
        }
        catch (Exception e) {
            this.auditTrailService.failure("job-start", (Throwable)e).with("projectKey", jd.projectKey).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "job-abort", "projectKey", "${jobProjectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/api/flow/jobs/abort"})
    public void abort(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobProjectKey, @RequestParam String jobId) throws Exception {
        AuthCtx u;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobProjectKey), (Object)"Missing jobProjectKey");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobId), (Object)"Missing jobId");
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, jobProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
        }
        this.service.abort_NT(u, jobProjectKey, jobId);
    }

    @AuditInline
    @RequestMapping(value={"/api/flow/jobs/retry"})
    @ResponseBody
    public Id retry(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobProjectKey, @RequestParam String jobId) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobProjectKey), (Object)"Missing jobProjectKey");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)jobId), (Object)"Missing jobId");
        try {
            String newJobId;
            try (Transaction t = this.transactionService.beginRead();){
                this.licenseService.failIfLocked();
                AuthCtx u = this.authService.getMandatoryUser(req);
                this.projectsService.checkPerm(req, jobProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                newJobId = this.service.retry(jobProjectKey, jobId, u);
            }
            this.auditTrailService.generic("job-retry").with("projectKey", jobProjectKey).with("initialJobId", jobId).with("jobId", newJobId).emit();
            return new Id(newJobId);
        }
        catch (Exception e) {
            this.auditTrailService.failure("job-retry", (Throwable)e).with("projectKey", jobProjectKey).with("initialJobId", jobId).emit();
            throw e;
        }
    }

    private boolean checkProjectAndJobId(HttpServletResponse resp, String projectKey, String jobId) throws IOException {
        if (StringUtils.isBlank((String)projectKey)) {
            resp.setStatus(404);
            resp.getWriter().write("Missing projectKey");
            return false;
        }
        if (StringUtils.isBlank((String)jobId)) {
            resp.setStatus(404);
            resp.getWriter().write("Missing jobId");
            return false;
        }
        return true;
    }

    private static boolean checkCanAccessLogs(AuthCtx authCtx, HttpServletResponse resp) throws IOException {
        if (!FlowExecutionController.canAccessLogs(authCtx)) {
            resp.setStatus(403);
            resp.getWriter().write("Logs visibility is restricted. Contact your administrator if you need to access these logs");
            return false;
        }
        return true;
    }

    private static boolean canAccessLogs(AuthCtx authCtx) {
        return !DKUApp.hideLogs() || authCtx.isAdmin();
    }

    private static void redactLogsAndCallstacks(EnhancedSerializedJobStatus jobStatus, boolean hideErrorStacks, boolean hideLogs) {
        if (jobStatus == null) {
            return;
        }
        if (hideLogs) {
            if (jobStatus.logTail != null) {
                jobStatus.logTail = SmartLogTail.restrictedLogTail();
            }
            if (jobStatus.k8sLogs != null) {
                jobStatus.k8sLogs = new ArrayList<EnhancedSerializedJobStatus.K8SLog>();
            }
            if (jobStatus.yarnLogs != null) {
                jobStatus.yarnLogs = new ArrayList<EnhancedSerializedJobStatus.YarnLog>();
            }
        }
        FlowExecutionController.redact(jobStatus.error, hideErrorStacks, hideLogs);
        if (jobStatus.baseStatus != null) {
            FlowExecutionController.redact(jobStatus.baseStatus.unexpectedFailure, hideErrorStacks, hideLogs);
            FlowExecutionController.redact(jobStatus.baseStatus.checksFailure, hideErrorStacks, hideLogs);
            if (jobStatus.baseStatus.activities != null) {
                for (SerializedJobActivityStatus value : jobStatus.baseStatus.activities.values()) {
                    FlowExecutionController.redact(value.firstFailure, hideErrorStacks, hideLogs);
                }
            }
        }
    }

    private static void redact(SerializedError serializedError, boolean hideErrorStacks, boolean hideLogs) {
        if (serializedError != null) {
            if (hideErrorStacks) {
                serializedError.stackTraceStr = null;
                if (serializedError.stackTrace != null) {
                    serializedError.stackTrace = new ArrayList();
                }
            }
            if (hideLogs) {
                if (serializedError.logTail != null) {
                    serializedError.logTail = SmartLogTail.restrictedLogTail();
                }
                serializedError.debuggingHint = null;
            }
        }
    }
}

