/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.TrialTokenAcquisitionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LicenseStatusController
extends DIPInternalControllerBase {
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private LicenseEnforcementService limitsService;
    @Autowired
    private UIAuthService uiAuthService;
    @Autowired
    private SharedSecretAuthService ssAuthService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TrialTokenAcquisitionService trialTokenAcquisitionService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/intercom/get-licensing-status"})
    public void getLicensingStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.ssAuthService.failIfNoSharedSecret(req);
        LicenseStatusController.writeJSON((HttpServletResponse)resp, (Object)this.licenseService.getLicensingStatus());
    }

    @AuditedCall(value={"msgType", "admin-get-license-status"})
    @RequestMapping(value={"/api/admin/get-limits-status"})
    public void getLicensingLimitsStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.uiAuthService.failIfNotAdmin(req);
            LicenseStatusController.writeJSON((HttpServletResponse)resp, (Object)this.limitsService.getLimitsStatus());
        }
    }

    @AuditedCall(value={"msgType", "admin-get-trial-status"})
    @RequestMapping(value={"/api/admin/get-trial-status"})
    @ResponseBody
    public JsonObject getTrialStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.uiAuthService.failIfNotAdmin(req);
        }
        return this.trialTokenAcquisitionService.getStatus();
    }
}

