/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.llm.LLMModelReader;
import com.dataiku.dip.analysis.model.llm.LLMModelDetails;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MLLLMController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;

    private FullModelId unsmartifyAndCheck(HttpServletRequest req, FullModelId fmi) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            if (fmi.getType() == FullModelId.Type.SAVED) {
                SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SAVED_MODEL, fmi.getSavedModelID());
                this.projectsService.failIfNoDashboardReadPermission(req, smartObjectRef, fmi.getProjectKey());
                FullModelId fullModelId = new FullModelId(smartObjectRef.getProjectKey(fmi.getProjectKey()), smartObjectRef.objectId, fmi.getSavedModelVersionID());
                return fullModelId;
            }
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            FullModelId fullModelId = fmi;
            return fullModelId;
        }
    }

    @AuditedCall(value={"msgType", "llm-model-get-details", "modelId", "${fullModelId}"})
    @ResponseBody
    @RequestMapping(value={"/api/ml/llm/get-model-details"})
    public LLMModelDetails getModelDetails(HttpServletRequest req, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        if (!fmi.exists()) {
            throw new NotFoundException("Model does not exist: " + String.valueOf(fmi));
        }
        return LLMModelReader.makeDetails(fmi);
    }
}

