/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.cassandra.CassandraDatasetTestHandler;
import com.dataiku.dip.datasets.custompython.CustomDatasetTestHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetTestHandler;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetHandler;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetTestHandler;
import com.dataiku.dip.datasets.experimentsdb.ExperimentsDBDatasetHandler;
import com.dataiku.dip.datasets.experimentsdb.ExperimentsDBDatasetParams;
import com.dataiku.dip.datasets.experimentsdb.ExperimentsDBDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FileFormatDatasetTestHandler;
import com.dataiku.dip.datasets.inline.InlineDatasetTestHandler;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetTestHandler;
import com.dataiku.dip.datasets.labeling.LabelsDatasetTestHandler;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetTestHandler;
import com.dataiku.dip.datasets.sample.SampleDatasetHandler;
import com.dataiku.dip.datasets.sample.SampleDatasetTestHandler;
import com.dataiku.dip.datasets.sharepointonline.SharePointOnlineListDatasetTestHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetTestHandler;
import com.dataiku.dip.datasets.sql.DatasetStorageConflictDetector;
import com.dataiku.dip.datasets.sql.ExternalSQLDatasetTestHandler;
import com.dataiku.dip.datasets.sql.ManagedSQLTableDatasetTestHandler;
import com.dataiku.dip.datasets.statsdb.StatsDBDatasetTestHandler;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.datasets.PartitionsDetectionService;
import com.dataiku.dip.server.datasets.SQLCommentService;
import com.dataiku.dip.server.datasets.TestSchemaConsistencyFutureThread;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DatasetsTestController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PartitionsDetectionService partitionsDetectionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetDeletionService deletionService;
    @Autowired
    private ManagedDatasetsCreationService mdcService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private SQLCommentService sqlCommentService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.controllers.test");

    private Dataset parseDatasetWithFallbackName(String data, String defaultProjectKey, String defaultName, HttpServletRequest req, boolean allowNoConnection) throws Exception {
        SerializedDataset sds = (SerializedDataset)JSON.parse((String)data, SerializedDataset.class);
        if (sds.getParams().getConnection() == null) {
            if (!allowNoConnection) {
                throw new IllegalArgumentException("A connection is required but was not found");
            }
        } else {
            this.connectionsService.checkUserForConnection(this.authService.getMandatoryUser(req), sds.getParams().getConnection());
        }
        return Dataset.fromSerialized((sds.projectKey == null ? defaultProjectKey : sds.projectKey) + "." + (sds.name == null ? defaultName : sds.name), sds);
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/test-general-partitioning"})
    public void testGeneralPartitioning(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        Dataset dataset;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, true);
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
        DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)this.partitionsDetectionService.testGeneralPartitioning(authCtx, dataset));
        this.auditTrailService.generic("dataset-test-partitioning").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/test-file-partitioning"})
    public void testPartitioning(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        Dataset dataset;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, true);
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
        DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)this.partitionsDetectionService.testFilePartitioning(authCtx, dataset, false));
        this.auditTrailService.generic("dataset-test-partitioning").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/detect-file-partitioning"})
    public void detectPartitioning(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        Dataset dataset;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, true);
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
        DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)this.partitionsDetectionService.testFilePartitioning(authCtx, dataset, true));
        this.auditTrailService.generic("dataset-detect-partitioning").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/test-schema-consistency"})
    public void testSchemaConsistency(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        AuthCtx authCtx = null;
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, true);
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
        DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.runAndWait(new TestSchemaConsistencyFutureThread(authCtx, dataset), (TypeToken)new TypeToken<FutureResponse<DatasetTestHandler.SchemaConsistencyResult>>(){}));
        this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/test-schema-consistency-on-all-files"})
    public void testSchemaConsistencyOnAllFiles(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        AuthCtx authCtx = null;
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, true);
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
        DatasetsTestController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new TestSchemaConsistencyOnAllFilesFutureThread(authCtx, dataset), 0L, new TypeToken<FutureResponse<FileFormatDatasetTestHandler.AllFilesSchemaConsistencyResult>>(){}));
        this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/push-column-descriptions-to-table"})
    public void pushColumnDescriptionsToTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam String newSchema, @RequestParam String detectedSchema) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkWriteProjectContentAllowed(this.authService.getMandatoryUser(req));
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
        }
        List schema = (List)JSON.parse((String)newSchema, (TypeToken)new TypeToken<List<SchemaColumn>>(){});
        List oldSchema = (List)JSON.parse((String)detectedSchema, (TypeToken)new TypeToken<List<SchemaColumn>>(){});
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
        DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.runAndWait(new PushColumnDescriptionsToTableFutureThread(authCtx, dataset, schema, oldSchema), (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){}));
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/test-and-detect-format"})
    public void detectFormat(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="data") String data, @RequestParam(value="testConfiguredFormat", defaultValue="false", required=false) boolean testConfiguredFormat, @RequestParam(value="detectPossibleFormats", defaultValue="false", required=false) boolean detectPossibleFormats, @RequestParam(value="inferStorageTypes", defaultValue="false", required=false) boolean inferStorageTypes) throws Exception {
        AuthCtx authCtx = null;
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, true);
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
        DatasetsTestController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new TestAndDetectFormatFutureThread(authCtx, dataset, detectPossibleFormats, false, null, inferStorageTypes), 1000L, new TypeToken<FutureResponse<FSLikeDatasetTestHandler.FSLikeDatasetTestResult>>(){}));
        this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
    }

    @AuditedCall(value={"msgType", "dataset-schema-reload", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @ResponseBody
    @RequestMapping(value={"/api/datasets/reload-schema"}, method={RequestMethod.POST})
    public void reloadSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String datasetName) throws Exception {
        SerializedDataset sd;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
        }
        logger.infoV("Reloading schema from data for project=%s dataset=%s", new Object[]{projectKey, datasetName});
        logger.infoV("Schema before: %s", new Object[]{JSON.json((Object)sd.getSchema())});
        Schema newSchema = this.getSchemaForReload(authCtx, sd);
        if (newSchema != null) {
            logger.info((Object)"A schema update is required");
            try (RWTransaction rwTransaction = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
                sd.setSchema(newSchema);
                this.datasetSaveService.save(projectKey, datasetName, sd, authCtx);
                rwTransaction.commit("Update schema of " + datasetName + " from data");
            }
        }
    }

    private Schema getSchemaForReload(AuthCtx authCtx, SerializedDataset sd) throws Exception {
        if (sd.type.startsWith("Sample_")) {
            try (SampleDatasetHandler dh = (SampleDatasetHandler)DatasetHandlerFactory.build(authCtx, Dataset.fromSerialized(sd));){
                Schema schema;
                Schema schema2 = schema = dh.getSchemaForSampleDataset();
                return schema2;
            }
        }
        DatasetTestHandler.SchemaConsistencyResult response = (DatasetTestHandler.SchemaConsistencyResult)this.futureService.runAndWait(new TestSchemaConsistencyFutureThread(authCtx, Dataset.fromSerialized(sd)), (TypeToken)new TypeToken<FutureResponse<DatasetTestHandler.SchemaConsistencyResult>>(){});
        logger.infoV("Schema consistency result: %s", new Object[]{JSON.json((Object)response)});
        if (!response.empty && response.result.warningLevel != null) {
            return response.result.detectedSchema;
        }
        return null;
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/detect-one-format"})
    public void detectOneFormat(HttpServletRequest req, HttpServletResponse resp, String projectKey, String data, @RequestParam String format) throws Exception {
        AuthCtx authCtx = null;
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, true);
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
        DatasetsTestController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new TestAndDetectFormatFutureThread(authCtx, dataset, false, true, format, false), 1000L, new TypeToken<FutureResponse<FSLikeDatasetTestHandler.FSLikeDatasetTestResult>>(){}));
        this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/managed-sql/test"})
    public void testManagedSQL(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="data") String data, @RequestParam(value="connectionOnly", defaultValue="false", required=false) boolean connectionOnly) throws Exception {
        ManagedSQLTableDatasetTestHandler testHandler;
        Dataset dataset;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, false);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(liu, dataset, ManagedSQLTableDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)liu, (String)dataset.getProjectKey(), (String)dataset.getName()));
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(connectionOnly, liu));
        }
        finally {
            testHandler.close();
        }
    }

    @ResponseBody
    @AuditInline
    @RequestMapping(value={"/api/datasets/managed-sql/test-dataset-storage-conflicts"}, method={RequestMethod.POST})
    public DatasetStorageConflictDetector.DatasetConflictsCheckResult testDatasetStorageConflict(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="data") String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.parseDatasetWithFallbackName(data, projectKey, "::fakeDataset", req, false);
            DatasetStorageConflictDetector duplicateFinder = new DatasetStorageConflictDetector(dataset.getProjectKey());
            this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetName", dataset.getName()).emit();
            DatasetStorageConflictDetector.DatasetConflictsCheckResult datasetConflictsCheckResult = duplicateFinder.findConflictsFor(dataset.getModel());
            return datasetConflictsCheckResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/managed-sql/create-table"}, method={RequestMethod.POST})
    public void createManagedSQLTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String data) throws Exception {
        DatasetHandler dh;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, false);
            dh = DatasetHandlerFactory.build(authCtx, dataset);
        }
        try {
            dh.createManaged();
        }
        finally {
            dh.close();
        }
        this.auditTrailService.generic("dataset-table-ddl").with("projectKey", projectKey).with("datasetName", dataset.getName()).with("op", "create").emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/check-name-safety"}, method={RequestMethod.POST})
    public void checkNameSafety(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String data) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        DatasetTestHandler dth = null;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseService.failIfLocked();
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ManagedDatasetsCreationService.ManagedDatasetCreationSettings creationSettings = (ManagedDatasetsCreationService.ManagedDatasetCreationSettings)JSON.parse((String)data, ManagedDatasetsCreationService.ManagedDatasetCreationSettings.class);
            if (!creationSettings.inlineDataset) {
                Dataset newDataset = this.mdcService.prepare(authCtx, projectKey, datasetName, creationSettings);
                DatasetHandler dh = DatasetHandlerFactory.build(authCtx, newDataset);
                dth = dh.buildTestHandler();
                ret.mergeFrom(new DatasetStorageConflictDetector(projectKey).findConflictsFor(newDataset.getModel()).toInfoMessages());
            }
        }
        if (dth != null) {
            try {
                ret.mergeFrom(dth.checkManagedDatasetNameSafety(datasetName));
            }
            finally {
                dth.close();
            }
        }
        DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/managed-sql/drop-table"}, method={RequestMethod.POST})
    public void dropManagedSQLTest(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String data) throws Exception {
        AuthCtx authCtx = null;
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, false);
        }
        DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)this.deletionService.clearDatasetData_NT(authCtx, dataset, true, true));
        this.auditTrailService.generic("dataset-table-ddl").with("projectKey", projectKey).with("datasetName", dataset.getName()).with("op", "drop").emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/external-sql/test"})
    public void testExternalSQL(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String data, @RequestParam(value="maxSamples", defaultValue="15", required=false) int maxSamples, @RequestParam boolean listTables, @RequestParam boolean testTableOrQuery, @RequestParam(defaultValue="false", required=false) boolean getTableMetadata) throws Exception {
        ExternalSQLDatasetTestHandler testHandler;
        Dataset dataset;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, false);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(liu, dataset, ExternalSQLDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)liu, (String)dataset.getProjectKey(), (String)dataset.getName()));
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(listTables, testTableOrQuery, getTableMetadata, liu));
        }
        finally {
            testHandler.close();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/external-sql/preview"})
    @ResponseBody
    public FutureResponse<ExternalSQLDatasetTestHandler.ExternalSQLDatasetTestResult> previewExternalSQL(HttpServletRequest req, String data) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
        }
        AbstractSQLDatasetHandler.AbstractSQLConfig params = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        AuditTrailService.EmittableAuditObj auditObj = this.auditTrailService.generic("sql-dataset-preview").with("connection", params.connection).with("table", params.table);
        if (StringUtils.isNotBlank((String)params.catalog)) {
            auditObj.with("catalog", params.catalog);
        }
        if (StringUtils.isNotBlank((String)params.schema)) {
            auditObj.with("schema", params.schema);
        }
        auditObj.emit();
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
        PreviewExternalSQLFutureThread futureThread = new PreviewExternalSQLFutureThread(authCtx, dataset);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<ExternalSQLDatasetTestHandler.ExternalSQLDatasetTestResult>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/external-sql/list-partitions"})
    public void listPartitionsExternalSQL(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        ExternalSQLDatasetTestHandler testHandler;
        Dataset dataset;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, false);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(liu, dataset, ExternalSQLDatasetTestHandler.class);
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)liu, (String)projectKey, (String)dataset.getName()));
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, testHandler.listPartitions(liu));
        }
        finally {
            testHandler.close();
        }
        this.auditTrailService.generic("dataset-list-partitions").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/elasticsearch/list-indices"}, method={RequestMethod.POST})
    public void listElasticSearchIndices(HttpServletRequest req, HttpServletResponse resp, String projectKey, String data) throws Exception {
        ElasticSearchDatasetTestHandler testHandler;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            Dataset dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, false);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, ElasticSearchDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-elastic-search-list-indices").with("projectKey", projectKey).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, testHandler.listIndicesWithCount());
        }
        finally {
            testHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/elasticsearch/test"})
    public void testElasticSearch(HttpServletRequest req, HttpServletResponse resp, String projectKey, String data, @RequestParam(value="connectionOnly", defaultValue="false", required=false) boolean connectionOnly) throws Exception {
        ElasticSearchDatasetTestHandler testHandler;
        Dataset dataset;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, false);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, ElasticSearchDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(projectKey, dataset, connectionOnly, false));
        }
        finally {
            testHandler.close();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/elasticsearch/preview"})
    @ResponseBody
    public FutureResponse<ElasticSearchDatasetTestHandler.TestResult> previewExternalElasticSearch(HttpServletRequest req, String data) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
        }
        ElasticSearchDatasetHandler.Config config = dataset.getParamsAs(ElasticSearchDatasetHandler.Config.class);
        AuditTrailService.EmittableAuditObj auditObj = this.auditTrailService.generic("elasticsearch-dataset-preview").with("connection", config.connection).with("index", config.index);
        auditObj.emit();
        PreviewExternalElasticSearchFutureThread futureThread = new PreviewExternalElasticSearchFutureThread(authCtx, dataset);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<ElasticSearchDatasetTestHandler.TestResult>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/mongodb/test"})
    public void testMongoDB(HttpServletRequest req, HttpServletResponse resp, String projectKey, String data, @RequestParam(value="connectionOnly", defaultValue="false", required=false) boolean connectionOnly, @RequestParam(value="inferStorageTypes", defaultValue="false", required=false) boolean inferStorageTypes) throws Exception {
        MongoDBDatasetTestHandler testHandler;
        Dataset dataset;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, MongoDBDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(projectKey, dataset, connectionOnly, false, inferStorageTypes));
        }
        finally {
            testHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/mongodb/create-collection"})
    public void createMongoDBCollection(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        DatasetHandler handler;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
            handler = DatasetHandlerFactory.build(authCtx, dataset);
        }
        try {
            handler.createManaged();
        }
        finally {
            handler.close();
        }
        this.auditTrailService.generic("dataset-mongodb-ddl").with("projectKey", dataset.getProjectKey()).with("datasetName", dataset.getName()).with("op", "create").emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/mongodb/delete-collection"})
    public void dropMongoDBCollection(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        DatasetHandler handler;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
            handler = DatasetHandlerFactory.build(authCtx, dataset);
        }
        try {
            handler.clearAllDataAndStructure();
        }
        finally {
            handler.close();
        }
        this.auditTrailService.generic("dataset-mongodb-ddl").with("projectKey", dataset.getProjectKey()).with("datasetName", dataset.getName()).with("op", "drop").emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/sharepointonlinelist/test"})
    public void testSharePointOnlineList(HttpServletRequest req, HttpServletResponse resp, String projectKey, String data, @RequestParam(value="connectionOnly", defaultValue="false", required=false) boolean connectionOnly, @RequestParam(value="inferStorageTypes", defaultValue="false", required=false) boolean inferStorageTypes) throws Exception {
        SharePointOnlineListDatasetTestHandler testHandler;
        Dataset dataset;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, SharePointOnlineListDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(projectKey, dataset, connectionOnly, false, inferStorageTypes));
        }
        finally {
            testHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/dynamodb/test"})
    public void testDynamoDB(HttpServletRequest req, HttpServletResponse resp, String projectKey, String data, @RequestParam(value="connectionOnly", defaultValue="false", required=false) boolean connectionOnly, @RequestParam(value="inferStorageTypes", defaultValue="false", required=false) boolean inferStorageTypes, @RequestParam(value="listTables", defaultValue="false", required=false) boolean listTables) throws Exception {
        DynamoDBDatasetTestHandler testHandler;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, DynamoDBDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(projectKey, dataset, connectionOnly, false, inferStorageTypes, listTables));
        }
        finally {
            testHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/dynamodb/create-table"})
    public void createDynamoDBCollection(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        DatasetHandler handler;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
            handler = DatasetHandlerFactory.build(authCtx, dataset);
        }
        try {
            handler.createManaged();
        }
        finally {
            handler.close();
        }
        this.auditTrailService.generic("dataset-dynamodb-ddl").with("projectKey", dataset.getProjectKey()).with("datasetName", dataset.getName()).with("op", "create").emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/dynamodb/delete-table"})
    public void dropDynamoDBCollection(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        DatasetHandler handler;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
            handler = DatasetHandlerFactory.build(authCtx, dataset);
        }
        try {
            handler.clearAllDataAndStructure();
        }
        finally {
            handler.close();
        }
        this.auditTrailService.generic("dataset-dynamodb-ddl").with("projectKey", dataset.getProjectKey()).with("datasetName", dataset.getName()).with("op", "drop").emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/dynamodb/update-index"})
    public void updateDynamoDBIndex(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        DynamoDBDatasetHandler handler;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
            handler = (DynamoDBDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);
        }
        try {
            handler.updateIndex();
        }
        finally {
            handler.close();
        }
        this.auditTrailService.generic("dataset-dynamodb-ddl").with("projectKey", dataset.getProjectKey()).with("datasetName", dataset.getName()).with("op", "updateIndex").emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/cassandra/test"})
    public void testCassandra(HttpServletRequest req, HttpServletResponse resp, String projectKey, String data, @RequestParam(value="connectionOnly", defaultValue="false", required=false) boolean connectionOnly) throws Exception {
        CassandraDatasetTestHandler testHandler;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, false);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, CassandraDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(connectionOnly));
        }
        finally {
            testHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/cassandra/create-table"})
    public void createCassandraTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        DatasetHandler handler;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
            handler = DatasetHandlerFactory.build(authCtx, dataset);
        }
        try {
            handler.createManaged();
        }
        finally {
            handler.close();
        }
        this.auditTrailService.generic("dataset-cassandra-ddl").with("projectKey", dataset.getProjectKey()).with("datasetName", dataset.getName()).with("op", "create").emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/cassandra/drop-table"})
    public void dropCassandraTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        DatasetHandler handler;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, false);
            handler = DatasetHandlerFactory.build(authCtx, dataset);
        }
        try {
            handler.clearAllDataAndStructure();
        }
        finally {
            handler.close();
        }
        this.auditTrailService.generic("dataset-cassandra-ddl").with("projectKey", dataset.getProjectKey()).with("datasetName", dataset.getName()).with("op", "drop").emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/custom-dataset/test"})
    public void testCustomPython(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dataset, @RequestParam boolean showPreview) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset datasetObj = this.parseDatasetWithFallbackName(dataset, projectKey, "fakeDataset", req, true);
            CustomDatasetTestHandler testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, datasetObj, CustomDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-test").with("projectKey", datasetObj.getProjectKey()).with("datasetType", datasetObj.getType()).with("datasetName", datasetObj.getName()).emit();
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)projectKey, (String)datasetObj.getName()));
            TestCustomPythonDatasetThread ft = new TestCustomPythonDatasetThread(authCtx, testHandler, showPreview);
            DatasetsTestController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<CustomDatasetTestHandler.CPDTestResult>>(){}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/editable/test"})
    public void testEditable(HttpServletRequest req, HttpServletResponse resp, String projectKey, @RequestParam String dataset) throws Exception {
        InlineDatasetTestHandler testHandler;
        Dataset ds;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ds = this.parseDatasetWithFallbackName(dataset, "fakeProject", "fakeDataset", req, true);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(liu, ds, InlineDatasetTestHandler.class);
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.testAsEditable(liu, ds));
        }
        finally {
            testHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/labels/test"})
    public void testLabels(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String data) throws Exception {
        LabelsDatasetTestHandler testHandler;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(liu, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, true);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(liu, dataset, LabelsDatasetTestHandler.class);
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(liu));
        }
        finally {
            testHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/jobsdb/test"})
    public void testMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String data) throws Exception {
        JobsdbDatasetTestHandler testHandler;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, true);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(liu, dataset, JobsdbDatasetTestHandler.class);
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(liu));
        }
        finally {
            testHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/statsdb/test"})
    public void testStats(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String data) throws Exception {
        StatsDBDatasetTestHandler testHandler;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, true);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(liu, dataset, StatsDBDatasetTestHandler.class);
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(liu));
        }
        finally {
            testHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/experimentsdb/test"})
    public void testMLflow(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String data) throws Exception {
        ExperimentsDBDatasetTestHandler testHandler;
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, true);
            ExperimentsDBDatasetParams params = dataset.getParamsAs(ExperimentsDBDatasetParams.class);
            dataset.setSchema(ExperimentsDBDatasetHandler.getSchema(params.scope, params.format));
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(liu, dataset, ExperimentsDBDatasetTestHandler.class);
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.test(liu));
        }
        finally {
            testHandler.close();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/list-partitions"})
    public void listPartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            dataset = this.parseDatasetWithFallbackName(data, "fakeProject", "fakeDataset", req, true);
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
        ArrayList<String> list = new ArrayList<String>();
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);){
            for (Partition p : PartitioningUtils.sort(dh.listPartitions(), true)) {
                list.add(p.id());
            }
        }
        DatasetsTestController.writeJSON((HttpServletResponse)resp, list);
        this.auditTrailService.generic("dataset-list-partitions").with("projectKey", dataset.getProjectKey()).with("datasetName", dataset.getName()).emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/datasets/sql/check-spark-integration"})
    public void checkSQLSparkIntegration(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String data) throws Exception {
        AbstractSQLDatasetTestHandler testHandler;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset dataset = this.parseDatasetWithFallbackName(data, projectKey, "fakeDataset", req, false);
            testHandler = DatasetHandlerFactory.buildTestHandlerAs(liu, dataset, AbstractSQLDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-test").with("projectKey", dataset.getProjectKey()).with("datasetType", dataset.getType()).with("datasetName", dataset.getName()).emit();
        }
        try {
            DatasetsTestController.writeJSON((HttpServletResponse)resp, (Object)testHandler.checkSparkIntegration());
        }
        finally {
            testHandler.close();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/datasets/sample/test"})
    public void testSample(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dataset) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Dataset datasetObj = this.parseDatasetWithFallbackName(dataset, projectKey, "fakeDataset", req, true);
            SampleDatasetTestHandler testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, datasetObj, SampleDatasetTestHandler.class);
            this.auditTrailService.generic("dataset-test").with("projectKey", datasetObj.getProjectKey()).with("datasetType", datasetObj.getType()).with("datasetName", datasetObj.getName()).emit();
            TestSampleDatasetThread ft = new TestSampleDatasetThread(authCtx, testHandler);
            DatasetsTestController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<FSLikeDatasetTestHandler.FSLikeDatasetTestResult>>(){}));
        }
    }

    static class TestSchemaConsistencyOnAllFilesFutureThread
    extends SimpleFutureThread<FileFormatDatasetTestHandler.AllFilesSchemaConsistencyResult> {
        private final Dataset dataset;

        public TestSchemaConsistencyOnAllFilesFutureThread(AuthCtx authCtx, Dataset dataset) {
            super(authCtx);
            this.dataset = dataset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FileFormatDatasetTestHandler.AllFilesSchemaConsistencyResult compute() throws Exception {
            FileFormatDatasetTestHandler handler;
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            try (Transaction t = transactionService.beginRead();){
                handler = DatasetHandlerFactory.buildTestHandlerAs(this.owner, this.dataset, FileFormatDatasetTestHandler.class);
            }
            try {
                FileFormatDatasetTestHandler.AllFilesSchemaConsistencyResult allFilesSchemaConsistencyResult = handler.checkConsistencyOnAllFiles(this.owner);
                return allFilesSchemaConsistencyResult;
            }
            finally {
                handler.close();
            }
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "test-dataset-schema-consistency";
            fp.displayName = "Test dataset schema consistency";
            return fp;
        }

        @Override
        public double getDangerosity() {
            return 1.0;
        }

        static {
            JSON.registerAdapter(TestSchemaConsistencyOnAllFilesFutureThread.class, (Object)new JSON.Adapter<TestSchemaConsistencyOnAllFilesFutureThread>(){

                public TestSchemaConsistencyOnAllFilesFutureThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                    String datasetFullName = jsonObj.get("datasetFullName").getAsString();
                    SerializedDataset serializedDataset = (SerializedDataset)ctx.deserialize(jsonObj.get("dataset"), SerializedDataset.class);
                    Dataset inputDataset = Dataset.fromSerialized(datasetFullName, serializedDataset);
                    return new TestSchemaConsistencyOnAllFilesFutureThread((AuthCtx)owner, inputDataset);
                }

                public JsonElement serialize(TestSchemaConsistencyOnAllFilesFutureThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.addProperty("datasetFullName", ft.dataset.getFullName());
                    ret.add("dataset", ctx.serialize((Object)ft.dataset.serialize()));
                    ret.add("owner", ctx.serialize((Object)ft.owner));
                    return ret;
                }
            });
        }
    }

    public class PushColumnDescriptionsToTableFutureThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        private final Dataset dataset;
        private final AuthCtx authCtx;
        private final List<SchemaColumn> newSchema;
        private final List<SchemaColumn> oldSchema;

        public PushColumnDescriptionsToTableFutureThread(AuthCtx authCtx, Dataset dataset, List<SchemaColumn> schema, List<SchemaColumn> oldSchema) {
            super(authCtx);
            this.dataset = dataset;
            this.authCtx = authCtx;
            this.newSchema = schema;
            this.oldSchema = oldSchema;
        }

        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            List<SchemaColumn> updatedColumns = DatasetsTestController.this.sqlCommentService.getColumnsWithEditedComments(this.oldSchema, this.newSchema);
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            DatasetsTestController.this.sqlCommentService.writeColumnsCommentsToTable(this.authCtx, this.dataset, updatedColumns, messages);
            return messages;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"push-column-descriptions-to-table", (String)"Push column descriptions to table");
        }
    }

    public static class TestAndDetectFormatFutureThread
    extends SimpleFutureThread<FSLikeDatasetTestHandler.FSLikeDatasetTestResult> {
        private final Dataset dataset;
        private final boolean detect;
        private final boolean detectOneFormat;
        private final String limitToFormat;
        private final boolean inferStorageTypes;

        public TestAndDetectFormatFutureThread(AuthCtx authCtx, Dataset dataset, boolean detect, boolean detectOneFormat, String limitToFormat, boolean inferStorageTypes) {
            super(authCtx);
            this.dataset = dataset;
            this.detect = detect;
            this.detectOneFormat = detectOneFormat;
            this.limitToFormat = limitToFormat;
            this.inferStorageTypes = inferStorageTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FSLikeDatasetTestHandler.FSLikeDatasetTestResult compute() throws Exception {
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            FileFormatDatasetTestHandler testHandler = null;
            NDC.push((String)("test-" + this.dataset.getType()));
            try {
                FSLikeDatasetTestHandler.FSLikeDatasetTestResult fSLikeDatasetTestResult;
                block21: {
                    block20: {
                        try (Transaction t = transactionService.beginRead();){
                            testHandler = DatasetHandlerFactory.buildTestHandlerAs(this.owner, this.dataset, FileFormatDatasetTestHandler.class);
                        }
                        catch (Exception e) {
                            logger.error((Object)"Failed to create test handler", (Throwable)e);
                            FSLikeDatasetTestHandler.FSLikeDatasetTestResult fakeResult = new FSLikeDatasetTestHandler.FSLikeDatasetTestResult();
                            fakeResult.connectionError = new SerializedError((Throwable)e, false);
                            FSLikeDatasetTestHandler.FSLikeDatasetTestResult fSLikeDatasetTestResult2 = fakeResult;
                            NDC.pop();
                            return fSLikeDatasetTestResult2;
                        }
                        try {
                            if (!this.detectOneFormat) break block20;
                            fSLikeDatasetTestResult = testHandler.detectOneFormat(this.owner, this.limitToFormat);
                        }
                        catch (Throwable throwable) {
                            testHandler.close();
                            throw throwable;
                        }
                        testHandler.close();
                        return fSLikeDatasetTestResult;
                    }
                    if (!this.detect) break block21;
                    fSLikeDatasetTestResult = testHandler.detectFormats(this.owner);
                    testHandler.close();
                    return fSLikeDatasetTestResult;
                }
                fSLikeDatasetTestResult = testHandler.testFormat(this.owner, false, this.inferStorageTypes);
                testHandler.close();
                return fSLikeDatasetTestResult;
            }
            finally {
                NDC.pop();
            }
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "test-fslike-dataset";
            fp.displayName = "Test files-based dataset";
            return fp;
        }

        @Override
        public double getDangerosity() {
            return 1.0;
        }

        static {
            JSON.registerAdapter(TestAndDetectFormatFutureThread.class, (Object)new JSON.Adapter<TestAndDetectFormatFutureThread>(){

                public TestAndDetectFormatFutureThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                    String datasetFullName = jsonObj.get("datasetFullName").getAsString();
                    SerializedDataset dataset = (SerializedDataset)ctx.deserialize(jsonObj.get("dataset"), SerializedDataset.class);
                    Dataset inputDataset = Dataset.fromSerialized(datasetFullName, dataset);
                    boolean detect = jsonObj.get("detect").getAsBoolean();
                    boolean detectOneFormat = jsonObj.get("detectOneFormat").getAsBoolean();
                    String limitToFormat = jsonObj.has("limitToFormat") ? jsonObj.get("limitToFormat").getAsString() : null;
                    boolean inferStorageTypes = jsonObj.get("inferStorageTypes").getAsBoolean();
                    return new TestAndDetectFormatFutureThread(owner, inputDataset, detect, detectOneFormat, limitToFormat, inferStorageTypes);
                }

                public JsonElement serialize(TestAndDetectFormatFutureThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.addProperty("datasetFullName", ft.dataset.getFullName());
                    ret.add("dataset", ctx.serialize((Object)ft.dataset.serialize()));
                    ret.add("detect", ctx.serialize((Object)ft.detect));
                    ret.add("detectOneFormat", ctx.serialize((Object)ft.detectOneFormat));
                    ret.add("limitToFormat", ctx.serialize((Object)ft.limitToFormat));
                    ret.add("inferStorageTypes", ctx.serialize((Object)ft.inferStorageTypes));
                    ret.add("owner", ctx.serialize((Object)ft.owner));
                    return ret;
                }
            });
        }
    }

    class PreviewExternalSQLFutureThread
    extends SimpleFutureThread<ExternalSQLDatasetTestHandler.ExternalSQLDatasetTestResult> {
        private final Dataset dataset;

        public PreviewExternalSQLFutureThread(AuthCtx owner, Dataset dataset) {
            super(owner);
            this.dataset = dataset;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"preview_column", (String)"Preview column");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExternalSQLDatasetTestHandler.ExternalSQLDatasetTestResult compute() throws Exception {
            ExternalSQLDatasetTestHandler testHandler;
            try (Transaction t = DatasetsTestController.this.transactionService.beginRead();){
                testHandler = DatasetHandlerFactory.buildTestHandlerAs(this.owner, this.dataset, ExternalSQLDatasetTestHandler.class);
            }
            try {
                ExternalSQLDatasetTestHandler.ExternalSQLDatasetTestResult externalSQLDatasetTestResult = testHandler.test(false, true, this.owner);
                return externalSQLDatasetTestResult;
            }
            finally {
                testHandler.close();
            }
        }
    }

    class PreviewExternalElasticSearchFutureThread
    extends SimpleFutureThread<ElasticSearchDatasetTestHandler.TestResult> {
        private final Dataset dataset;

        public PreviewExternalElasticSearchFutureThread(AuthCtx owner, Dataset dataset) {
            super(owner);
            this.dataset = dataset;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"preview_column", (String)"Preview column");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ElasticSearchDatasetTestHandler.TestResult compute() throws Exception {
            ElasticSearchDatasetTestHandler testHandler;
            try (Transaction t = DatasetsTestController.this.transactionService.beginRead();){
                testHandler = DatasetHandlerFactory.buildTestHandlerAs(this.owner, this.dataset, ElasticSearchDatasetTestHandler.class);
            }
            try {
                ElasticSearchDatasetTestHandler.TestResult testResult = testHandler.test(null, this.dataset, false, false);
                return testResult;
            }
            finally {
                testHandler.close();
            }
        }
    }

    private static class TestCustomPythonDatasetThread
    extends SimpleFutureThread<CustomDatasetTestHandler.CPDTestResult> {
        private final CustomDatasetTestHandler testHandler;
        private final boolean showPreview;

        public TestCustomPythonDatasetThread(AuthCtx authCtx, CustomDatasetTestHandler testHandler, boolean showPreview) {
            super(authCtx);
            this.testHandler = testHandler;
            this.showPreview = showPreview;
        }

        @Override
        protected CustomDatasetTestHandler.CPDTestResult compute() throws Exception {
            try {
                CustomDatasetTestHandler.CPDTestResult cPDTestResult = this.testHandler.test(this.showPreview);
                return cPDTestResult;
            }
            finally {
                this.testHandler.close();
            }
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"test_custom_dataset", (String)"Test custom dataset");
        }
    }

    private static class TestSampleDatasetThread
    extends SimpleFutureThread<FSLikeDatasetTestHandler.FSLikeDatasetTestResult> {
        private final SampleDatasetTestHandler testHandler;

        public TestSampleDatasetThread(AuthCtx authCtx, SampleDatasetTestHandler testHandler) {
            super(authCtx);
            this.testHandler = testHandler;
        }

        @Override
        protected FSLikeDatasetTestHandler.FSLikeDatasetTestResult compute() throws Exception {
            try {
                FSLikeDatasetTestHandler.FSLikeDatasetTestResult fSLikeDatasetTestResult = this.testHandler.testFormat(this.owner, false, !this.testHandler.isSchemaInRealDataset());
                return fSLikeDatasetTestResult;
            }
            finally {
                this.testHandler.close();
            }
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"test_custom_dataset", (String)"Test sample dataset");
        }
    }
}

