/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.labeling.LabelingInternalDBService;
import com.dataiku.dip.labeling.LabelingPermissionsService;
import com.dataiku.dip.labeling.LabelingService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LabelingIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TicketAuthService authService;
    @Autowired
    private LabelingInternalDBService labelingInternalDBService;
    @Autowired
    private LabelingService labelingService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LabelingPermissionsService labelingPermissionsService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/labeling/load-metadata-if-needed"})
    public void loadDataIfNeeded(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String labelingTaskId) throws Exception {
        Dataset metadataDataset;
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);
             Transaction t = this.transactionService.beginRead();){
            authCtx = tu.getAuthCtx();
            labelingTask = this.labelingService.getLabelingTask(projectKey, labelingTaskId);
            metadataDataset = this.labelingService.getMetadataDataset(labelingTask);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.READ);
        }
        this.labelingInternalDBService.loadMetadataToInternalDbIfNeeded(authCtx, labelingTask, metadataDataset);
    }
}

