/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.server.notifications.markups.Markup;
import com.dataiku.dip.server.services.ITaggingService;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class MarkupFormatter {
    protected final Markup markup;
    final Map<String, String> userDisplayNames;

    public MarkupFormatter(Markup markup, List<UsersDAO.User> users) {
        this.markup = markup;
        this.userDisplayNames = Maps.newHashMap();
        for (UsersDAO.User user : users) {
            this.userDisplayNames.put(user.login, user.displayName);
        }
    }

    public abstract String root(String var1);

    public abstract String project(String var1, String var2, String var3);

    public String project(String projectKey, String displayName) {
        return this.project(projectKey, displayName, null);
    }

    public abstract String dataset(String var1, String var2, String var3);

    public abstract String streamingEndpoint(String var1, String var2, String var3, String var4);

    public abstract String recipe(String var1, String var2, String var3);

    public abstract String analysis(String var1, String var2, String var3, String var4);

    public abstract String savedModel(String var1, String var2, String var3, String var4);

    public abstract String modelEvaluationStore(String var1, String var2, String var3, String var4);

    public abstract String folder(String var1, String var2, String var3, String var4);

    public abstract String scenario(String var1, String var2, String var3, String var4);

    public String scenario(String projectKey, String id, String displayName) {
        return this.scenario(projectKey, id, displayName, null);
    }

    public abstract String scenarioRuns(String var1, String var2, String var3);

    public abstract String insight(String var1, String var2, String var3, String var4);

    public abstract String jupyterNotebook(String var1, String var2, String var3, String var4);

    public abstract String sqlNotebook(String var1, String var2, String var3, String var4);

    public abstract String searchNotebook(String var1, String var2, String var3, String var4);

    public abstract String lambdaService(String var1, String var2, String var3);

    public abstract String webapp(String var1, String var2, String var3, String var4);

    public abstract String codeStudio(String var1, String var2, String var3, String var4);

    public abstract String report(String var1, String var2, String var3, String var4);

    public abstract String article(String var1, String var2, String var3, String var4);

    public abstract String dashboard(String var1, String var2, String var3, String var4);

    public abstract String workspace(String var1, String var2, String var3);

    public String workspace(String workspaceKey, String displayName) {
        return this.workspace(workspaceKey, displayName, null);
    }

    public abstract String workspaceObject(String var1, ITaggingService.TaggableType var2, String var3, String var4, String var5, String var6);

    public abstract String request(String var1, String var2);

    public String dssObject(ITaggingService.TaggableType objectType, String projectKey, String objectId, String displayName, String discussionId) {
        displayName = displayName != null ? displayName : objectId;
        objectType.assertNotFakeType();
        switch (objectType) {
            case PROJECT: {
                return this.project(objectId, displayName, discussionId);
            }
            case DATASET: {
                return this.dataset(projectKey, objectId, discussionId);
            }
            case RECIPE: {
                return this.recipe(projectKey, objectId, discussionId);
            }
            case LABELING_TASK: {
                break;
            }
            case ANALYSIS: {
                return this.analysis(projectKey, objectId, displayName, discussionId);
            }
            case SAVED_MODEL: {
                return this.savedModel(projectKey, objectId, displayName, discussionId);
            }
            case MODEL_EVALUATION_STORE: {
                return this.modelEvaluationStore(projectKey, objectId, displayName, discussionId);
            }
            case SCENARIO: {
                return this.scenario(projectKey, objectId, displayName, discussionId);
            }
            case MANAGED_FOLDER: {
                return this.folder(projectKey, objectId, displayName, discussionId);
            }
            case JUPYTER_NOTEBOOK: {
                return this.jupyterNotebook(projectKey, objectId, displayName, discussionId);
            }
            case SQL_NOTEBOOK: {
                return this.sqlNotebook(projectKey, objectId, displayName, discussionId);
            }
            case SEARCH_NOTEBOOK: {
                return this.searchNotebook(projectKey, objectId, displayName, discussionId);
            }
            case LAMBDA_SERVICE: {
                return this.lambdaService(projectKey, objectId, discussionId);
            }
            case DASHBOARD: {
                return this.dashboard(projectKey, objectId, displayName, discussionId);
            }
            case INSIGHT: {
                return this.insight(projectKey, objectId, displayName, discussionId);
            }
            case WEB_APP: {
                return this.webapp(projectKey, objectId, displayName, discussionId);
            }
            case CODE_STUDIO: {
                return this.codeStudio(projectKey, objectId, displayName, discussionId);
            }
            case REPORT: {
                return this.report(projectKey, objectId, displayName, discussionId);
            }
            case ARTICLE: {
                return this.article(projectKey, objectId, displayName, discussionId);
            }
            case STREAMING_ENDPOINT: {
                return this.streamingEndpoint(projectKey, objectId, displayName, discussionId);
            }
            case FLOW_ZONE: {
                return StringUtils.isNotBlank((String)displayName) ? displayName : objectId;
            }
            case DATA_COLLECTION: {
                return this.dataCollection(objectId, displayName);
            }
        }
        return StringUtils.isNotBlank((String)displayName) ? displayName : objectId;
    }

    public String dssObject(ITaggingService.TaggableType objectType, String projectKey, String objectId, String displayName) {
        return this.dssObject(objectType, projectKey, objectId, displayName, null);
    }

    public String dssOrWorkspaceObject(ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey, String displayName, String discussionId) {
        if (displayName == null) {
            displayName = objectId;
        }
        if (StringUtils.isNotBlank((String)workspaceKey)) {
            if (StringUtils.isNotBlank((String)projectKey)) {
                return this.workspaceObject(workspaceKey, objectType, projectKey, objectId, displayName, discussionId);
            }
            return this.workspace(workspaceKey, displayName, discussionId);
        }
        return this.dssObject(objectType, projectKey, objectId, displayName, discussionId);
    }

    public String dssOrWorkspaceObject(ITaggingService.TaggableType objectType, String projectKey, String objectId, String workspaceKey, String displayName) {
        return this.dssOrWorkspaceObject(objectType, projectKey, objectId, workspaceKey, displayName, null);
    }

    public abstract String user(String var1, String var2);

    public abstract String job(String var1, String var2, String var3);

    public abstract String continuousActivity(String var1, String var2, String var3);

    public abstract String mlTask(String var1, String var2, MLTask.MLTaskType var3, String var4, String var5);

    public abstract String udm(String var1, String var2);

    public abstract String plugin(String var1, String var2);

    public abstract String connection(String var1, String var2);

    public abstract String dataCollection(String var1, String var2);

    public abstract String text(Object var1);

    public abstract String lineBreak();

    public abstract String nbspace();
}

