/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.server.notifications.emails.GrantedAccessEmailBuilder;
import com.dataiku.dip.server.notifications.emails.RequestAccessEmailBuilder;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RequestAccessEmailService {
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private RequestsService requestsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserSettingsService userSettingsService;
    private static final Set<Request.RequestType> ignoredPermissionTypes = Sets.newHashSet((Object[])new Request.RequestType[]{Request.RequestType.PROJECT_READ, Request.RequestType.PROJECT_WRITE});
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.access-request-email");

    @PostConstruct
    public void init() {
        this.pubSubService.subscribe("access-request", evt -> {
            Map<String, UserSettingsService.UserSettings> usersSettings;
            RequestAccessEmailBuilder emailBuilder = new RequestAccessEmailBuilder();
            List<String> logins = this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), evt.getRequest().objectProjectKey);
            try (Transaction ignored = this.transactionService.beginRead();){
                usersSettings = this.userSettingsService.getForUsers(logins);
            }
            for (Map.Entry<String, UserSettingsService.UserSettings> userSettings : usersSettings.entrySet()) {
                String toUser = userSettings.getKey();
                if (!userSettings.getValue().accessRequestEmails.enabled) continue;
                try {
                    emailBuilder.sendToUser(evt, toUser);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to send email to " + toUser + " for access request to project " + evt.getProjectKey()), (Throwable)e);
                }
            }
        });
        this.pubSubService.subscribe("access-granted", evt -> {
            GrantedAccessEmailBuilder emailBuilder = new GrantedAccessEmailBuilder();
            String toUser = evt.getUserLogin();
            if (!ignoredPermissionTypes.contains((Object)evt.getRequestType())) {
                UserSettingsService.UserSettings userSettings;
                try (Transaction ignored = this.transactionService.beginRead();){
                    userSettings = this.userSettingsService.getForUser(toUser);
                }
                if (userSettings.grantedAccessEmails.enabled) {
                    try {
                        emailBuilder.sendToUser(evt, toUser);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to send email to " + toUser + " for access granted to project " + evt.getProjectKey()), (Throwable)e);
                    }
                }
            }
        });
    }
}

