/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import java.util.ArrayList;

public class GroupingSchemaGenerator {
    private final Schema inputSchema;
    private final boolean schemalessSuffixing;

    public GroupingSchemaGenerator(Schema inputSchema) {
        this.inputSchema = inputSchema;
        this.schemalessSuffixing = false;
    }

    public GroupingSchemaGenerator(Schema inputSchema, boolean schemalessSuffixing) {
        this.inputSchema = inputSchema;
        this.schemalessSuffixing = schemalessSuffixing;
    }

    public static GroupingSchemaGenerator withSchemalessSuffixing(Schema inputSchema) {
        return new GroupingSchemaGenerator(inputSchema, true);
    }

    public Schema getBaseOutputSchema(GroupingRecipePayloadParams params, Integer identifierMaxLength) {
        Schema outputSchema = new Schema();
        SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer = this.schemalessSuffixing ? new SchemaUtils.SchemalessSafeColumnIdentifierSuffixer(identifierMaxLength) : new SchemaUtils.SafeColumnIdentifierSuffixer(identifierMaxLength, this.inputSchema);
        for (GroupingRecipePayloadParams.GroupingKey key : params.getResolvedGroupingKeys(this.inputSchema)) {
            SchemaColumn inCol = ExpressionUtils.getSchemaColumn(key.column, this.inputSchema, params.computedColumns);
            outputSchema.addColumn(inCol);
        }
        for (GroupingRecipePayloadParams.GroupingValue val : params.values) {
            if (val.column != null) {
                if (!val.hasAnyAggr()) continue;
                SchemaColumn inputSchemaColumn = ExpressionUtils.getSchemaColumn(val.column, this.inputSchema, params.computedColumns);
                for (SchemaColumn sc : val.getDerivedColumns(params, inputSchemaColumn.getType(), safeSuffixer)) {
                    outputSchema.addColumn(sc);
                }
                continue;
            }
            SchemaColumn customColumn = new SchemaColumn(val.customName, Type.DOUBLE);
            if (val.getType() != null) {
                customColumn.setType(val.getType());
                if (val.getType() == Type.ARRAY) {
                    SchemaColumn schemaColumn = customColumn.arrayContent = val.arrayContent != null ? val.arrayContent : new SchemaColumn("", Type.STRING);
                }
                if (val.getType() == Type.MAP) {
                    customColumn.mapKeys = val.mapKeys != null ? val.mapKeys : new SchemaColumn("", Type.STRING);
                    SchemaColumn schemaColumn = customColumn.mapValues = val.mapValues != null ? val.mapValues : new SchemaColumn("", Type.STRING);
                }
                if (val.getType() == Type.OBJECT) {
                    customColumn.objectFields = val.objectFields != null ? val.objectFields : new ArrayList();
                }
            }
            outputSchema.addColumn(customColumn);
        }
        if (params.globalCount) {
            outputSchema.addColumn(outputSchema.transmogrify("count"), Type.BIGINT);
        }
        return outputSchema;
    }
}

