/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.jobrunner.JobBackendLoggingContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LogsService {
    static File logsFolder = new File(System.getenv("DIP_HOME"), "run");
    private static DKULogger logger = DKULogger.getLogger((String)"dku.logs");

    public void streamLogs(String logName, boolean zipped, OutputStream out) throws IOException {
        if (StringUtils.isNotBlank((String)logName)) {
            File logFile = DKUFileUtils.getWithin((File)logsFolder, (String[])new String[]{logName});
            if (!zipped) {
                try (FileInputStream in = new FileInputStream(logFile);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            } else {
                this.zip(logFile, out);
            }
        } else {
            this.zip(this.listLogFiles(), out);
        }
    }

    public LogDesc getLogContent(String string) throws IOException {
        int defaultNumberOfLines = 1000;
        return this.getLogContent(string, defaultNumberOfLines);
    }

    public LogDesc getLogContent(String logName, int lines) throws IOException {
        String canonicalLogDir;
        File logFile = DKUFileUtils.getWithin((File)logsFolder, (String[])new String[]{logName});
        String canonicalFile = logFile.getCanonicalPath();
        if (!canonicalFile.startsWith(canonicalLogDir = logsFolder.getCanonicalPath())) {
            throw new SecurityException("Trying to read outside of logs dir");
        }
        return this.tail(logFile, lines);
    }

    private List<Path> listLogFiles() {
        ArrayList<Path> logFiles = new ArrayList<Path>();
        try {
            EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            Files.walkFileTree(logsFolder.toPath(), opts, 5, new LogFilesVisitor(logFiles));
        }
        catch (IOException e) {
            logger.warn((Object)"Listing log files failed", (Throwable)e);
        }
        return logFiles;
    }

    public List<LogDesc> listLogs() {
        List<Path> logPaths = this.listLogFiles();
        ArrayList logDescs = Lists.newArrayList();
        for (Path logPath : logPaths) {
            try {
                LogDesc log = new LogDesc(logPath.toFile());
                logDescs.add(log);
            }
            catch (Exception e) {
                logger.warn((Object)"Listing log files failed", (Throwable)e);
            }
        }
        return logDescs;
    }

    public static File getJobDotLogFile(String projectKey, String jobId) throws IOException, DKUSecurityException {
        return DKUApp.getFile((String[])new String[]{"jobs", projectKey, jobId, "log.log"});
    }

    public static File getOutputDotLogFile(String projectKey, String jobId) throws IOException, DKUSecurityException {
        return DKUApp.getFile((String[])new String[]{"jobs", projectKey, jobId, "output.log"});
    }

    public static File getJobBackendLogFile(String projectKey, String jobId, JobBackendLoggingContext.Topic topic) throws IOException, DKUSecurityException {
        return DKUApp.getFile((String[])new String[]{"jobs", projectKey, jobId, "log." + topic.suffix + ".log"});
    }

    public static File getJobFolder(String projectKey, String jobId) throws IOException, DKUSecurityException {
        return DKUApp.getFile((String[])new String[]{"jobs", projectKey, jobId});
    }

    public static File getActivityLogFile(String projectKey, String jobId, String activityId) throws IOException, DKUSecurityException {
        return ApplicationConfigurator.getFile((String[])new String[]{"jobs", projectKey, jobId, activityId + ".log"});
    }

    public static File getActivityBackendLogFile(String projectKey, String jobId, String activityId, JobBackendLoggingContext.Topic topic) throws IOException, DKUSecurityException {
        return ApplicationConfigurator.getFile((String[])new String[]{"jobs", projectKey, jobId, activityId + "." + topic.suffix + ".log"});
    }

    public static File getActivityLogAdditionalFile(String projectKey, String jobId, String activityId, String path) throws IOException, DKUSecurityException {
        return ApplicationConfigurator.getFile((String[])new String[]{"jobs", projectKey, jobId, activityId, path});
    }

    public static File getYarnLogFile(String projectKey, String jobId, String activityId, String yarnAppId) throws IOException, DKUSecurityException {
        return ApplicationConfigurator.getFile((String[])new String[]{"jobs", projectKey, jobId, activityId + "." + yarnAppId + ".log"});
    }

    public static File getK8SLogFile(String projectKey, String jobId, String activityId, String podName) throws IOException, DKUSecurityException {
        File jobsFolder = ApplicationConfigurator.getFile((String)"jobs");
        File jobFolder = FlowJobUtils.jobFolder(false, projectKey, jobId);
        File log = null;
        String expectedName = String.format("%s.pod.log", podName);
        for (File f : FileUtils.listFiles((File)jobFolder, (String[])new String[]{"log"}, (boolean)true)) {
            if (!f.getName().equals(expectedName)) continue;
            log = f;
        }
        if (log == null) {
            throw new IllegalArgumentException("Log file not found");
        }
        if (!DKUFileUtils.isWithin((File)jobsFolder, log)) {
            throw new DKUSecurityException("Trying to access a file outside the logs directory").withCode((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_PATH_ESCAPE);
        }
        if (!DKUFileUtils.isWithin((File)jobsFolder, (File)jobFolder)) {
            throw new DKUSecurityException("Trying to access a file outside the logs directory").withCode((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_PATH_ESCAPE);
        }
        return log;
    }

    LogDesc tail(File file, int lines) throws IOException {
        LogDesc log = new LogDesc(file);
        log.linesShown = lines;
        log.tail = FlowJobUtils.getSmartLogTail(DKUtils.tailFile((File)file, (int)lines), null);
        return log;
    }

    void zip(Iterable<Path> paths, OutputStream out) throws IOException {
        logger.info((Object)"Start compressed stream");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(out);){
            for (Path path : paths) {
                logger.info((Object)("Adding " + path.toString()));
                File file = path.toFile();
                LogDesc desc = new LogDesc(file);
                ZipArchiveEntry ae = zos.createArchiveEntry(file, desc.name);
                zos.putArchiveEntry(ae);
                try (FileInputStream is = new FileInputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                }
                zos.closeArchiveEntry();
            }
        }
    }

    void zip(File file, OutputStream out) throws IOException {
        logger.info((Object)"Start compressed stream");
        try (GZIPOutputStream zos = new GZIPOutputStream(out);
             FileInputStream is = new FileInputStream(file);){
            IOUtils.copy((InputStream)is, (OutputStream)zos);
        }
    }

    @UIModel
    public static class LogDesc {
        public String name;
        long totalSize;
        long lastModified;
        SmartLogTail tail;
        long linesShown;
        long tailSize;
        boolean truncated = true;

        public LogDesc(File file) {
            this.name = logsFolder.toURI().relativize(file.toURI()).getPath();
            this.totalSize = file.length();
            this.lastModified = file.lastModified();
        }

        public LogDesc(File file, File folder) {
            this.name = folder.toURI().relativize(file.toURI()).getPath();
            this.totalSize = file.length();
            this.lastModified = file.lastModified();
        }

        public String toString() {
            return this.name + "(size:" + this.totalSize + ", lastModified:" + this.lastModified + ")";
        }
    }

    public static class LogFilesVisitor
    extends SimpleFileVisitor<Path> {
        List<Path> logFiles;

        public LogFilesVisitor(List<Path> logFiles) {
            this.logFiles = logFiles;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attr) {
            String fileName = path.toFile().getName();
            if (attr.isRegularFile() && fileName.contains(".log") && !fileName.endsWith(".lck")) {
                this.logFiles.add(path);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

