/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.ProjectRunsSummary;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunKey;
import com.dataiku.dip.scheduler.scenarios.StepBasedScenarioRunner;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadablePartial;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScenarioReportsService {
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private CodeStudioObjectsDAO codeStudioObjectsDAO;
    Cache<ReportKey, ScenarioGantt> computedReportData = CacheBuilder.newBuilder().maximumSize(200L).build();
    Cache<ReportKey, ScenarioActivity> computedActivityData = CacheBuilder.newBuilder().maximumSize(200L).build();
    Cache<ReportKey, ScenarioDays> computedOutcomeData = CacheBuilder.newBuilder().maximumSize(200L).build();
    Cache<ReportKey, ProjectRunsSummary> computedOutcomeSummaryData = CacheBuilder.newBuilder().maximumSize(200L).build();
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenarios.reports.service");

    private ScenarioItem getOrCreate(List<ScenarioItem> items, ReportTargetItem target, ScenarioItem parent, String contextProjectKey) {
        String parentId = parent != null ? parent.getUniqueId() : null;
        for (ScenarioItem item : items) {
            if (parentId == null && item.parentId != null || parentId != null && !parentId.equals(item.parentId) || target == null && item.target != null || target != null && item.target == null || (target != null || item.target != null) && (target == null || !target.equals(item.target))) continue;
            return item;
        }
        ScenarioItem item = new ScenarioItem(SecretKeyGenerator.generate((int)8), target, parentId, contextProjectKey);
        items.add(item);
        return item;
    }

    public void invalidateCachedReports(Scenario scenario) throws SQLException {
        ReadOnlyJobsInternalDB.ScenarioRunsBoundaries minmax = this.jobsDatabaseService.getScenarioRunsBoundaries(scenario.getProjectKey(), scenario.getId());
        ArrayList outcomeToInvalidate = Lists.newArrayList();
        for (Map.Entry e : this.computedOutcomeData.asMap().entrySet()) {
            if (!((ReportKey)e.getKey()).intersects(scenario.getProjectKey(), scenario.getId(), minmax.minStart, minmax.maxEnd)) continue;
            outcomeToInvalidate.add((ReportKey)e.getKey());
        }
        logger.info((Object)("Found " + outcomeToInvalidate.size() + " reports to invalidate"));
        this.computedOutcomeData.invalidateAll((Iterable)outcomeToInvalidate);
        ArrayList outcomeSummaryToInvalidate = Lists.newArrayList();
        for (Map.Entry entry : this.computedOutcomeSummaryData.asMap().entrySet()) {
            if (!((ReportKey)entry.getKey()).intersects(scenario.getProjectKey(), scenario.getId(), minmax.minStart, minmax.maxEnd)) continue;
            outcomeSummaryToInvalidate.add((ReportKey)entry.getKey());
        }
        logger.info((Object)("Found " + outcomeSummaryToInvalidate.size() + " report summaries to invalidate"));
        this.computedOutcomeSummaryData.invalidateAll((Iterable)outcomeSummaryToInvalidate);
        ArrayList ganttToInvalidate = Lists.newArrayList();
        for (Map.Entry entry : this.computedReportData.asMap().entrySet()) {
            if (!((ReportKey)entry.getKey()).intersects(scenario.getProjectKey(), scenario.getId(), minmax.minStart, minmax.maxEnd)) continue;
            ganttToInvalidate.add((ReportKey)entry.getKey());
        }
        logger.info((Object)("Found " + ganttToInvalidate.size() + " reports to invalidate"));
        this.computedReportData.invalidateAll((Iterable)ganttToInvalidate);
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry e : this.computedActivityData.asMap().entrySet()) {
            if (!((ReportKey)e.getKey()).intersects(scenario.getProjectKey(), scenario.getId(), minmax.minStart, minmax.maxEnd)) continue;
            arrayList.add((ReportKey)e.getKey());
        }
        logger.info((Object)("Found " + arrayList.size() + " reports to invalidate"));
        this.computedActivityData.invalidateAll((Iterable)arrayList);
    }

    public void invalidateCachedReportsForProject(String projectKey) {
        List outcomeToInvalidate = this.computedOutcomeData.asMap().keySet().stream().filter(k -> StringUtils.isEmpty((String)k.projectKey) || k.projectKey.equals(projectKey)).collect(Collectors.toList());
        logger.info((Object)("Found " + outcomeToInvalidate.size() + " reports to invalidate"));
        this.computedOutcomeData.invalidateAll(outcomeToInvalidate);
        List outcomeSummaryToInvalidate = this.computedOutcomeSummaryData.asMap().keySet().stream().filter(k -> StringUtils.isEmpty((String)k.projectKey) || k.projectKey.equals(projectKey)).collect(Collectors.toList());
        logger.info((Object)("Found " + outcomeSummaryToInvalidate.size() + " report summaries to invalidate"));
        this.computedOutcomeSummaryData.invalidateAll(outcomeSummaryToInvalidate);
        List ganttToInvalidate = this.computedReportData.asMap().keySet().stream().filter(k -> StringUtils.isEmpty((String)k.projectKey) || k.projectKey.equals(projectKey)).collect(Collectors.toList());
        logger.info((Object)("Found " + ganttToInvalidate.size() + " reports to invalidate"));
        this.computedReportData.invalidateAll(ganttToInvalidate);
        List activityToInvalidate = this.computedActivityData.asMap().keySet().stream().filter(k -> StringUtils.isEmpty((String)k.projectKey) || k.projectKey.equals(projectKey)).collect(Collectors.toList());
        logger.info((Object)("Found " + activityToInvalidate.size() + " reports to invalidate"));
        this.computedActivityData.invalidateAll(activityToInvalidate);
    }

    public void invalidateCachedReports() throws SQLException {
        logger.info((Object)"Invalidating all scenario reports");
        this.computedOutcomeData.invalidateAll();
        this.computedOutcomeSummaryData.invalidateAll();
        this.computedReportData.invalidateAll();
        this.computedActivityData.invalidateAll();
    }

    public Callable<ScenarioGantt> getRunsReport(String scenarioId, DateTime fromDate, DateTime toDate, String ... projectKeys) throws Exception {
        ReportItem scenarioResult;
        List<ScenarioRun> scenarioRuns;
        ReadOnlyJobsInternalDB.ScenarioRunsBoundaries minmax = this.jobsDatabaseService.getScenarioRunsBoundaries(fromDate.getMillis(), toDate.getMillis(), projectKeys);
        ReportKey reportKey = new ReportKey(fromDate.getMillis(), toDate.getMillis(), projectKeys.length == 1 ? projectKeys[0] : null, scenarioId, minmax.minStart, minmax.maxEnd, minmax.notFinished);
        final ScenarioGantt report = (ScenarioGantt)this.computedReportData.getIfPresent((Object)reportKey);
        if (report != null && minmax.notFinished == 0) {
            logger.info((Object)"Report data cache hit");
            return new Callable<ScenarioGantt>(){

                @Override
                public ScenarioGantt call() throws Exception {
                    return report;
                }
            };
        }
        logger.info((Object)("Report data cache miss (" + minmax.notFinished + " running)"));
        if (StringUtils.isBlank((String)scenarioId)) {
            scenarioRuns = this.jobsDatabaseService.getRuns(fromDate.getMillis(), toDate.getMillis(), false, projectKeys);
        } else {
            assert (projectKeys.length == 1);
            scenarioRuns = this.jobsDatabaseService.getRuns(projectKeys[0], scenarioId, fromDate.getMillis(), toDate.getMillis(), false);
        }
        final ArrayList items = Lists.newArrayList();
        ArrayList columns = Lists.newArrayList();
        HashMap columnByScenarioRun = Maps.newHashMap();
        HashMap resultByScenarioRun = Maps.newHashMap();
        final HashMap contexts = Maps.newHashMap();
        ScenarioItem projectItem = null;
        for (ScenarioRun scenarioRun : scenarioRuns) {
            ReportItem triggerResult;
            ScenarioItem triggerItem;
            String projectKey = scenarioRun.getScenario().getProjectKey();
            ScenarioItem scenarioItem = this.getItemForScenario((List<ScenarioItem>)items, projectItem, scenarioRun, null);
            scenarioResult = scenarioRun.getResult();
            if (scenarioResult == null) {
                scenarioResult = scenarioRun.getEnd() <= 0L ? new ReportItem.ScenarioDone(scenarioItem.target).withStart(scenarioRun.getStart()).withEnd(DateTime.now().getMillis()) : new ReportItem.ScenarioDone(scenarioItem.target).withStart(scenarioRun.getStart()).withEnd(scenarioRun.getEnd());
            }
            scenarioItem.addAction(scenarioResult);
            if (scenarioRun.getTrigger() != null) {
                TriggerFire triggerFire = scenarioRun.getTrigger();
                triggerItem = this.getItemForTrigger(projectKey, items, scenarioItem, triggerFire);
                triggerResult = new ReportItem.TriggerFired(triggerItem.target).withStart(triggerFire.getTimestamp()).withEnd(triggerFire.getTimestamp());
                triggerItem.addAction(triggerResult);
            } else {
                triggerItem = null;
                triggerResult = null;
            }
            ScenarioRunItem column = new ScenarioRunItem(scenarioItem, scenarioRun.getStart(), scenarioRun.getEnd(), triggerItem, scenarioRun.getRunId());
            columns.add(column);
            column.addAction(scenarioItem, scenarioResult);
            if (triggerItem != null) {
                column.addAction(triggerItem, triggerResult);
            }
            columnByScenarioRun.put(scenarioRun, column);
            resultByScenarioRun.put(scenarioRun, scenarioResult);
        }
        Map<ScenarioRunKey, List<StepRun>> stepRuns = this.jobsDatabaseService.getStepRunsBulk(scenarioRuns);
        for (ScenarioRun scenarioRun : scenarioRuns) {
            ScenarioRunItem column = (ScenarioRunItem)columnByScenarioRun.get(scenarioRun);
            scenarioResult = (ReportItem)resultByScenarioRun.get(scenarioRun);
            String projectKey = scenarioRun.getScenario().getProjectKey();
            if (!stepRuns.containsKey(scenarioRun)) continue;
            for (StepRun stepRun : stepRuns.get(scenarioRun)) {
                ScenarioItem stepItem = this.getItemForStep(projectKey, items, column.scenario, stepRun);
                ReportItem stepResult = stepRun.getResult();
                if (stepResult == null) {
                    stepResult = new ReportItem.StepDone(stepItem.target).withStart(stepRun.getStart()).withEnd(scenarioResult.getEnd());
                }
                stepItem.addAction(stepResult);
                column.addAction(stepItem, stepResult);
                for (ReportItem reportItem : stepRun.getAdditionalReportItems()) {
                    ScenarioItem item = this.getOrCreate(items, reportItem.getTargetItem(), stepItem, projectKey);
                    item.addAction(reportItem);
                    column.addAction(item, reportItem);
                }
            }
        }
        final ScenarioGantt scenarioGantt = new ScenarioGantt(reportKey, items, columns);
        this.computedReportData.put((Object)reportKey, (Object)scenarioGantt);
        return new Callable<ScenarioGantt>(){

            @Override
            public ScenarioGantt call() throws Exception {
                for (ScenarioItem item : items) {
                    String projectKey = item.contextProjectKey;
                    if (!contexts.containsKey(projectKey)) {
                        contexts.put(projectKey, new FillInfoContext(projectKey));
                    }
                    FillInfoContext context = (FillInfoContext)contexts.get(projectKey);
                    if (item.hasInfo()) continue;
                    ScenarioReportsService.this.fillInfo(item.target, item.info, context);
                }
                return scenarioGantt;
            }
        };
    }

    public ScenarioActivity getActivitiesReport(String projectKey, String scenarioId, DateTime fromDate, DateTime toDate) throws Exception {
        List<ScenarioRun> scenarioRuns;
        ReadOnlyJobsInternalDB.ScenarioRunsBoundaries minmax = this.jobsDatabaseService.getScenarioRunsBoundaries(fromDate.getMillis(), toDate.getMillis(), projectKey);
        ReportKey reportKey = new ReportKey(fromDate.getMillis(), toDate.getMillis(), projectKey, scenarioId, minmax.minStart, minmax.maxEnd, minmax.notFinished);
        ScenarioActivity report = (ScenarioActivity)this.computedActivityData.getIfPresent((Object)reportKey);
        if (report != null && minmax.notFinished == 0) {
            logger.info((Object)"Report data cache hit");
            return report;
        }
        logger.info((Object)("Report data cache miss (" + minmax.notFinished + " running)"));
        if (scenarioId == null) {
            scenarioRuns = this.jobsDatabaseService.getRuns(fromDate.getMillis(), toDate.getMillis(), false, projectKey);
        } else {
            Scenario scenario = (Scenario)this.scenariosDAO.getMandatory(projectKey, scenarioId);
            scenarioRuns = this.jobsDatabaseService.getRuns(projectKey, scenario.getId(), fromDate.getMillis(), toDate.getMillis(), false);
        }
        FillInfoContext context = new FillInfoContext(projectKey);
        ArrayList rows = Lists.newArrayList();
        ArrayList columns = Lists.newArrayList();
        ArrayList scenarios = Lists.newArrayList();
        ArrayList triggers = Lists.newArrayList();
        for (ScenarioRun scenarioRun : scenarioRuns) {
            ScenarioItem triggerItem;
            ScenarioItem scenarioItem = this.getItemForScenario((List<ScenarioItem>)scenarios, null, scenarioRun, context);
            if (scenarioRun.getTrigger() != null) {
                TriggerFire triggerFire = scenarioRun.getTrigger();
                triggerItem = this.getItemForTrigger(projectKey, triggers, null, triggerFire);
            } else {
                triggerItem = null;
            }
            ScenarioRunItem column = new ScenarioRunItem(scenarioItem, scenarioRun.getStart(), scenarioRun.getEnd(), triggerItem, scenarioRun.getRunId());
            for (StepRun stepRun : this.jobsDatabaseService.getStepRuns(scenarioRun)) {
                for (ReportItem reportItem : stepRun.getAdditionalReportItems()) {
                    ScenarioItem item;
                    ReportTargetItem targetItem = reportItem.getTargetItem();
                    if (targetItem instanceof ReportTargetItem.DowncastableItem) {
                        targetItem = ((ReportTargetItem.DowncastableItem)((Object)targetItem)).downcast();
                    }
                    if (!(item = this.getOrCreate(rows, targetItem, null, projectKey)).hasInfo()) {
                        this.fillInfo(item.target, item.info, context);
                    }
                    column.addAction(item, reportItem);
                }
            }
            columns.add(column);
        }
        report = new ScenarioActivity(reportKey, rows, columns);
        this.computedActivityData.put((Object)reportKey, (Object)report);
        return report;
    }

    public ScenarioDays getDayReport_NT(DateTime fromDate, DateTime toDate, List<Scenario> scenarios, boolean includeOutOfDatesScenarios) throws Exception {
        try {
            long throttling = DKUApp.getParams().getLongParam("dip.test.throttle.scenario.outcomes.ms", 0L);
            if (throttling > 0L) {
                Thread.sleep(throttling);
            }
        }
        catch (Exception e) {
            logger.info((Object)"Interruption in the test throttling", (Throwable)e);
        }
        HashSet projectKeys = Sets.newHashSet();
        HashMap runCountsKeys = Maps.newHashMap();
        for (Scenario scenario : scenarios) {
            String projectKey = scenario.getProjectKey();
            projectKeys.add(projectKey);
            runCountsKeys.computeIfAbsent(projectKey, k -> Sets.newHashSet()).add(scenario.getId());
        }
        String uniqueProjectKey = projectKeys.size() == 1 ? (String)projectKeys.iterator().next() : null;
        String uniqueScenarioId = scenarios.size() == 1 ? scenarios.get(0).getId() : null;
        ReadOnlyJobsInternalDB.ScenarioRunsBoundaries minmax = this.jobsDatabaseService.getScenarioRunsBoundaries(fromDate.getMillis(), toDate.getMillis(), scenarios);
        ReportKey reportKey = new ReportKey(fromDate.getMillis(), toDate.getMillis(), uniqueProjectKey, uniqueScenarioId, minmax.minStart, minmax.maxEnd, minmax.notFinished, includeOutOfDatesScenarios);
        ScenarioDays report = (ScenarioDays)this.computedOutcomeData.getIfPresent((Object)reportKey);
        if (report != null && minmax.notFinished == 0) {
            logger.info((Object)"Report data cache hit");
            return report;
        }
        logger.info((Object)("Report data cache miss (" + minmax.notFinished + " running)"));
        ArrayList rows = Lists.newArrayList();
        TreeMap columns = Maps.newTreeMap();
        HashMap contexts = Maps.newHashMap();
        logger.info((Object)("local range " + String.valueOf(new LocalDateTime((Object)fromDate)) + " " + String.valueOf(new LocalDateTime((Object)toDate))));
        LocalDateTime dt = new LocalDateTime((Object)fromDate);
        while (dt.compareTo((ReadablePartial)new LocalDateTime((Object)toDate)) < 0) {
            String date = ISODateTimeFormat.date().print((ReadablePartial)dt);
            columns.put(date, new ScenarioDayItem(date));
            dt = dt.plusDays(1);
        }
        Map<String, Integer> runCountsByFullName = this.jobsDatabaseService.getRunCounts(runCountsKeys);
        for (Scenario scenario : scenarios) {
            ScenarioItem scenarioItem;
            FillInfoContext context;
            ScenarioRun lastRunInRange = null;
            String projectKey = scenario.getProjectKey();
            String scenarioFullName = projectKey + "." + scenario.getId();
            int scenarioRunCount = runCountsByFullName.getOrDefault(scenarioFullName, 0);
            List<ScenarioRun> scenarioRuns = this.jobsDatabaseService.getRuns(scenario.getProjectKey(), scenario.getId(), fromDate.getMillis(), toDate.getMillis(), true);
            if (!scenarioRuns.isEmpty()) {
                if (!contexts.containsKey(projectKey)) {
                    context = new FillInfoContext(projectKey);
                    context.putAll(scenarios, true);
                    contexts.put(projectKey, context);
                }
                scenarioItem = this.getItemForScenario((List<ScenarioItem>)rows, null, scenario, (FillInfoContext)contexts.get(projectKey));
                scenarioItem.withInfo("totalRunCount", String.valueOf(scenarioRunCount));
                for (ScenarioRun scenarioRun : scenarioRuns) {
                    this.addColumnInfo(scenarioRun, columns, scenarioItem);
                }
                lastRunInRange = scenarioRuns.stream().sorted(Comparator.comparingLong(o -> ((ScenarioRun)o).start).reversed()).filter(o -> o.result != null).findFirst().orElse(null);
                if (lastRunInRange != null) {
                    scenarioItem.withInfo("lastRunDate", ISODateTimeFormat.date().print(lastRunInRange.start));
                    scenarioItem.withInfo("lastRunTimestamp", String.valueOf(lastRunInRange.start));
                    scenarioItem.withInfo("lastRunOutcome", String.valueOf((Object)lastRunInRange.result.outcome));
                }
            }
            if (lastRunInRange != null || !includeOutOfDatesScenarios) continue;
            if (!contexts.containsKey(projectKey)) {
                context = new FillInfoContext(projectKey);
                context.putAll(scenarios, true);
                contexts.put(projectKey, context);
            }
            scenarioItem = this.getItemForScenario((List<ScenarioItem>)rows, null, scenario, (FillInfoContext)contexts.get(projectKey));
            scenarioItem.withInfo("totalRunCount", String.valueOf(runCountsByFullName.get(scenarioFullName)));
            if (scenarioRunCount <= 0) continue;
            ScenarioRun lastOutOfDatesRun = this.jobsDatabaseService.getLastRuns(scenario, 1, false, true).get(0);
            scenarioItem.withInfo("lastRunDate", ISODateTimeFormat.date().print(lastOutOfDatesRun.start));
            scenarioItem.withInfo("lastRunTimestamp", String.valueOf(lastOutOfDatesRun.start));
            if (lastOutOfDatesRun.result == null || lastOutOfDatesRun.result.outcome == null) continue;
            scenarioItem.withInfo("lastRunOutcome", String.valueOf((Object)lastOutOfDatesRun.result.outcome));
        }
        report = new ScenarioDays(reportKey, rows, Lists.newArrayList(columns.values()));
        this.computedOutcomeData.put((Object)reportKey, (Object)report);
        return report;
    }

    private void addColumnInfo(ScenarioRun scenarioRun, TreeMap<String, ScenarioDayItem> columns, ScenarioItem scenarioItem) {
        if (null == scenarioRun.getResult()) {
            return;
        }
        ReportItem result = scenarioRun.getResult().withStart(scenarioRun.getStart());
        String date = ISODateTimeFormat.date().print(scenarioRun.start);
        if (!columns.containsKey(date)) {
            columns.put(date, new ScenarioDayItem(date));
        }
        if (scenarioRun.getTrigger() != null && result instanceof ReportItem.ScenarioDone) {
            String triggerName = scenarioRun.getTrigger().getTrigger().getName();
            if (StringUtils.isBlank((String)triggerName)) {
                triggerName = scenarioRun.getTrigger().getTrigger().getType();
            }
            result = ((ReportItem.ScenarioDone)result).withTrigger(triggerName).withRunId(scenarioRun.runId);
        }
        columns.get(date).addAction(scenarioItem, result);
    }

    public ProjectRunsSummary getSummaryDayReport_NT(String projectKey, DateTime fromDate, DateTime toDate, List<Scenario> scenarios) throws Exception {
        try {
            long throttling = DKUApp.getParams().getLongParam("dip.test.throttle.scenario.outcomes.summary.ms", 0L);
            if (throttling > 0L) {
                Thread.sleep(throttling);
            }
        }
        catch (Exception e) {
            logger.info((Object)"Interruption in the test throttling", (Throwable)e);
        }
        String uniqueScenarioId = scenarios.size() == 1 ? scenarios.get(0).getId() : null;
        ReadOnlyJobsInternalDB.ScenarioRunsBoundaries minmax = this.jobsDatabaseService.getScenarioRunsBoundaries(fromDate.getMillis(), toDate.getMillis(), scenarios);
        ReportKey reportKey = new ReportKey(fromDate.getMillis(), toDate.getMillis(), projectKey, uniqueScenarioId, minmax.minStart, minmax.maxEnd, minmax.notFinished);
        ProjectRunsSummary reportSummary = (ProjectRunsSummary)this.computedOutcomeSummaryData.getIfPresent((Object)reportKey);
        if (reportSummary != null && minmax.notFinished == 0) {
            logger.info((Object)"Report summary data cache hit");
            return reportSummary;
        }
        logger.info((Object)("Report summary data cache miss (" + minmax.notFinished + " running)"));
        ProjectRunsSummary report = this.jobsDatabaseService.getRunsSummary(projectKey, fromDate.getMillis(), toDate.getMillis());
        this.computedOutcomeSummaryData.put((Object)reportKey, (Object)report);
        return report;
    }

    public ScenarioDayRuns getDayReportDetails(String projectKey, String scenarioId, DateTime date) throws Exception {
        Scenario scenario = (Scenario)this.scenariosDAO.getOrNull(projectKey, scenarioId);
        List<ScenarioRun> scenarioRuns = this.jobsDatabaseService.getRuns(projectKey, scenarioId, date.getMillis(), date.plusDays(1).getMillis(), false);
        if (scenarioRuns.size() == 0) {
            if (scenario == null) {
                scenario = new Scenario();
            }
            return new ScenarioDayRuns(scenario, scenarioRuns);
        }
        if (scenario == null) {
            scenario = scenarioRuns.get(scenarioRuns.size() - 1).getScenario();
        }
        return new ScenarioDayRuns(scenario, scenarioRuns);
    }

    public void fillInfoInReportItems(String projectKey, ScenarioRun scenarioRun, List<StepRun> stepRuns) throws Exception {
        ArrayList items = Lists.newArrayList();
        if (scenarioRun.getResult() != null) {
            items.add(scenarioRun.getResult());
        }
        if (stepRuns != null) {
            for (StepRun stepRun : stepRuns) {
                if (stepRun.getResult() != null) {
                    items.add(stepRun.getResult());
                }
                for (ReportItem reportItem : stepRun.getAdditionalReportItems()) {
                    items.add(reportItem);
                }
            }
        }
        FillInfoContext context = new FillInfoContext(projectKey);
        for (ReportItem item : items) {
            item.info = item.info == null ? new HashMap() : item.info;
            this.fillInfo(item.target, item.info, context);
        }
    }

    public List<ReportItem> listReportItems(String projectKey, ScenarioRun scenarioRun, List<StepRun> stepRuns) throws Exception {
        ArrayList items = Lists.newArrayList();
        if (scenarioRun.getResult() != null) {
            items.add(scenarioRun.getResult());
        }
        if (scenarioRun.getTrigger() != null) {
            TriggerFire triggerFire = scenarioRun.getTrigger();
            ReportTargetItem.ScenarioTriggerItem triggerTargetItem = new ReportTargetItem.ScenarioTriggerItem(projectKey, triggerFire.getScenarioId(), triggerFire.getTrigger().getId());
            ReportItem triggerItem = new ReportItem.TriggerFired(triggerTargetItem).withStart(triggerFire.getTimestamp()).withEnd(triggerFire.getTimestamp());
            triggerItem.info = Maps.newHashMap();
            triggerItem.info.put("name", triggerFire.getTrigger().getName());
            triggerItem.info.put("type", triggerFire.getTrigger().getType());
            items.add(triggerItem);
        }
        for (StepRun stepRun : stepRuns) {
            if (stepRun.getResult() != null) {
                ReportItem stepResult = stepRun.getResult();
                stepResult.info = stepResult.info == null ? new HashMap() : stepResult.info;
                stepResult.info.put("name", stepRun.getStep().getName());
                items.add(stepResult);
            }
            for (ReportItem reportItem : stepRun.getAdditionalReportItems()) {
                items.add(reportItem);
            }
        }
        FillInfoContext context = new FillInfoContext(projectKey);
        for (ReportItem item : items) {
            item.info = item.info == null ? new HashMap() : item.info;
            this.fillInfo(item.target, item.info, context);
        }
        return items;
    }

    private void fillInfo(ReportTargetItem target, Map<String, Object> info, FillInfoContext context) throws Exception {
        if (target instanceof ReportTargetItem.DatasetItem) {
            ReportTargetItem.DatasetItem ct = (ReportTargetItem.DatasetItem)target;
            Dataset ds = context.getDataset(ct.projectKey, ct.datasetName);
            if (ds != null) {
                info.put("type", ds.getType());
            } else {
                info.put("deleted", "true");
            }
        } else if (target instanceof ReportTargetItem.DatasetPartitionItem) {
            ReportTargetItem.DatasetPartitionItem ct = (ReportTargetItem.DatasetPartitionItem)target;
            Dataset ds = context.getDataset(ct.projectKey, ct.datasetName);
            if (ds != null) {
                info.put("type", ds.getType());
            } else {
                info.put("deleted", "true");
            }
        } else if (target instanceof ReportTargetItem.RetrievableKnowledgeItem) {
            ReportTargetItem.RetrievableKnowledgeItem ct = (ReportTargetItem.RetrievableKnowledgeItem)target;
            RetrievableKnowledge rk = context.getRetrievableKnowledgeOrNull(ct.projectKey, ct.retrievableKnowledgeId);
            if (rk != null) {
                info.put("name", rk.name);
            } else {
                info.put("deleted", "true");
            }
        } else if (target instanceof ReportTargetItem.SavedModelItem) {
            ReportTargetItem.SavedModelItem ct = (ReportTargetItem.SavedModelItem)target;
            SavedModel sm = context.getSavedModelOrNull(ct.projectKey, ct.modelId);
            if (sm != null) {
                info.put("name", sm.name);
                info.put("type", (Object)sm.getType());
            } else {
                info.put("deleted", "true");
            }
        } else if (target instanceof ReportTargetItem.SavedModelPartitionItem) {
            ReportTargetItem.SavedModelPartitionItem ct = (ReportTargetItem.SavedModelPartitionItem)target;
            SavedModel sm = context.getSavedModelOrNull(ct.projectKey, ct.modelId);
            if (sm != null) {
                info.put("name", sm.name);
                info.put("type", (Object)sm.getType());
            } else {
                info.put("deleted", "true");
            }
        } else if (target instanceof ReportTargetItem.ModelEvaluationStoreItem) {
            ReportTargetItem.ModelEvaluationStoreItem ct = (ReportTargetItem.ModelEvaluationStoreItem)target;
            ModelEvaluationStore mes = context.getModelEvaluationStoreOrNull(ct.projectKey, ct.evaluationStoreId);
            if (mes != null) {
                info.put("name", mes.name);
            } else {
                info.put("deleted", "true");
            }
        } else if (target instanceof ReportTargetItem.ModelEvaluationStorePartitionItem) {
            ReportTargetItem.ModelEvaluationStorePartitionItem ct = (ReportTargetItem.ModelEvaluationStorePartitionItem)target;
            ModelEvaluationStore mes = context.getModelEvaluationStoreOrNull(ct.projectKey, ct.evaluationStoreId);
            if (mes != null) {
                info.put("name", mes.name);
            } else {
                info.put("deleted", "true");
            }
        } else if (target instanceof ReportTargetItem.ManagedFolderItem) {
            ReportTargetItem.ManagedFolderItem ct = (ReportTargetItem.ManagedFolderItem)target;
            ManagedFolder mf = context.getManagedFolder(ct.projectKey, ct.folderId);
            if (mf != null) {
                info.put("name", mf.name);
            } else {
                info.put("deleted", "true");
            }
        } else if (target instanceof ReportTargetItem.ManagedFolderPartitionItem) {
            ReportTargetItem.ManagedFolderPartitionItem ct = (ReportTargetItem.ManagedFolderPartitionItem)target;
            ManagedFolder mf = context.getManagedFolder(ct.projectKey, ct.folderId);
            if (mf != null) {
                info.put("name", mf.name);
            } else {
                info.put("deleted", "true");
            }
        } else if (target instanceof ReportTargetItem.ManagedFolderFileItem) {
            ReportTargetItem.ManagedFolderFileItem ct = (ReportTargetItem.ManagedFolderFileItem)target;
            ManagedFolder mf = context.getManagedFolder(ct.projectKey, ct.folderId);
            if (mf != null) {
                info.put("name", mf.name);
            } else {
                info.put("deleted", "true");
            }
        } else if (target instanceof ReportTargetItem.ScenarioStepItem) {
            ReportTargetItem.ScenarioStepItem ct = (ReportTargetItem.ScenarioStepItem)target;
            Scenario sc = context.getScenario(ct.projectKey, ct.scenarioId);
            if (sc != null) {
                info.put("scenarioName", sc.name);
            } else {
                info.put("scenarioDeleted", "true");
            }
        } else if (target instanceof ReportTargetItem.ScenarioTriggerItem) {
            ReportTargetItem.ScenarioTriggerItem ct = (ReportTargetItem.ScenarioTriggerItem)target;
            Scenario sc = context.getScenario(ct.projectKey, ct.scenarioId);
            if (sc != null) {
                info.put("scenarioName", sc.name);
            } else {
                info.put("scenarioDeleted", "true");
            }
        } else if (target instanceof ReportTargetItem.ScenarioItem) {
            ReportTargetItem.ScenarioItem ct = (ReportTargetItem.ScenarioItem)target;
            Scenario sc = context.getScenario(ct.projectKey, ct.scenarioId);
            if (sc != null) {
                info.put("name", sc.getName());
                String runAsUser = sc.getRunAsUser();
                if (StringUtils.isBlank((String)runAsUser)) {
                    if (sc.getVersionTag() != null) {
                        runAsUser = sc.getVersionTag().getLastAuthor();
                    } else if (sc.getCreationTag() != null) {
                        runAsUser = sc.getCreationTag().getLastAuthor();
                    }
                }
                info.put("login", runAsUser);
                info.put("runAsDisplayName", context.getDisplayName(runAsUser));
                info.put("active", sc.isActive());
                info.put("automationLocal", sc.isAutomationLocal());
            } else {
                info.put("scenarioDeleted", "true");
            }
        } else if (target instanceof ReportTargetItem.WebAppItem) {
            ReportTargetItem.WebAppItem ct = (ReportTargetItem.WebAppItem)target;
            WebApp sc = context.getWebApp(ct.projectKey, ct.webAppId);
            if (sc != null) {
                info.put("name", sc.name);
                info.put("login", sc.params.runAs);
            } else {
                info.put("webAppDeleted", "true");
            }
        } else if (target instanceof ReportTargetItem.CodeStudioItem) {
            ReportTargetItem.CodeStudioItem ct = (ReportTargetItem.CodeStudioItem)target;
            CodeStudioObject sc = context.getCodeStudio(ct.projectKey, ct.codeStudioId);
            if (sc != null) {
                info.put("name", sc.name);
            } else {
                info.put("codeStudioDeleted", "true");
            }
        }
    }

    private ScenarioItem getItemForTrigger(String projectKey, List<ScenarioItem> items, ScenarioItem scenarioItem, TriggerFire triggerFire) {
        ScenarioItem triggerItem = this.getOrCreate(items, new ReportTargetItem.ScenarioTriggerItem(projectKey, triggerFire.getScenarioId(), triggerFire.getTrigger().getId()), scenarioItem, projectKey);
        if (!triggerItem.hasInfo()) {
            triggerItem.withInfo("name", triggerFire.getTrigger().getName());
            triggerItem.withInfo("type", triggerFire.getTrigger().getType());
        }
        return triggerItem;
    }

    private ScenarioItem getItemForStep(String projectKey, List<ScenarioItem> items, ScenarioItem scenarioItem, StepRun stepRun) {
        ScenarioItem stepItem;
        ReportTargetItem targetItem;
        ReportTargetItem reportTargetItem = targetItem = stepRun.getResult() != null ? stepRun.getResult().getTargetItem() : null;
        if (targetItem == null) {
            targetItem = new ReportTargetItem.ScenarioStepItem(stepRun);
        }
        if (!(stepItem = this.getOrCreate(items, targetItem, scenarioItem, projectKey)).hasInfo()) {
            stepItem.withInfo("name", stepRun.getStep().getName());
            stepItem.withInfo("type", stepRun.getStep().getType());
        }
        return stepItem;
    }

    private ScenarioItem getItemForScenario(List<ScenarioItem> items, ScenarioItem projectItem, ScenarioRun scenarioRun, FillInfoContext context) throws Exception {
        ReportTargetItem targetItem;
        ReportTargetItem reportTargetItem = targetItem = scenarioRun.getResult() != null ? scenarioRun.getResult().getTargetItem() : null;
        if (targetItem == null || targetItem instanceof ReportTargetItem.ScenarioItem && StringUtils.isBlank((String)((ReportTargetItem.ScenarioItem)targetItem).scenarioId)) {
            targetItem = new ReportTargetItem.ScenarioItem(scenarioRun);
        } else if (targetItem instanceof ReportTargetItem.ScenarioItem && StringUtils.isBlank((String)((ReportTargetItem.ScenarioItem)targetItem).scenarioId)) {
            targetItem = new ReportTargetItem.ScenarioItem(scenarioRun);
        }
        ScenarioItem scenarioItem = this.getOrCreate(items, targetItem, projectItem, scenarioRun.getScenario().getProjectKey());
        if (context != null && !scenarioItem.hasInfo()) {
            this.fillInfo(scenarioItem.target, scenarioItem.info, context);
        }
        return scenarioItem;
    }

    private ScenarioItem getItemForScenario(List<ScenarioItem> items, ScenarioItem projectItem, Scenario scenario, FillInfoContext context) throws Exception {
        ReportTargetItem.ScenarioItem targetItem = new ReportTargetItem.ScenarioItem(scenario);
        ScenarioItem scenarioItem = this.getOrCreate(items, targetItem, projectItem, scenario.getProjectKey());
        if (context != null && !scenarioItem.hasInfo()) {
            this.fillInfo(scenarioItem.target, scenarioItem.info, context);
        }
        scenarioItem.withInfo("tags", scenario.getTags());
        return scenarioItem;
    }

    public static class ScenarioItem {
        public final String uniqueId;
        public final String parentId;
        final ReportTargetItem target;
        public final Map<String, Object> info = Maps.newHashMap();
        public final List<ReportItem> actions = Lists.newArrayList();
        long meanDuration;
        long lastDuration;
        transient int durationCount = 0;
        transient long durationSum = 0L;
        transient long durationLastEnd = -1L;
        transient long durationLast = -1L;
        public final String contextProjectKey;

        ScenarioItem(String uniqueId, ReportTargetItem target, String parentId, String contextProjectKey) {
            this.uniqueId = uniqueId;
            this.target = target;
            this.parentId = parentId;
            this.contextProjectKey = contextProjectKey;
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public void addAction(ReportItem action) {
            long duration = action.end - action.start;
            if (duration >= 0L) {
                if (this.durationLastEnd < 0L || this.durationLastEnd < action.end) {
                    this.durationLastEnd = action.end;
                    this.durationLast = duration;
                }
                this.durationSum += duration;
                ++this.durationCount;
            }
            this.lastDuration = this.durationLast;
            this.meanDuration = this.durationCount > 0 ? this.durationSum / (long)this.durationCount : 0L;
        }

        public boolean hasInfo() {
            return this.info.size() > 0;
        }

        public ScenarioItem withInfo(String identifierName, Object identifierValue) {
            this.info.put(identifierName, identifierValue);
            return this;
        }
    }

    private static class ReportKey {
        long from;
        long to;
        String projectKey;
        String scenarioId;
        long scenarioFrom;
        long scenarioTo;
        int notFinished;
        boolean includeOutOfDatesScenarios;

        ReportKey(long from, long to, String projectKey, String scenarioId, long scenarioFrom, long scenarioTo, int notFinished, boolean includeOutOfDatesScenarios) {
            this.from = from;
            this.to = to;
            this.projectKey = projectKey;
            this.scenarioId = scenarioId;
            this.scenarioFrom = scenarioFrom;
            this.scenarioTo = scenarioTo;
            this.notFinished = notFinished;
            this.includeOutOfDatesScenarios = includeOutOfDatesScenarios;
        }

        ReportKey(long from, long to, String projectKey, String scenarioId, long scenarioFrom, long scenarioTo, int notFinished) {
            this(from, to, projectKey, scenarioId, scenarioFrom, scenarioTo, notFinished, false);
        }

        boolean intersects(String projectKey, String scenarioId, long minStart, long maxEnd) {
            return !(!StringUtils.isBlank((String)this.projectKey) && !this.projectKey.equals(projectKey) || !StringUtils.isBlank((String)this.scenarioId) && !this.scenarioId.equals(scenarioId) || maxEnd < this.scenarioFrom || minStart > this.scenarioTo);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.from ^ this.from >>> 32);
            result = 31 * result + this.notFinished;
            result = 31 * result + (this.projectKey == null ? 0 : this.projectKey.hashCode());
            result = 31 * result + (int)(this.scenarioFrom ^ this.scenarioFrom >>> 32);
            result = 31 * result + (this.scenarioId == null ? 0 : this.scenarioId.hashCode());
            result = 31 * result + (int)(this.scenarioTo ^ this.scenarioTo >>> 32);
            result = 31 * result + (int)(this.to ^ this.to >>> 32);
            result = 31 * result + (this.includeOutOfDatesScenarios ? 1 : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReportKey other = (ReportKey)obj;
            if (this.from != other.from) {
                return false;
            }
            if (this.notFinished != other.notFinished) {
                return false;
            }
            if (this.projectKey == null ? other.projectKey != null : !this.projectKey.equals(other.projectKey)) {
                return false;
            }
            if (this.scenarioFrom != other.scenarioFrom) {
                return false;
            }
            if (this.scenarioId == null ? other.scenarioId != null : !this.scenarioId.equals(other.scenarioId)) {
                return false;
            }
            if (this.scenarioTo != other.scenarioTo) {
                return false;
            }
            if (this.to != other.to) {
                return false;
            }
            return this.includeOutOfDatesScenarios == other.includeOutOfDatesScenarios;
        }
    }

    public static class ScenarioGantt {
        final ReportKey key;
        final List<ScenarioItem> items;
        final List<ScenarioRunItem> columns;

        ScenarioGantt(ReportKey key, List<ScenarioItem> items, List<ScenarioRunItem> columns) {
            this.items = items;
            this.key = key;
            this.columns = columns;
        }
    }

    private class FillInfoContext {
        private Map<String, Dataset> datasets = Maps.newHashMap();
        private Map<String, ManagedFolder> managedFolders = Maps.newHashMap();
        private Map<String, SavedModel> savedModels = Maps.newHashMap();
        private Map<String, Scenario> scenarios = Maps.newHashMap();
        private Map<String, ModelEvaluationStore> modelEvaluationStores = Maps.newHashMap();
        private Map<String, RetrievableKnowledge> retrievableKnowledges = Maps.newHashMap();
        private Map<String, WebApp> webApps = Maps.newHashMap();
        private Map<String, CodeStudioObject> codeStudios = Maps.newHashMap();
        private Map<String, String> userDisplayNames = Maps.newHashMap();
        private String scenarioProjectKey;

        FillInfoContext(String scenarioProjectKey) {
            this.scenarioProjectKey = scenarioProjectKey;
        }

        void putAll(List<Scenario> scenarios, boolean onlyForSameProject) {
            for (Scenario scenario : scenarios) {
                if (onlyForSameProject && !scenario.getProjectKey().equals(this.scenarioProjectKey)) continue;
                this.scenarios.put(scenario.getFullId(), scenario);
            }
        }

        Dataset getDataset(String projectKey, String name) throws IOException {
            String key = (projectKey == null ? this.scenarioProjectKey : projectKey) + "." + name;
            if (this.datasets.containsKey(key)) {
                return this.datasets.get(key);
            }
            Dataset dataset = null;
            try {
                dataset = ScenarioReportsService.this.datasetAccessService.getOrNull(projectKey, name);
            }
            catch (Exception ex) {
                logger.warn((Object)"Could not get dataset for filling info map", (Throwable)ex);
            }
            this.datasets.put(key, dataset);
            return dataset;
        }

        String getDisplayName(String runAsUser) {
            PublicUser pu = null;
            if (this.userDisplayNames.containsKey(runAsUser)) {
                return this.userDisplayNames.get(runAsUser);
            }
            String displayName = "";
            try (Transaction t = ScenarioReportsService.this.transactionService.retrieveOrBeginRead();){
                pu = ScenarioReportsService.this.usersService.getPublicUser(runAsUser);
                if (pu != null) {
                    displayName = pu.displayName;
                }
            }
            catch (Exception ex) {
                logger.warn((Object)"Could not get public user for filling info map", (Throwable)ex);
            }
            this.userDisplayNames.put(runAsUser, displayName);
            return displayName;
        }

        ManagedFolder getManagedFolder(String projectKey, String id) throws IOException {
            String key = (projectKey == null ? this.scenarioProjectKey : projectKey) + "." + id;
            if (this.managedFolders.containsKey(key)) {
                return this.managedFolders.get(key);
            }
            ManagedFolder managedFolder = null;
            try {
                managedFolder = (ManagedFolder)ScenarioReportsService.this.managedFolderDAO.getOrNull(projectKey, id);
            }
            catch (Exception e) {
                logger.warn((Object)"Could not get folder for filling info map", (Throwable)e);
            }
            this.managedFolders.put(key, managedFolder);
            return managedFolder;
        }

        SavedModel getSavedModelOrNull(String projectKey, String id) throws IOException {
            String key = (projectKey == null ? this.scenarioProjectKey : projectKey) + "." + id;
            if (this.savedModels.containsKey(key)) {
                return this.savedModels.get(key);
            }
            SavedModel savedModel = null;
            try {
                savedModel = (SavedModel)ScenarioReportsService.this.savedModelsDAO.getOrNull(projectKey, id);
            }
            catch (Exception ex) {
                logger.warn((Object)"Could not get model for filling info map", (Throwable)ex);
            }
            this.savedModels.put(key, savedModel);
            return savedModel;
        }

        ModelEvaluationStore getModelEvaluationStoreOrNull(String projectKey, String id) throws IOException {
            String key = (projectKey == null ? this.scenarioProjectKey : projectKey) + "." + id;
            if (this.modelEvaluationStores.containsKey(key)) {
                return this.modelEvaluationStores.get(key);
            }
            ModelEvaluationStore modelEvaluationStore = null;
            try {
                modelEvaluationStore = (ModelEvaluationStore)ScenarioReportsService.this.modelEvaluationStoresDAO.getOrNull(projectKey, id);
            }
            catch (Exception ex) {
                logger.warn((Object)"Could not get evaluation store for filling info map", (Throwable)ex);
            }
            this.modelEvaluationStores.put(key, modelEvaluationStore);
            return modelEvaluationStore;
        }

        RetrievableKnowledge getRetrievableKnowledgeOrNull(String projectKey, String id) {
            String key = (projectKey == null ? this.scenarioProjectKey : projectKey) + "." + id;
            if (this.retrievableKnowledges.containsKey(key)) {
                return this.retrievableKnowledges.get(key);
            }
            RetrievableKnowledge rk = null;
            try {
                rk = (RetrievableKnowledge)ScenarioReportsService.this.retrievableKnowledgeDAO.getOrNull(projectKey, id);
            }
            catch (Exception ex) {
                logger.warn((Object)"Could not get knowledge bank for filling info map", (Throwable)ex);
            }
            this.retrievableKnowledges.put(key, rk);
            return rk;
        }

        Scenario getScenario(String projectKey, String id) throws Exception {
            String key = (projectKey == null ? this.scenarioProjectKey : projectKey) + "." + id;
            if (this.scenarios.containsKey(key)) {
                return this.scenarios.get(key);
            }
            Scenario scenario = null;
            try {
                scenario = (Scenario)ScenarioReportsService.this.scenariosDAO.getOrNull(projectKey, id);
            }
            catch (Exception ex) {
                logger.warn((Object)"Could not get scenario for filling info map", (Throwable)ex);
            }
            if (scenario != null) {
                this.scenarios.put(key, scenario);
            }
            return scenario;
        }

        WebApp getWebApp(String projectKey, String id) throws Exception {
            String key = (projectKey == null ? this.scenarioProjectKey : projectKey) + "." + id;
            if (this.webApps.containsKey(key)) {
                return this.webApps.get(key);
            }
            WebApp webApp = null;
            try {
                webApp = (WebApp)ScenarioReportsService.this.webAppsDAO.getOrNull(projectKey, id);
            }
            catch (Exception ex) {
                logger.warn((Object)"Could not get webapp for filling info map", (Throwable)ex);
            }
            if (webApp != null) {
                this.webApps.put(key, webApp);
            }
            return webApp;
        }

        CodeStudioObject getCodeStudio(String projectKey, String id) throws Exception {
            String key = (projectKey == null ? this.scenarioProjectKey : projectKey) + "." + id;
            if (this.codeStudios.containsKey(key)) {
                return this.codeStudios.get(key);
            }
            CodeStudioObject codeStudio = null;
            try {
                codeStudio = (CodeStudioObject)ScenarioReportsService.this.codeStudioObjectsDAO.getOrNull(projectKey, id);
            }
            catch (Exception ex) {
                logger.warn((Object)"Could not get webapp for filling info map", (Throwable)ex);
            }
            if (codeStudio != null) {
                this.codeStudios.put(key, codeStudio);
            }
            return codeStudio;
        }
    }

    public static class ScenarioRunItem {
        final ScenarioItem scenario;
        final long start;
        final long end;
        final ScenarioItem trigger;
        final String runId;
        final Map<String, List<ReportItem>> actions = Maps.newHashMap();

        ScenarioRunItem(ScenarioItem scenario, long start, long end, ScenarioItem trigger, String runId) {
            this.scenario = scenario;
            this.start = start;
            this.end = end;
            this.trigger = trigger;
            this.runId = runId;
        }

        public void addAction(ScenarioItem row, ReportItem action) {
            ArrayList actions = this.actions.get(row.uniqueId);
            if (actions == null) {
                actions = Lists.newArrayList();
                this.actions.put(row.uniqueId, actions);
            }
            actions.add(action);
        }
    }

    public static class ScenarioActivity {
        final ReportKey key;
        final List<ScenarioItem> rows;
        final List<ScenarioRunItem> columns;

        ScenarioActivity(ReportKey key, List<ScenarioItem> rows, List<ScenarioRunItem> columns) {
            this.rows = rows;
            this.key = key;
            this.columns = columns;
        }
    }

    public static class ScenarioDays {
        final ReportKey key;
        final List<ScenarioItem> rows;
        final List<ScenarioDayItem> columns;

        ScenarioDays(ReportKey key, List<ScenarioItem> rows, List<ScenarioDayItem> columns) {
            this.rows = rows;
            this.key = key;
            this.columns = columns;
        }
    }

    public static class ScenarioDayItem {
        final String date;
        final Map<String, List<ReportItem>> actions = Maps.newHashMap();

        ScenarioDayItem(String date) {
            this.date = date;
        }

        public void addAction(ScenarioItem row, ReportItem action) {
            ArrayList actions = this.actions.get(row.uniqueId);
            if (actions == null) {
                actions = Lists.newArrayList();
                this.actions.put(row.uniqueId, actions);
            }
            actions.add(action);
        }
    }

    public static class ScenarioDayRuns
    extends Scenario {
        List<ScenarioRun> runs;
        int stepCount;

        public ScenarioDayRuns(Scenario scenario, List<ScenarioRun> runs) {
            this.projectKey = scenario.getProjectKey();
            this.id = scenario.getId();
            this.type = scenario.getType();
            this.name = scenario.getName();
            this.runAsUser = scenario.getRunAsUser();
            this.description = scenario.getDescription();
            this.versionTag = scenario.getVersionTag();
            this.active = scenario.isActive();
            this.automationLocal = scenario.isAutomationLocal();
            this.triggers = null;
            this.reporters = null;
            this.params = null;
            if (StepBasedScenarioRunner.META.getType().equals(this.type) && scenario.getParams() != null) {
                this.stepCount = scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class).getSteps().size();
            }
            this.runs = runs;
            for (ScenarioRun run : runs) {
                run.scenario = null;
                run.reportersStates = null;
                run.stepRunOutputs = null;
                run.reportersStates = null;
                run.variables = null;
            }
        }
    }
}

