/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.scheduler.ActiveTriggerLifecycleThread;
import com.dataiku.dip.scheduler.ActiveTriggersListMaintainerThread;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.scheduler.triggers.TriggerRegistry;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.ScenarioRunsService;
import com.dataiku.dip.server.services.ScenariosBaseService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScenariosTriggerService {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScenarioRunsService scenarioRunsService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ScenariosBaseService scenariosBaseService;
    @Autowired
    private FutureService futureService;
    private LinkedBlockingQueue<TriggerFire> triggerFires = new LinkedBlockingQueue();
    private ActiveTriggersListMaintainerThread thread;
    private Map<String, ScenarioTriggerState> scenarioTriggerStates = Maps.newHashMap();
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenarios.trigger.service");

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init scenarios triggers service");
        this.thread = new ActiveTriggersListMaintainerThread(this, this.scenarioRunsService, this.futureService);
        this.thread.start();
        logger.debug((Object)"Done init scenarios triggers service");
    }

    public void destroy() throws InterruptedException {
        logger.debug((Object)"Destroy scenarios triggers service");
        this.thread.stopGracefully();
        logger.debug((Object)"Done destroy scenarios triggers service");
    }

    public synchronized void forceTriggerThreadExecution() {
        this.thread.updateList(true);
    }

    public synchronized void touchTriggerThreadExecution() {
        this.thread.updateList(false);
    }

    public Map<String, ActiveTriggerLifecycleThread.QueueingInfo> getTriggerQueueingInfo() {
        return this.thread.getQueueingInfo();
    }

    public List<ActiveTrigger> getActiveTriggers_NT() throws IOException {
        List<String> projectKeys;
        TransactionContext.assertNoAttachedTransaction();
        ArrayList triggerRunners = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            if (this.generalSettingsDAO.read().disableAutomaticTriggers) {
                ArrayList arrayList = triggerRunners;
                return arrayList;
            }
            projectKeys = this.projectsService.listProjectKeys();
        }
        for (String projectKey : projectKeys) {
            Transaction t = this.transactionService.beginRead();
            try {
                if (this.projectsService.disableAutomaticTriggers(projectKey)) continue;
                for (Scenario scenario : this.scenariosDAO.listUnsafe(projectKey)) {
                    if (!scenario.isActive()) continue;
                    for (Trigger trigger : scenario.getTriggers()) {
                        if (!trigger.isActive()) continue;
                        try {
                            DSSAuthCtx runAsUser = this.scenariosBaseService.getRunAsUser(scenario);
                            triggerRunners.add(new ActiveTrigger(scenario, trigger, runAsUser));
                        }
                        catch (UnauthorizedException e) {
                            logger.errorV("Failed to build trigger runner (%s.%s.%s), skipping: %s", new Object[]{scenario.getProjectKey(), scenario.getId(), trigger.id, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                        }
                        catch (Exception e) {
                            logger.errorV((Throwable)e, "Failed to build trigger runner (%s.%s.%s), skipping", new Object[]{scenario.getProjectKey(), scenario.getId(), trigger.id});
                        }
                    }
                }
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        return triggerRunners;
    }

    public TriggerFire manualRun(DSSAuthCtx authCtx, Scenario scenario, String name, JsonObject params) throws Exception {
        Trigger trigger = new Trigger().withId("manual").withType("manual").withName(name);
        TriggerFire triggerFire = new TriggerFire().withScenario(scenario).withTrigger(trigger).withParams(params).withTimestamp(DateTime.now().getMillis());
        triggerFire.withTriggerAuthCtx(authCtx);
        this.fire(scenario, triggerFire, null, null);
        return triggerFire;
    }

    public TriggerFire getNextTriggerFire() throws InterruptedException {
        return this.triggerFires.take();
    }

    public List<TriggerFire> getLastTriggerRuns(String projectKey, String scenarioId) throws IOException, SQLException, NotFoundException {
        Scenario scenario = (Scenario)this.scenariosDAO.getMandatoryUnsafe(projectKey, scenarioId);
        return this.getLastTriggerRuns(scenario);
    }

    public List<TriggerFire> getLastTriggerRuns(Scenario scenario) throws IOException, SQLException, NotFoundException {
        return this.jobsDatabaseService.getLastFires(scenario);
    }

    public void recordState(TriggerFire triggerFire) throws SQLException {
        triggerFire = triggerFire.withTimestamp(DateTime.now().getMillis());
        this.jobsDatabaseService.saveTriggerFire(triggerFire);
        logger.info((Object)("Trigger initialized : " + triggerFire.getProjectKey() + "." + triggerFire.getScenarioId() + "." + triggerFire.getTrigger().getId()));
    }

    public String getTriggerState(Scenario scenario, Trigger trigger) throws SQLException {
        return this.jobsDatabaseService.getLastTriggerFireState(scenario.getProjectKey(), scenario.getId(), trigger.getId());
    }

    public TriggerFire getTriggerFire(String projectKey, String scenarioId, String triggerId, String runId) throws IOException, SQLException {
        return this.jobsDatabaseService.getTriggerFire(projectKey, scenarioId, triggerId, runId);
    }

    private ScenarioTriggerState getPendingTriggerFires(Scenario scenario) {
        String key = scenario.getFullId();
        if (!this.scenarioTriggerStates.containsKey(key)) {
            this.scenarioTriggerStates.put(key, new ScenarioTriggerState());
        }
        return this.scenarioTriggerStates.get(key);
    }

    public synchronized void addPendingTriggerFire(Scenario scenario, TriggerFire triggerFire) throws SQLException {
        triggerFire = triggerFire.withTimestamp(DateTime.now().getMillis());
        this.jobsDatabaseService.saveTriggerFire(triggerFire);
        this.getPendingTriggerFires((Scenario)scenario).pending.add(triggerFire);
    }

    public synchronized void replacePendingTriggerFire(Scenario scenario, TriggerFire triggerFire, TriggerFire newTriggerFire) throws SQLException {
        List<TriggerFire> list = this.getPendingTriggerFires((Scenario)scenario).pending;
        if (list.contains(triggerFire)) {
            list.remove(triggerFire);
        }
        list.add(newTriggerFire);
        this.jobsDatabaseService.saveTriggerFire(newTriggerFire);
    }

    public synchronized void cancelPendingTriggerFire(Scenario scenario, TriggerFire triggerFire) {
        List<TriggerFire> list = this.getPendingTriggerFires((Scenario)scenario).pending;
        if (list.contains(triggerFire)) {
            list.remove(triggerFire);
        }
    }

    public synchronized void markRunAsDone(Scenario scenario, String threadId) {
        ScenarioTriggerState state = this.getPendingTriggerFires(scenario);
        if (StringUtils.equals((String)threadId, (String)state.lastThreadId)) {
            state.lastThreadId = null;
        }
    }

    public synchronized String getLastScenarioThreadId(Scenario scenario) {
        return this.getPendingTriggerFires((Scenario)scenario).lastThreadId;
    }

    public synchronized FutureResponse<ReportItem> fire(Scenario scenario, TriggerFire triggerFire, JsonObject initialVariables, DSSAuthCtx runScenarioAsUser) throws Exception {
        triggerFire.withTimestamp(DateTime.now().getMillis());
        FutureResponse<ReportItem> future = null;
        ScenarioTriggerState scenarioTriggerState = this.getPendingTriggerFires(scenario);
        String triggerType = triggerFire.getTrigger().getType();
        if (this.checkIfTriggerShouldFireNow(scenario, triggerFire, triggerType, scenarioTriggerState)) {
            Scenario scenarioUpToDate;
            logger.infoV("Scenario triggered (%s, triggerId: %s)", new Object[]{triggerType, triggerFire.getTrigger().id});
            this.jobsDatabaseService.saveTriggerFire(triggerFire);
            try (Transaction t = this.transactionService.beginRead();){
                scenarioUpToDate = (Scenario)this.scenariosDAO.getMandatory(triggerFire.getProjectKey(), triggerFire.getScenarioId());
            }
            ScenariosService scenariosService = (ScenariosService)SpringUtils.getBean(ScenariosService.class);
            future = scenariosService.startScenarioRun(scenarioUpToDate, triggerFire, initialVariables, runScenarioAsUser);
            scenarioTriggerState.lastThreadId = future.jobId;
        } else {
            this.jobsDatabaseService.saveTriggerFire(triggerFire);
        }
        return future;
    }

    private boolean checkIfTriggerShouldFireNow(Scenario scenario, TriggerFire triggerFire, String triggerType, ScenarioTriggerState scenarioTriggerState) {
        List<TriggerFire> list = scenarioTriggerState.pending;
        int idx = list.indexOf(triggerFire);
        String triggerId = triggerFire.getTrigger().id;
        if (idx >= 0) {
            if (idx < list.size() - 1) {
                logger.infoV("Trigger fire (%s, triggerId: %s) shadowed by a later trigger fire", new Object[]{triggerType, triggerId});
                list.remove(triggerFire);
                triggerFire.withCancelled(true);
                return false;
            }
            list.remove(triggerFire);
        }
        if (StringUtils.isNotBlank((String)scenarioTriggerState.lastThreadId) && this.futureService.getLiveliness((String)scenarioTriggerState.lastThreadId).alive) {
            boolean canDelay;
            logger.infoV("Scenario already running, trigger suppressed (%s, triggerId: %s). Scenario delays triggers=%s", new Object[]{triggerType, triggerId, scenario.getDelayedTriggersBehavior().delayWhileRunning});
            boolean bl = canDelay = !triggerType.startsWith("manual") && !"sub".equals(triggerType) && TriggerRegistry.getMeta(triggerType).delayIfScenarioAlreadyRuns();
            if (canDelay && scenario.getDelayedTriggersBehavior().delayWhileRunning) {
                logger.infoV("Enqueuing trigger (triggerId: %s), already %d waiting", new Object[]{triggerId, scenarioTriggerState.delayed.size()});
                scenarioTriggerState.delayed.add(triggerFire);
            } else {
                triggerFire.withCancelled(true);
            }
            return false;
        }
        return true;
    }

    public synchronized void fireDelayedTriggers(Scenario scenario) throws Exception {
        ScenarioTriggerState scenarioTriggerState = this.getPendingTriggerFires(scenario);
        if (scenarioTriggerState.delayed.size() > 0) {
            if (scenario.getDelayedTriggersBehavior().squashDelayedTriggers) {
                TriggerFire triggerFire = scenarioTriggerState.delayed.get(scenarioTriggerState.delayed.size() - 1);
                scenarioTriggerState.delayed.clear();
                this.fire(scenario, triggerFire, null, null);
            } else {
                TriggerFire triggerFire = scenarioTriggerState.delayed.get(0);
                scenarioTriggerState.delayed.remove(triggerFire);
                this.fire(scenario, triggerFire, null, null);
            }
        }
    }

    public static class ActiveTrigger {
        public Scenario scenario;
        public Trigger trigger;
        public DSSAuthCtx runAsUser;

        ActiveTrigger(Scenario scenario, Trigger trigger, DSSAuthCtx runAsUser) {
            this.scenario = scenario;
            this.trigger = trigger;
            this.runAsUser = runAsUser;
        }

        public String id() {
            return this.scenario.getProjectKey() + "." + this.scenario.getId() + "." + this.trigger.getId();
        }

        public String scenarioKey() {
            return this.scenario.getProjectKey() + "." + this.scenario.getId();
        }
    }

    private static class ScenarioTriggerState {
        public List<TriggerFire> pending = Lists.newArrayList();
        public List<TriggerFire> delayed = Lists.newArrayList();
        public String lastThreadId;

        private ScenarioTriggerState() {
        }
    }
}

