/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.dataquality;

import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.server.services.dataquality.AbstractValuedCheck;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

@UIModel
public abstract class AbstractCheckReport {
    public long startTime;
    public long endTime;
    public String description;
    public List<MetricsComputationService.MetricsCheckRunReport> runs = Lists.newArrayList();

    public abstract List<AbstractValuedCheck> getResults();

    public static class DataQualityRulesComputationReport
    extends AbstractCheckReport {
        public String partition;
        public List<MetricsComputationService.MetricsEngineRunReport> metricsRuns;
        public List<AbstractValuedCheck.ValuedDataQualityRule> results;
        public boolean ignoreError;

        public DataQualityRulesComputationReport(String description, MetricsComputationService.MetricsComputationReport metricsReport, List<MetricsComputationService.MetricsCheckRunReport> runs, List<AbstractValuedCheck.ValuedDataQualityRule> results, long endTime, boolean ignoreError) {
            this.partition = metricsReport.partition;
            this.description = description;
            this.startTime = metricsReport.startTime;
            this.endTime = endTime;
            this.metricsRuns = metricsReport.runs;
            this.runs = runs;
            this.results = results;
            this.ignoreError = ignoreError;
        }

        @Override
        public List<AbstractValuedCheck> getResults() {
            return new ArrayList<AbstractValuedCheck>(this.results);
        }
    }

    public static class MetricsCheckReport
    extends AbstractCheckReport {
        public List<AbstractValuedCheck.ValuedCheck> results = Lists.newArrayList();

        @Override
        public List<AbstractValuedCheck> getResults() {
            return new ArrayList<AbstractValuedCheck>(this.results);
        }

        public List<AbstractValuedCheck.ValuedCheck> getCheckResults() {
            return this.results;
        }
    }
}

