/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.filter.AlphanumValueFilter;
import com.dataiku.dip.shaker.filter.DateNonRangeFilter;
import com.dataiku.dip.shaker.filter.DateRangeFilter;
import com.dataiku.dip.shaker.filter.DisplayFilter;
import com.dataiku.dip.shaker.filter.DisplayFilterColumn;
import com.dataiku.dip.shaker.filter.NumericalRangeFilter;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;

public class ExplicitExcludeFilter
implements DisplayFilter {
    private List<DisplayFilterColumn> columnFilters = new ArrayList<DisplayFilterColumn>();

    public ExplicitExcludeFilter(List<ChartFilter.ExplicitCondition> explicitConditions) {
        for (ChartFilter.ExplicitCondition explicitCondition : explicitConditions) {
            DisplayFilterColumn filter = this.getFilterFromExplicitCondition(explicitCondition);
            if (filter == null) continue;
            this.columnFilters.add(filter);
        }
    }

    private DisplayFilterColumn getFilterFromExplicitCondition(ChartFilter.ExplicitCondition explicitCondition) {
        switch (explicitCondition.columnType) {
            case NUMERICAL: {
                return new NumericalRangeFilter(explicitCondition.column, explicitCondition.minValue, explicitCondition.maxValue, false);
            }
            case ALPHANUM: {
                return new AlphanumValueFilter(explicitCondition.column, new String[]{explicitCondition.singleValue}, false, StringMatchingMode.FULL_STRING, StringNormalizationMode.EXACT);
            }
            case DATE: {
                if (explicitCondition.dateFilterType == ChartFilter.DateFilterType.RANGE) {
                    return new DateRangeFilter(explicitCondition.column, explicitCondition.minValue, explicitCondition.maxValue, false);
                }
                return new DateNonRangeFilter(explicitCondition.column, explicitCondition.dateFilterPart, Sets.newHashSet((Object[])new String[]{explicitCondition.singleValue}), false);
            }
        }
        return null;
    }

    @Override
    public void filter(MemTable table, boolean[] filters) {
        for (int i = 0; i < table.rows.size(); ++i) {
            MemRow row = table.rows.get(i);
            boolean acc = true;
            for (DisplayFilterColumn columnFilter : this.columnFilters) {
                MemColumn cd = table.getColumn(columnFilter.column);
                acc &= columnFilter.filterRow(row, cd);
            }
            int n = i;
            filters[n] = filters[n] & !acc;
        }
    }
}

