/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl;

import com.dataiku.dip.plugins.HadoopJavaPluginsHelper;
import com.dataiku.dip.plugins.HadoopJythonPluginsHelper;
import com.dataiku.dip.plugins.HadoopPluginSettingsHelper;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.mrimpl.ShakerEnvironment;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class ShakerJobConfigurator {
    public static final String SHAKER_JOB_RESOURCES = "dku.shaker.resources";
    public static final String SHAKER_JOB_SCRIPT = "dku.shaker.script";
    public static final String SHAKER_JOB_PLUGINSTATE = "dku.shaker.pluginsState";
    public static final String SHAKER_JOB_PLUGINSTEPSTATE = "dku.shaker.pluginStepsState";
    public static final String SHAKER_JOB_PLUGINSETTINGSSTATE = "dku.shaker.pluginSettingsState";

    public static void setJobResourceMapping(Configuration jobConf, ResourceMapping resourceFiles) {
        Preconditions.checkNotNull((Object)resourceFiles);
        jobConf.set(SHAKER_JOB_RESOURCES, JSON.pretty((Object)resourceFiles));
    }

    public static void setJobScript(Configuration jobConf, SerializedShakerScript shakerScript) {
        Preconditions.checkNotNull((Object)shakerScript);
        jobConf.set(SHAKER_JOB_SCRIPT, JSON.pretty((Object)shakerScript));
    }

    public static void setPluginsState(Configuration jobConf, HadoopJavaPluginsHelper.PluginsWithJavaState state) {
        jobConf.set(SHAKER_JOB_PLUGINSTATE, JSON.pretty((Object)state));
    }

    public static HadoopJavaPluginsHelper.PluginsWithJavaState getPluginsState(Configuration jobConf) {
        ShakerEnvironment.setup();
        String jsonified = jobConf.get(SHAKER_JOB_PLUGINSTATE);
        if (StringUtils.isBlank((String)jsonified)) {
            throw new RuntimeException("dku.shaker.pluginsState isn't defined");
        }
        return (HadoopJavaPluginsHelper.PluginsWithJavaState)JSON.parse((String)jsonified, HadoopJavaPluginsHelper.PluginsWithJavaState.class);
    }

    public static void setPluginSettingsState(Configuration jobConf, HadoopPluginSettingsHelper.PluginsSettingsState state) {
        jobConf.set(SHAKER_JOB_PLUGINSETTINGSSTATE, JSON.pretty((Object)state));
    }

    public static HadoopPluginSettingsHelper.PluginsSettingsState getPluginSettingsState(Configuration jobConf) {
        ShakerEnvironment.setup();
        String jsonified = jobConf.get(SHAKER_JOB_PLUGINSETTINGSSTATE);
        if (StringUtils.isBlank((String)jsonified)) {
            throw new RuntimeException("dku.shaker.pluginSettingsState isn't defined");
        }
        return (HadoopPluginSettingsHelper.PluginsSettingsState)JSON.parse((String)jsonified, HadoopPluginSettingsHelper.PluginsSettingsState.class);
    }

    public static void setPluginStepsState(Configuration jobConf, HadoopJythonPluginsHelper.PluginsWithJythonState state) {
        jobConf.set(SHAKER_JOB_PLUGINSTEPSTATE, JSON.pretty((Object)state));
    }

    public static HadoopJythonPluginsHelper.PluginsWithJythonState getPluginStepsState(Configuration jobConf) {
        ShakerEnvironment.setup();
        String jsonified = jobConf.get(SHAKER_JOB_PLUGINSTEPSTATE);
        if (StringUtils.isBlank((String)jsonified)) {
            throw new RuntimeException("dku.shaker.pluginStepsState isn't defined");
        }
        return (HadoopJythonPluginsHelper.PluginsWithJythonState)JSON.parse((String)jsonified, HadoopJythonPluginsHelper.PluginsWithJythonState.class);
    }

    public static SerializedShakerScript getJobScript(Configuration jobConf) {
        ShakerEnvironment.setup();
        String jsonified = jobConf.get(SHAKER_JOB_SCRIPT);
        if (StringUtils.isBlank((String)jsonified)) {
            throw new RuntimeException("dku.shaker.script isn't defined");
        }
        return (SerializedShakerScript)JSON.parse((String)jsonified, SerializedShakerScript.class);
    }

    public static ResourceMapping getJobResourceMapping(Configuration jobConf) {
        ShakerEnvironment.setup();
        String jsonified = jobConf.get(SHAKER_JOB_RESOURCES);
        if (StringUtils.isBlank((String)jsonified)) {
            throw new RuntimeException("dku.shaker.resources isn't defined");
        }
        return (ResourceMapping)JSON.parse((String)jsonified, ResourceMapping.class);
    }

    public static class ResourceMapping {
        public Map<String, String> resourceFiles = new HashMap<String, String>();

        public ResourceMapping(Map<String, String> resourceFiles) {
            this.resourceFiles = resourceFiles;
        }

        public ResourceMapping() {
        }
    }

    public static class YarnPythonBinsDefinition {
        public final String builtinYarnPythonBin;
        public final Map<String, String> yarnPythonBins;
        public final Map<String, String> pythonPachageZips;

        public YarnPythonBinsDefinition(String builtinPythonBin, Map<String, String> pythonBins, Map<String, String> pythonPachageZips) {
            this.builtinYarnPythonBin = builtinPythonBin;
            this.yarnPythonBins = pythonBins;
            this.pythonPachageZips = pythonPachageZips;
        }

        public YarnPythonBinsDefinition() {
            this.builtinYarnPythonBin = null;
            this.yarnPythonBins = new HashMap<String, String>();
            this.pythonPachageZips = new HashMap<String, String>();
        }
    }
}

