/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.custom.RemoteCustomJavaRuntimeDataProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.custom.CustomJavaFormatMeta;
import com.dataiku.dip.formats.custom.CustomJavaFormatParams;
import com.dataiku.dip.formats.custom.LoadedJavaFormat;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class CustomJavaFormatDependenciesHandler {
    private static final String LOADED_DESC_CONF_NAME = "dip.custom.format.java.desc";
    private static final String LOADED_DESC_CONF_PLUGIN_SETTINGS = "dip.custom.format.java.plugin.settings";
    private static Logger logger = Logger.getLogger((String)"dip.mrimpl.formats.custom.deps");

    public static void registerDependencies(AuthCtx authCtx, String suffix, Dataset dataset, List<SimpleKeyValue> configKeys, List<File> resourceJars) throws IOException, DKUSecurityException {
        CustomJavaFormatMeta formatMeta = (CustomJavaFormatMeta)FormatFactory.getMeta(dataset.getFormatType());
        String loadedType = formatMeta.getLoadedDesc().getType();
        configKeys.add(new SimpleKeyValue(LOADED_DESC_CONF_NAME + suffix, JSON.json((Object)formatMeta.getLoadedDesc())));
        CustomJavaFormatParams formatParams = dataset.getFormatParamsAs(CustomJavaFormatParams.class);
        PluginSettingsResolver.ResolvedSettings resolvedSettings = formatMeta.getService().getExpandedPluginSettings(loadedType, authCtx, dataset.getProjectKey(), formatParams.config);
        JsonObject pluginSettings = resolvedSettings.pluginConfig;
        if (pluginSettings == null) {
            pluginSettings = new JsonObject();
        }
        configKeys.add(new SimpleKeyValue(LOADED_DESC_CONF_PLUGIN_SETTINGS + suffix, JSON.json((Object)pluginSettings)));
        URLClassLoader classLoader = (URLClassLoader)formatMeta.getService().getClassloader(loadedType);
        ArrayList urlPathsToSkip = Lists.newArrayList();
        urlPathsToSkip.add(new File(ApplicationConfigurator.getInstallFolder() + "/dist/dataiku-core.jar").getAbsolutePath());
        urlPathsToSkip.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/ivy/common-run").getAbsolutePath());
        urlPathsToSkip.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib").getAbsolutePath());
        urlPathsToSkip.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/dss-shadelib").getAbsolutePath());
        for (URL url : classLoader.getURLs()) {
            try {
                File file = new File(url.toURI());
                boolean skip = false;
                for (String urlPathToSkip : urlPathsToSkip) {
                    if (!file.getAbsolutePath().startsWith(urlPathToSkip)) continue;
                    skip = true;
                }
                if (skip) {
                    logger.info((Object)"File is already distributed to workers as a jar");
                    continue;
                }
                logger.info((Object)("Adding " + url.toString() + " as resource"));
                resourceJars.add(file);
            }
            catch (URISyntaxException e) {
                logger.warn((Object)"Cannot get file for resource", (Throwable)e);
            }
        }
    }

    public static void loadDependencies(String suffix, Configuration hadoopJobConf) throws IOException {
        LoadedJavaFormat loaded = (LoadedJavaFormat)JSON.parse((String)hadoopJobConf.get(LOADED_DESC_CONF_NAME + suffix), LoadedJavaFormat.class);
        if (!FormatFactory.has(loaded.getType())) {
            JsonObject pluginSettings = (JsonObject)JSON.parse((String)hadoopJobConf.get(LOADED_DESC_CONF_PLUGIN_SETTINGS + suffix), JsonObject.class);
            ClassLoader classLoader = CustomJavaFormatDependenciesHandler.class.getClassLoader();
            RemoteCustomJavaRuntimeDataProvider service = new RemoteCustomJavaRuntimeDataProvider(pluginSettings, classLoader);
            FormatFactory.registerFormatType(new CustomJavaFormatMeta(loaded, service));
        }
    }
}

