/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.formats.custom.CustomJavaFormatParams;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.hive.HiveFileFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.mrimpl.DiagnosticsHandler;
import com.dataiku.dip.shaker.mrimpl.ShakerEnvironment;
import com.dataiku.dip.shaker.mrimpl.formats.AvroOutputFormatAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.CSVOutputFormatAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.CustomJavaFormatOutputAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.HiveOutputFormatAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.ParquetOutputFormatAdapter;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.ContextType;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class UniversalFileOutputFormat
extends FileOutputFormat<Void, RowWithFactories> {
    public static final String OUTPUT_DATASET_CONFIG = "dku.shaker.output.config";
    public static final String OUTPUT_DATASET_FORMAT_CLASS = "dku.shaker.output.format.class";
    private static final DKULogger logger = DKULogger.getLogger(UniversalFileOutputFormat.class);
    private FileOutputFormat<Void, RowWithFactories> outputFormat;
    private WarningsContext warningsContext = new WarningsContext();

    public static void setOutputDatasetConfig(Configuration jobConf, DatasetConfig dsConf) {
        Preconditions.checkNotNull((Object)dsConf);
        jobConf.set(OUTPUT_DATASET_CONFIG, JSON.pretty((Object)dsConf));
    }

    public static DatasetConfig getOutputDatasetConfig(Configuration jobConf) {
        ShakerEnvironment.setup();
        String val = jobConf.get(OUTPUT_DATASET_CONFIG);
        if (StringUtils.isBlank((String)val)) {
            throw new RuntimeException("Invalid blank param dku.shaker.output.config");
        }
        return (DatasetConfig)JSON.parse((String)val, DatasetConfig.class);
    }

    public static Class<? extends FileOutputFormat<Void, RowWithFactories>> getFormatAdapter(FormatParams formatParams) {
        if (formatParams instanceof ParquetFormatConfig) {
            return ParquetOutputFormatAdapter.class;
        }
        if (formatParams instanceof CSVFormatConfig) {
            return CSVOutputFormatAdapter.class;
        }
        if (formatParams instanceof HiveFileFormatConfig) {
            return HiveOutputFormatAdapter.class;
        }
        if (formatParams instanceof AvroFormatConfig) {
            return AvroOutputFormatAdapter.class;
        }
        if (formatParams instanceof CustomJavaFormatParams) {
            return CustomJavaFormatOutputAdapter.class;
        }
        return null;
    }

    public static void applyCompression(FormatParams formatParams, Configuration conf) {
        if (formatParams instanceof ParquetFormatConfig) {
            ParquetFormatConfig parquetConfig = (ParquetFormatConfig)formatParams;
            logger.info((Object)("Set compression for parquet to " + String.valueOf((Object)parquetConfig.parquetCompressionMethod)));
            try {
                Class<?> compressionCodecNameEnum = Class.forName("org.apache.parquet.hadoop.metadata.CompressionCodecName");
                Method valueOfMethod = compressionCodecNameEnum.getMethod("valueOf", String.class);
                Object compressionCodecName = valueOfMethod.invoke(null, parquetConfig.parquetCompressionMethod.name());
                String codecClassName = (String)compressionCodecNameEnum.getMethod("getHadoopCompressionCodecClassName", new Class[0]).invoke(compressionCodecName, new Object[0]);
                conf.setBoolean("mapreduce.output.fileoutputformat.compress", parquetConfig.parquetCompressionMethod != ParquetFormatConfig.CompressionMethod.UNCOMPRESSED);
                conf.set("mapreduce.output.fileoutputformat.compress.codec", codecClassName);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to set compression for parquet", (Throwable)e);
            }
        } else if (formatParams instanceof CSVFormatConfig) {
            CSVFormatConfig csvConfig = (CSVFormatConfig)formatParams;
            logger.info((Object)("Set compression for csv to " + csvConfig.compress));
            if ("gz".equals(csvConfig.compress)) {
                conf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
                conf.set("mapreduce.output.fileoutputformat.compress.codec", "org.apache.hadoop.io.compress.GzipCodec");
            } else {
                conf.setBoolean("mapreduce.output.fileoutputformat.compress", false);
            }
        } else if (formatParams instanceof ORCFileFormatConfig) {
            ORCFileFormatConfig orcConfig = (ORCFileFormatConfig)formatParams;
            logger.info((Object)("Set compression for orc to " + String.valueOf((Object)orcConfig.compressionMethod)));
            if (orcConfig.compressionMethod == ORCFileFormatConfig.CompressionMethod.SNAPPY) {
                conf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
                conf.set("mapreduce.output.fileoutputformat.compress.codec", "org.apache.hadoop.io.compress.SnappyCodec");
            } else if (orcConfig.compressionMethod == ORCFileFormatConfig.CompressionMethod.ZLIB) {
                conf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
                conf.set("mapreduce.output.fileoutputformat.compress.codec", "org.apache.hadoop.io.compress.GzipCodec");
            } else {
                conf.setBoolean("mapreduce.output.fileoutputformat.compress", false);
            }
        } else if (formatParams instanceof AvroFormatConfig) {
            AvroFormatConfig avroConfig = (AvroFormatConfig)formatParams;
            logger.info((Object)("Set compression for avro to " + String.valueOf((Object)avroConfig.avroCompressionMethod)));
            if (avroConfig.avroCompressionMethod == AvroFormatConfig.AvroCompressionMethod.SNAPPY) {
                conf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
                conf.set("mapreduce.output.fileoutputformat.compress.codec", "org.apache.hadoop.io.compress.SnappyCodec");
            } else if (avroConfig.avroCompressionMethod == AvroFormatConfig.AvroCompressionMethod.DEFLATE_1 || avroConfig.avroCompressionMethod == AvroFormatConfig.AvroCompressionMethod.DEFLATE_5 || avroConfig.avroCompressionMethod == AvroFormatConfig.AvroCompressionMethod.DEFLATE_9) {
                conf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
                conf.set("mapreduce.output.fileoutputformat.compress.codec", "org.apache.hadoop.io.compress.DeflateCodec");
            } else {
                conf.setBoolean("mapreduce.output.fileoutputformat.compress", false);
            }
        }
    }

    public static void registerDependencies(AuthCtx authCtx, Dataset dataset, List<SimpleKeyValue> configKeys, List<File> resourceJars) throws IOException, DKUSecurityException {
        FormatParams formatParams = dataset.getFormatParams();
        logger.info((Object)("Check if format " + formatParams.getClass().getCanonicalName() + " has dependencies"));
        if (formatParams instanceof CustomJavaFormatParams) {
            CustomJavaFormatOutputAdapter.registerDependencies(authCtx, dataset, configKeys, resourceJars);
            configKeys.add(new SimpleKeyValue(OUTPUT_DATASET_FORMAT_CLASS, CustomJavaFormatOutputAdapter.class.getCanonicalName()));
        }
    }

    private void lazyInit(Configuration hadoopJobConf) throws IOException {
        if (this.outputFormat == null) {
            String formatAdapterClass = hadoopJobConf.get(OUTPUT_DATASET_FORMAT_CLASS);
            if (StringUtils.isNotBlank((String)formatAdapterClass)) {
                try {
                    Class<?> formatAdapterClazz = Class.forName(formatAdapterClass);
                    Method loadMethod = formatAdapterClazz.getMethod("loadDependencies", Configuration.class);
                    loadMethod.invoke(null, hadoopJobConf);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IOException("Unknown format class", e);
                }
            }
            DatasetConfig outputConf = UniversalFileOutputFormat.getOutputDatasetConfig(hadoopJobConf);
            FormatParams formatParams = outputConf.dataset.getFormatParams();
            Class<? extends FileOutputFormat<Void, RowWithFactories>> outputFormatClass = UniversalFileOutputFormat.getFormatAdapter(formatParams);
            if (outputFormatClass != null) {
                logger.info((Object)("Using output format adapter : " + outputFormatClass.getName()));
                Object[] args = new Object[]{outputConf, this.warningsContext};
                try {
                    this.outputFormat = outputFormatClass.cast(ConstructorUtils.invokeConstructor(outputFormatClass, (Object[])args));
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to instantiate " + outputFormatClass.getName()));
                }
            } else {
                throw new RuntimeException("Unsupported output format : " + outputConf.dataset.formatType);
            }
            try {
                UniversalFileOutputFormat.applyCompression(formatParams, hadoopJobConf);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to apply compression on " + outputFormatClass.getName() + ", will write uncompressed"), (Throwable)e);
            }
        }
    }

    public void checkOutputSpecs(JobContext job) throws IOException {
        this.lazyInit(job.getConfiguration());
        this.outputFormat.checkOutputSpecs(job);
    }

    public RecordWriter<Void, RowWithFactories> getRecordWriter(final TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        try {
            this.lazyInit(taskAttemptContext.getConfiguration());
            final RecordWriter realRecordWriter = this.outputFormat.getRecordWriter(taskAttemptContext);
            return new RecordWriter<Void, RowWithFactories>(){

                public void write(Void aVoid, RowWithFactories mrRow) throws IOException, InterruptedException {
                    try {
                        realRecordWriter.write((Object)aVoid, (Object)mrRow);
                    }
                    catch (Exception e) {
                        DiagnosticsHandler.saveFatalError(ContextType.OUTPUT, e, taskAttemptContext);
                        throw e;
                    }
                }

                public void close(TaskAttemptContext taskAttemptContext2) throws IOException, InterruptedException {
                    try {
                        realRecordWriter.close(taskAttemptContext2);
                    }
                    catch (Exception e) {
                        DiagnosticsHandler.saveFatalError(ContextType.OUTPUT, e, taskAttemptContext2);
                        throw e;
                    }
                    finally {
                        DiagnosticsHandler.saveWarningsContext(ContextType.OUTPUT, taskAttemptContext2, UniversalFileOutputFormat.this.warningsContext);
                    }
                }
            };
        }
        catch (Exception e) {
            DiagnosticsHandler.saveFatalError(ContextType.OUTPUT, e, taskAttemptContext);
            throw e;
        }
    }

    public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        try {
            this.lazyInit(context.getConfiguration());
            return this.outputFormat.getOutputCommitter(context);
        }
        catch (Exception e) {
            DiagnosticsHandler.saveFatalError(ContextType.OUTPUT, e, context);
            throw e;
        }
    }

    public Path getDefaultWorkFile(TaskAttemptContext context, String extension) throws IOException {
        try {
            this.lazyInit(context.getConfiguration());
            return this.outputFormat.getDefaultWorkFile(context, extension);
        }
        catch (Exception e) {
            DiagnosticsHandler.saveFatalError(ContextType.OUTPUT, e, context);
            throw e;
        }
    }
}

