/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.reshaping.MultiColumnFoldMeta;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class MultiColumnFold
extends SingleInputSingleOutputRowProcessor
implements Processor {
    public static final ProcessorMeta<MultiColumnFold, Parameter> META = new MultiColumnFoldMeta<MultiColumnFold, Parameter>(){

        @Override
        public String getName() {
            return "MultiColumnFold";
        }

        @Override
        public String getDocPage() {
            return "fold-columns-by-name";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.MultiColumnFold.HELP", "Perform the opposite of a pivot and fold a **list of columns**, transforming a wide dataset into a narrow one. This is also sometimes called a melt. This processor outputs two columns: one containing **column names** and the other containing **column values**.\n# Example\n<table><tr><th>student</th><th>math</th><th>science</th><th>arts</th></tr><tr><td>Marie</td><td>85</td><td>83</td><td>81</td></tr><tr><td>Caroline</td><td>74</td><td>91</td><td>86</td></tr><tr><td>Paul</td><td>70</td><td>85</td><td>89</td></tr>\nApplying \u201cFold multiple columns\u201d with `class` for folded column names and `grade` for folded values generates the following table:\n<table><tr><th>student</th><th>class</th><th>grade</th></tr><tr><td>Marie</td><td>math</td><td>85</td></tr><tr><td>Marie</td><td>science</td><td>83</td></tr><tr><td>Marie</td><td>arts</td><td>81</td></tr><tr><td>Caroline</td><td>math</td><td>74</td></tr><tr><td>Caroline</td><td>science</td><td>91</td></tr><tr><td>Caroline</td><td>arts</td><td>86</td></tr><tr><td>Paul</td><td>math</td><td>70</td></tr><tr><td>Paul</td><td>science</td><td>85</td></tr><tr><td>Paul</td><td>arts</td><td>89</td></tr>\n# Options\n**Column for folded column names**\nColumn containing the names of folded columns.\n**Column for folded values**\nColumn containing the values of folded columns.\n**Remove folded columns**\nRemove the now empty folded columns.\n# Related resources\nFor more information, read about [reshaping data](https://doc.dataiku.com/dss/latest/preparation/reshaping.html) in the Dataiku documentation.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            ParamDesc columnsParam = new ParamDesc("columns", "columns").withDefaultValue(Collections.emptyList()).withMandatory(true).withLabel(this.translate(language, "SHAKER.PROCESSOR.MultiColumnFold.DESCRIPTION.COLUMN_LIST", "Column List"));
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.MultiColumnFold.DESCRIPTION", 1.actionVerb("Fold") + " multiple columns")).withParam(columnsParam).withParam("foldNameColumn", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.MultiColumnFold.DESCRIPTION.FOLD_NAME_COLUMN", "Column for fold name")).withParam("foldValueColumn", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.MultiColumnFold.DESCRIPTION.FOLD_VALUE_COLUMN", "Column for fold value")).withBool("foldRemoveFoldedColumns", this.translate(language, "SHAKER.PROCESSOR.MultiColumnFold.DESCRIPTION.FOLD_REMOVE_FOLDED_COLUMNS", "Remove folded columns"));
        }

        @Override
        public Object selfReport(Parameter p) {
            JsonObject out = new JsonObject();
            if (p.foldRemoveFoldedColumns != null) {
                out.addProperty("foldRemoveFoldedColumns", p.foldRemoveFoldedColumns);
            }
            return out;
        }

        @Override
        public MultiColumnFold build(Parameter parameter) throws Exception {
            return new MultiColumnFold(parameter.columns, parameter.foldNameColumn, parameter.foldValueColumn, parameter.foldRemoveFoldedColumns);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter multiColumnFoldParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = this.getUpdatedDatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage, (Collection<String>)multiColumnFoldParams.columns, multiColumnFoldParams.foldNameColumn, multiColumnFoldParams.foldValueColumn, multiColumnFoldParams.foldRemoveFoldedColumns);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private List<String> columns;
    private List<Column> inCDs = new ArrayList<Column>();
    private String foldNameColumn;
    private Column foldNameCD;
    private String foldValueColumn;
    private Column foldValueCD;
    private Boolean foldRemoveFoldedColumns;

    public MultiColumnFold(List<String> columns, String foldNameColumn, String foldValueColumn, Boolean foldRemoveFoldedColumns) {
        this.columns = columns;
        this.foldNameColumn = foldNameColumn;
        this.foldValueColumn = foldValueColumn;
        this.foldRemoveFoldedColumns = foldRemoveFoldedColumns == null ? false : foldRemoveFoldedColumns;
    }

    public void init() {
        for (String col : this.columns) {
            this.inCDs.add(this.getCf().column(col, Processor.ProcessorRole.INPUT_COLUMN));
        }
        this.foldNameCD = this.getCf().column(this.foldNameColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
        this.foldValueCD = this.getCf().column(this.foldValueColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        for (Column inCD : this.inCDs) {
            String v = row.get(inCD);
            if (v == null || v.isEmpty()) continue;
            Row newRow = this.getRf().row();
            for (Column c2 : this.getCf().columns()) {
                String colVal;
                boolean copyThisColumn = true;
                for (Column inCD2 : this.inCDs) {
                    if (inCD2 != c2) continue;
                    copyThisColumn = false;
                    break;
                }
                if (!copyThisColumn || StringUtils.isBlank((String)(colVal = row.get(c2)))) continue;
                newRow.put(c2, colVal);
            }
            newRow.put(this.foldNameCD, inCD.getName());
            newRow.put(this.foldValueCD, v);
            this.getProcessorOutput().emitRow(newRow);
        }
    }

    public void postProcess() throws Exception {
        if (this.foldRemoveFoldedColumns.booleanValue()) {
            for (String column : this.columns) {
                this.getCf().deleteColumn(column);
            }
        }
        this.getProcessorOutput().lastRowEmitted();
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public List<String> columns = new ArrayList<String>();
        public String foldNameColumn;
        public String foldValueColumn;
        Boolean foldRemoveFoldedColumns;

        public void validate() throws IllegalArgumentException {
        }
    }
}

