/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public abstract class MultiColumnFoldMeta<T extends Processor, P extends StepParams>
extends ProcessorMeta<T, P> {
    public DatasetPairLineage getUpdatedDatasetPairLineage(DatasetPairLineage previousDatasetPairLineage, Collection<String> inputColumns, String foldNameColumn, String foldValueColumn, Boolean foldRemoveFoldedColumns) {
        if (StringUtils.isBlank((String)foldNameColumn)) {
            throw new IllegalConfigurationException("Missing input name column information for lineage on the multi column fold processor.");
        }
        if (StringUtils.isBlank((String)foldValueColumn)) {
            throw new IllegalConfigurationException("Missing input value column information for lineage on the multi column fold processor.");
        }
        DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage(previousDatasetPairLineage);
        if (!inputColumns.contains(foldNameColumn)) {
            updatedDatasetPairLineage.removeRelationsOnColumn(foldNameColumn);
        }
        if (!inputColumns.contains(foldValueColumn)) {
            updatedDatasetPairLineage.removeRelationsOnColumn(foldValueColumn);
        }
        HashSet<String> directRelationColumns = new HashSet<String>(inputColumns);
        directRelationColumns.add(foldNameColumn);
        directRelationColumns.add(foldValueColumn);
        for (String inputColumn : inputColumns) {
            updatedDatasetPairLineage.addFactorizedColumnRelations(inputColumn, foldNameColumn);
            updatedDatasetPairLineage.addFactorizedColumnRelations(inputColumn, foldValueColumn);
            for (String outputColumn : updatedDatasetPairLineage.getOutputColumns()) {
                if (directRelationColumns.contains(outputColumn)) continue;
                updatedDatasetPairLineage.addFactorizedColumnRelations(inputColumn, outputColumn, true);
            }
        }
        if (foldRemoveFoldedColumns != null) {
            for (String inputColumn : inputColumns) {
                updatedDatasetPairLineage.removeRelationsOnColumn(inputColumn);
            }
        }
        return updatedDatasetPairLineage;
    }
}

