/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPuller;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.server.AdditionalInputAccessor;
import com.dataiku.dip.util.DatasetLocUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class StreamedAdditionalInputAccessor
implements AdditionalInputAccessor {
    private final AuthCtx authCtx;
    private final String projectKey;
    private final DatasetsDAO dao;
    private StreamAdditionalInput sai;
    private static Logger logger = Logger.getLogger((String)"dku.shaker.additional");

    public StreamedAdditionalInputAccessor(AuthCtx authCtx, String projectKey, DatasetsDAO dao) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.dao = dao;
    }

    @Override
    public StreamAdditionalInput getAdditionalInput(String name) throws Exception {
        SerializedDataset sd = (SerializedDataset)this.dao.getMandatory(DatasetLocUtils.resolveSmart(this.projectKey, name));
        Dataset dataset = Dataset.fromSerialized(sd);
        this.sai = new StreamAdditionalInput();
        this.sai.cf.storeMessages = true;
        this.sai.dataset = dataset;
        logger.info((Object)"Ready to read additional input");
        return this.sai;
    }

    public InfoMessage getColumnFactoryMessages() {
        if (this.sai != null && this.sai.cf != null) {
            List unknownInputColumnsBuffer = this.sai.cf.getUnknownInputColumnBuffer();
            if (unknownInputColumnsBuffer.isEmpty()) {
                return null;
            }
            StringBuilder detailsBuilder = new StringBuilder();
            detailsBuilder.append(unknownInputColumnsBuffer.size() > 1 ? "Input columns " : "Input column ");
            detailsBuilder.append("<b>").append((String)unknownInputColumnsBuffer.get(0)).append("</b>");
            if (unknownInputColumnsBuffer.size() > 1) {
                for (int i = 1; i < unknownInputColumnsBuffer.size(); ++i) {
                    detailsBuilder.append(", <b>").append((String)unknownInputColumnsBuffer.get(i)).append("</b>");
                }
                detailsBuilder.append(",");
            }
            detailsBuilder.append(unknownInputColumnsBuffer.size() > 1 ? " do not exist, this might lead to erratic outcome." : " does not exist, this might lead to erratic outcome.");
            return InfoMessage.warning((InfoMessage.MessageCode)ScriptStep.StepCodes.WARN_SCRIPTSTEP_UNKNOWN_INPUT_COLUMN, (String)detailsBuilder.toString());
        }
        return null;
    }

    public class StreamAdditionalInput
    implements AdditionalInputAccessor.AdditionalInput {
        Dataset dataset;
        StreamColumnFactory cf = new StreamColumnFactory();

        @Override
        public ColumnFactory getColumnFactory() {
            return this.cf;
        }

        @Override
        public RowInputStream getInput() throws Exception {
            return UniversalSingleThreadPuller.pull(StreamedAdditionalInputAccessor.this.authCtx, this.dataset, StreamableDatasetSelection.full(), (ColumnFactory)this.cf);
        }
    }
}

