/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.sparksql;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.spark.sparksql.DkuPreparedStatementBase;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DkuSparkSQLPreparedStatement
extends DkuPreparedStatementBase {
    private final String sql;
    private static Logger logger = Logger.getLogger((String)"dip.livy.statement.prepared");

    DkuSparkSQLPreparedStatement(DkuSparkSQLConnection connection, int fetchSize, String sql) {
        super(connection, fetchSize);
        this.sql = sql;
    }

    @Override
    protected void doPrepare() throws SQLException {
        logger.info((Object)"Preparing statement");
        this.response = this.connection.getSparkSQLHandler().executePreparedStatement(this.connection.getDatabase(), this.sql);
        if (this.response.error != null) {
            throw new SQLException(StringUtils.defaultIfBlank((String)this.response.error.message, (String)"Failed to execute sql"), new APIError.SerializedErrorException(this.response.error));
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.sql);
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.sql);
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch(this.sql);
    }
}

