/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.pivot.backend.sql.utils.QueryUtils;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SQLServerSQLDialect
extends GenericSQLDialect {
    private static final Map<String, String> dateStyles = Maps.newHashMap();
    private static final Set<String> UNITS;
    public static final long BIG_INT_MAX_VALUE = Long.MAX_VALUE;
    private static final Logger logger;

    @Override
    protected boolean canWriteInfinityOrNaN() {
        return false;
    }

    @Override
    public boolean needSubQueryForConstantInWhereClause() {
        return true;
    }

    @Override
    public boolean integerAggregateCanOverflow() {
        return true;
    }

    @Override
    public String cleanupColumnName(String columnName) {
        return columnName;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 5, "smallint", new Integer[0]);
            }
            case SMALLINT: {
                return new DSSTypeSQLMapping(Type.SMALLINT, 5, "smallint", new Integer[0]);
            }
            case INT: {
                return new DSSTypeSQLMapping(Type.INT, 4, "int", new Integer[0]);
            }
            case BIGINT: {
                return new DSSTypeSQLMapping(Type.BIGINT, -5, "bigint", new Integer[]{2});
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 7, "real", new Integer[]{6});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "float", new Integer[]{7, 2, 3});
            }
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, -9, "nvarchar(" + String.valueOf(schemaColumn.getMaxLength() > 0 && schemaColumn.getMaxLength() <= 4000 ? Integer.valueOf(schemaColumn.getMaxLength()) : (this.getMaxPossibleVarcharLen() < 0 ? "max" : Integer.valueOf(this.getMaxPossibleVarcharLen()))) + ")", new Integer[]{2003, 1111, 1, -15, 12, -1, -16, 91, 93, 92});
            }
            case BOOLEAN: {
                return new DSSTypeSQLMapping(Type.BOOLEAN, -7, "bit", new Integer[]{16});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, -155, "datetimeoffset", new Integer[]{91, 93});
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 91, "date", new Integer[]{93, -155});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "datetime2", new Integer[]{91, -155});
            }
            case GEOMETRY: 
            case GEOPOINT: 
            case MAP: 
            case ARRAY: 
            case OBJECT: {
                this.throwUnhandledColumnType(schemaColumn, dataset);
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        if (sqlType == 3 || sqlType == 2) {
            return new SchemaColumn(name, sqlScale == 0 ? Type.BIGINT : Type.DOUBLE);
        }
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public String booleanRepr(Boolean b) {
        if (b == null) {
            return "NULL";
        }
        return b != false ? "1" : "0";
    }

    @Override
    public String quoteDate(String str) {
        return this.cast(this.quoteString(str), Type.STRING, Type.DATE, -1);
    }

    @Override
    public String quoteDateOnly(String str) {
        return this.cast(this.quoteString(str), Type.STRING, Type.DATEONLY, -1);
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return this.cast(this.quoteString(str), Type.STRING, Type.DATETIMENOTZ, -1);
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        switch (dssType) {
            default: 
        }
        super.fill(ps2, dssType, colIdx, dssStrVal);
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        switch (sqlType) {
            case -155: {
                this.ensureThreadLocalsAreHere();
                Timestamp ts = rs2.getTimestamp(colIdx, (Calendar)this.utcCalendar.get());
                if (ts == null) {
                    return null;
                }
                return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public boolean isCatalogAware() {
        return true;
    }

    @Override
    public boolean needsDoubleNormalization() {
        return false;
    }

    @Override
    public boolean hasCaseInsensitiveComparisons() {
        return true;
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        if (ifNotExist) {
            AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
            return "IF OBJECT_ID(N'" + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + "', N'U') IS NULL\n" + super.generateTableStatementSQL(connection, dataset, messages, false);
        }
        return super.generateTableStatementSQL(connection, dataset, messages, false);
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        query = query.trim();
        if (Pattern.compile("select +(all|distinct|top) ").matcher(query.toLowerCase().replaceAll("[^A-z0-9-_\\.]", " ")).find()) {
            return query;
        }
        if (query.toLowerCase().startsWith("select")) {
            return "select top(" + size + ") " + query.substring("select".length());
        }
        return query;
    }

    @Override
    public SQLDialect.LimitMethod getLimitMethod() {
        return SQLDialect.LimitMethod.TOP;
    }

    @Override
    public String limitQueryUsingWhere(long size) {
        throw new IllegalArgumentException("SQL dialect doe not support limits in WHERE clause");
    }

    @Override
    public String getSafeRandomTemporaryTableName(String prefix) {
        return QueryUtils.safeRandomIdentifier("#" + prefix);
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        assert (table.getTable().startsWith("#"));
        return "CREATE TABLE " + this.getQuotedTableFullName(table) + " (" + columnListExpr + ")";
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        assert (table.getTable().startsWith("#"));
        return new String[]{"SELECT * INTO " + this.getQuotedTableFullName(table) + " FROM (" + selectExpr + ") tmp"};
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        return false;
    }

    protected boolean supportEscapeKeywordAfterLikeOperator() {
        return true;
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return -1;
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addGenericFunction(QueryUtils.OperatorType.COUNT, "COUNT_BIG", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CAST_BOOL_TO_COLUMN, "CAST", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return String.format("CONVERT(BIT, CASE WHEN %s THEN 1 ELSE 0 END)", ret);
            }
        });
        this.addOperator(this.hashingOperator(QueryUtils.OperatorType.SHA256, "SHA2_256"));
        this.addOperator(this.hashingOperator(QueryUtils.OperatorType.SHA512, "SHA2_512"));
        this.addOperator(this.hashingOperator(QueryUtils.OperatorType.MD5, "MD5"));
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_SAMP, "STDEV", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_POP, "STDEVP", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.VARIANCE_SAMP, "VAR", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.VARIANCE_POP, "VARP", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.CEIL, "CEILING", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.LN, "LOG", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.LENGTH, "LEN", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.UNIQUE_ID, QueryUtils.Arity.NO_ARG){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return "ROW_NUMBER() OVER (ORDER BY (SELECT 1))";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRIM, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return "LTRIM(RTRIM(" + this.toSQLNoBrackets(args[0]) + "))";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRANSLATE, QueryUtils.Arity.NARY){

            private String replace(String str, String x, String y) {
                return "REPLACE(" + str + ", " + SQLServerSQLDialect.this.quoteString(x) + ", " + SQLServerSQLDialect.this.quoteString(y) + ")";
            }

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 3;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                String ret = this.toSQLNoBrackets(args[0]);
                String from = this.getParamAs(args[1], String.class);
                String to = this.getParamAs(args[2], String.class);
                for (int i = 0; i < from.length() && i < to.length(); ++i) {
                    ret = this.replace(ret, from.substring(i, i + 1), to.substring(i, i + 1));
                }
                return ret;
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.NOW, "SYSDATETIMEOFFSET", QueryUtils.Arity.NO_ARG);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String end = this.toSQLNoBrackets(args[0]);
                String start = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                if (!UNITS.contains(unit.toLowerCase())) {
                    throw new IllegalArgumentException(String.format("Unknown datepart: '%s' for DATEDIFF", unit));
                }
                return String.format("DATEDIFF(%s, %s, %s)", unit, start, end);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                if (!UNITS.contains(unit.toLowerCase())) {
                    throw new IllegalArgumentException(String.format("Unknown datepart: '%s' for DATEADD", unit));
                }
                return String.format("DATEADD(%s, %s, %s)", unit, addIntLong, datetimeNoTz);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                if (args.length > 2 && args[2] != null) {
                    String timezone1Id = (String)((QueryAst.ConstExpr)args[1]).value;
                    String timezone2Id = (String)((QueryAst.ConstExpr)args[2]).value;
                    DateTimeZone timezone1 = timezone1Id != null && timezone1Id.length() > 0 ? DateTimeZone.forID((String)timezone1Id) : DateTimeZone.getDefault();
                    int offset1 = timezone1.getStandardOffset(0L) / 1000 / 60;
                    DateTimeZone timezone2 = timezone2Id != null && timezone2Id.length() > 0 ? DateTimeZone.forID((String)timezone2Id) : DateTimeZone.getDefault();
                    int offset2 = timezone2.getStandardOffset(0L) / 1000 / 60;
                    logger.warn((Object)("Daylight savings are not handled in SQL Server time zone conversions. Conversion of " + this.toSQLNoBrackets(args[0]) + " may contain values off by 1 hour."));
                    return "SWITCHOFFSET(TODATETIMEOFFSET( SWITCHOFFSET( " + this.toSQLNoBrackets(args[0]) + " , " + offset1 + "), " + offset2 + " ), 0)";
                }
                if (args[1] != null) {
                    String timezoneId = (String)((QueryAst.ConstExpr)args[1]).value;
                    DateTimeZone timezone = timezoneId != null && timezoneId.length() > 0 ? DateTimeZone.forID((String)timezoneId) : DateTimeZone.getDefault();
                    int offset = timezone.getStandardOffset(0L) / 1000 / 60;
                    logger.warn((Object)("Daylight savings are not handled in SQL Server time zone conversions. Conversion of " + this.toSQLNoBrackets(args[0]) + " may contain values off by 1 hour."));
                    return "SWITCHOFFSET(TODATETIMEOFFSET( " + this.toSQLNoBrackets(args[0]) + " , " + offset + "), 0) ";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LEAST, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                return "(CASE WHEN " + this.toSQLNoBrackets(args[0]) + " > " + this.toSQLNoBrackets(args[1]) + " then " + this.toSQLNoBrackets(args[1]) + " else " + this.toSQLNoBrackets(args[0]) + " end)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.GREATEST, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                return "(CASE WHEN " + this.toSQLNoBrackets(args[0]) + " <= " + this.toSQLNoBrackets(args[1]) + " then " + this.toSQLNoBrackets(args[1]) + " else " + this.toSQLNoBrackets(args[0]) + " end)";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.ISTRUE, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String x = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String x2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                return x + " != 0 AND " + x2 + " IS NOT NULL";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.ISFALSE, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String x = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String x2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                return x + " = 0 AND " + x2 + " IS NOT NULL";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NOT, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.NOT.priority, false){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String arg1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.NOT.priority);
                return "NOT " + arg1;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " != " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                String oneIsNull = null;
                if (!aIsConst && !bIsConst) {
                    oneIsNull = a2 + " IS NULL AND " + b2 + " IS NOT NULL OR " + a2 + " IS NOT NULL AND " + b2 + " IS NULL";
                } else if (!aIsConst) {
                    oneIsNull = a2 + " IS NULL";
                } else if (!bIsConst) {
                    oneIsNull = b2 + " IS NULL";
                }
                if (oneIsNull != null) {
                    ret = ret + " OR " + oneIsNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.GT, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " > " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.LT, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " < " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.GE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " >= " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.LE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " <= " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.EQ, "=", QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " = " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                String bothNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNull = a2 + " IS NULL AND " + b2 + " IS NULL";
                }
                if (bothNull != null) {
                    ret = ret + " OR " + bothNull;
                }
                return ret;
            }
        });
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.CONTAINS, true, this.supportEscapeKeywordAfterLikeOperator()){

            @Override
            QueryAst.Expr escapeLikeExpr(QueryAst.Expr expr) {
                return this.ebf.expr((QueryAst.Expr)expr).replace((Object)"\\", (Object)"\\\\").replace((Object)"%", (Object)"\\%").replace((Object)"_", (Object)"\\_").replace((Object)"[", (Object)"\\[").replace((Object)"]", (Object)"\\]").expr;
            }
        });
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.STARTS_WITH, true, this.supportEscapeKeywordAfterLikeOperator()){

            @Override
            QueryAst.Expr escapeLikeExpr(QueryAst.Expr expr) {
                return this.ebf.expr((QueryAst.Expr)expr).replace((Object)"\\", (Object)"\\\\").replace((Object)"%", (Object)"\\%").replace((Object)"_", (Object)"\\_").replace((Object)"[", (Object)"\\[").replace((Object)"]", (Object)"\\]").expr;
            }
        });
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.ENDS_WITH, true, this.supportEscapeKeywordAfterLikeOperator()){

            @Override
            QueryAst.Expr escapeLikeExpr(QueryAst.Expr expr) {
                return this.ebf.expr((QueryAst.Expr)expr).replace((Object)"\\", (Object)"\\\\").replace((Object)"%", (Object)"\\%").replace((Object)"_", (Object)"\\_").replace((Object)"[", (Object)"\\[").replace((Object)"]", (Object)"\\]").expr;
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.SUBSTR, "SUBSTRING", QueryUtils.Arity.NARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_WIN, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_disc(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ") over()";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SET_CASE_SENSITIVITY, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                if (this.getParamAs(args[1], Boolean.class).booleanValue()) {
                    return "(" + this.toSQLNoBrackets(args[0]) + " COLLATE Latin1_General_CS_AS)";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType == Type.DATE) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = SQLServerSQLDialect.this.toDateFormat(jodaFormat, true);
                    String converted = "CONVERT(datetimeoffset, " + input + ", " + sqlFormat + ")";
                    if (StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return converted;
                    }
                    DateTimeZone timezone = timezoneId != null && timezoneId.length() > 0 ? DateTimeZone.forID((String)timezoneId) : DateTimeZone.getDefault();
                    int offset = timezone.getStandardOffset(0L) / 1000 / 60;
                    logger.warn((Object)("Daylight savings are not handled in SQL Server time zone conversions. Conversion of " + this.toSQLNoBrackets(args[0]) + " may contain values off by 1 hour."));
                    return "SWITCHOFFSET(TODATETIMEOFFSET( " + converted + " , " + offset + "), 0)";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRY_PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = SQLServerSQLDialect.this.toDateFormat(jodaFormat, true);
                    if (requestedType == Type.DATEONLY) {
                        return "TRY_CONVERT(date, " + input + ", " + sqlFormat + ")";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "TRY_CONVERT(datetime, " + input + ", " + sqlFormat + ")";
                    }
                    String converted = "TRY_CONVERT(datetimeoffset, " + input + ", " + sqlFormat + ")";
                    if (StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return converted;
                    }
                    DateTimeZone timezone = timezoneId != null && timezoneId.length() > 0 ? DateTimeZone.forID((String)timezoneId) : DateTimeZone.getDefault();
                    int offset = timezone.getStandardOffset(0L) / 1000 / 60;
                    logger.warn((Object)("Daylight savings are not handled in SQL Server time zone conversions. Conversion of " + this.toSQLNoBrackets(args[0]) + " may contain values off by 1 hour."));
                    return "SWITCHOFFSET(TODATETIMEOFFSET( " + converted + " , " + offset + "), 0)";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = SQLServerSQLDialect.this.toDateFormat(jodaFormat, false);
                    if (requestedType == Type.DATEONLY) {
                        return "CONVERT(varchar, " + (String)input + ", " + sqlFormat + ")";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "CONVERT(varchar, " + (String)input + ", " + sqlFormat + ")";
                    }
                    if (StringUtils.isNotBlank((String)timezoneId) && !StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        DateTimeZone timezone = timezoneId != null && timezoneId.length() > 0 ? DateTimeZone.forID((String)timezoneId) : DateTimeZone.getDefault();
                        int offset = timezone.getStandardOffset(0L) / 1000 / 60;
                        logger.warn((Object)("Daylight savings are not handled in SQL Server time zone conversions. Conversion of " + this.toSQLNoBrackets(args[0]) + " may contain values off by 1 hour."));
                        input = "SWITCHOFFSET(CAST( " + (String)input + " AS DATETIME), " + offset + ")";
                    }
                    if ("127".equals(sqlFormat)) {
                        return "CONVERT(varchar, " + (String)input + ", " + sqlFormat + ")";
                    }
                    return "CONVERT(varchar, CAST(" + (String)input + " AS DATETIME), " + sqlFormat + ")";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATN2", QueryUtils.Arity.BINARY);
        this.addGenericFunction(QueryUtils.OperatorType.RAND, "RAND", QueryUtils.Arity.NO_ARG);
        this.addGenericFunction(QueryUtils.OperatorType.DEC2HEX, "TO_HEX", QueryUtils.Arity.UNARY);
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.INDEX_OF, "(CHARINDEX(", " COLLATE Latin1_General_CS_AS) - 1)", true));
        this.addGenericFunction(QueryUtils.OperatorType.REVERSE_STR, "REVERSE", QueryUtils.Arity.UNARY);
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.DEC2HEX, "FORMAT(", ", 'x')"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SWITCH_WHEN, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String parameterFormat;
                String castParameter;
                this.validateMinNumberOfParameters(args, 3);
                int numberOfParameters = args.length;
                String expressionToMatch = this.toSQLNoBrackets(args[0]);
                if (expressionToMatch.equalsIgnoreCase("'true'")) {
                    castParameter = "1";
                    parameterFormat = "(CASE WHEN(%s) THEN 1 END) ";
                } else if (expressionToMatch.equalsIgnoreCase("'false'")) {
                    castParameter = "0";
                    parameterFormat = "(CASE WHEN(%s) THEN 1 END) ";
                } else {
                    castParameter = expressionToMatch;
                    parameterFormat = "%s";
                }
                StringBuilder caseWhenThen = new StringBuilder();
                caseWhenThen.append("CASE ").append(castParameter);
                for (int parameterIndex = 1; parameterIndex < numberOfParameters - 1; parameterIndex += 2) {
                    caseWhenThen.append(" WHEN ").append(String.format(parameterFormat, this.toSQLNoBrackets(args[parameterIndex]))).append(" THEN ").append(this.toSQLNoBrackets(args[parameterIndex + 1]));
                }
                if (numberOfParameters % 2 == 0) {
                    caseWhenThen.append(" ELSE ").append(this.toSQLNoBrackets(args[numberOfParameters - 1]));
                }
                return caseWhenThen.append(" END").toString();
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.IS_BLANK, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder col = ebf.expr(args[0]);
                if (args[0].outputType.dssType == Type.STRING) {
                    return this.toSQLWithBrackets(col.isnull().or((ExpressionBuilder[])new ExpressionBuilder[]{col.like((Object)ebf.cst((Object)""))}).expr);
                }
                return this.toSQLWithBrackets(col.isnull().or((ExpressionBuilder[])new ExpressionBuilder[]{col.castToString((int)100).length().nullUnsafeEq((Object)ebf.cst((Object)Integer.valueOf((int)0)))}).expr);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.CHAR, "CHAR", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "STRING_TO_TIMESTAMPTZ", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return SQLServerSQLDialect.this.cast(ret, Type.STRING, Type.DATE, -1);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_DATE, "STRING_TO_DATE", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return SQLServerSQLDialect.this.cast(ret, Type.STRING, Type.DATEONLY, -1);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "STRING_TO_TIMESTAMP", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return SQLServerSQLDialect.this.cast(ret, Type.STRING, Type.DATETIMENOTZ, -1);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.JSON_ARRAY_SUM, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                Object query = "COALESCE(\n";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "(SELECT SUM(TRY_CAST([value] AS FLOAT)) FROM OPENJSON({0}) WHERE ISJSON(TRY_CAST({0} AS VARCHAR(MAX))) = 1), \n";
                }
                query = (String)query + "        TRY_CAST({0} AS FLOAT),\n        0\n    )";
                return MessageFormat.format((String)query, input);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.JSON_ARRAY_COUNT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                Object query = "COALESCE(\n";
                if (!this.hasMultipleArgument(args)) {
                    query = (String)query + "(SELECT SUM(IIF(TRY_CAST([value] AS FLOAT) IS NULL, 0, 1)) FROM OPENJSON({0}) WHERE ISJSON(TRY_CAST({0} AS VARCHAR(MAX))) = 1), \n";
                }
                query = (String)query + "        IIF(TRY_CAST({0} AS FLOAT) IS NULL, 0, 1),\n        0\n    )";
                return MessageFormat.format((String)query, input);
            }
        });
        this.removeOperator(QueryUtils.OperatorType.REGEXP_REPLACE);
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            ArrayList clauses = Lists.newArrayList();
            for (String booleanTrueValue : this.booleanTrueValues) {
                clauses.add("LOWER(" + expr + ") = '" + booleanTrueValue + "'");
            }
            return "CONVERT(BIT, CASE WHEN (" + expr + ") IS NULL OR LEN(" + expr + ") = 0 THEN NULL WHEN " + Joiner.on((String)" OR ").join((Iterable)clauses) + " THEN 1 ELSE 0 END)";
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.NestedMultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.BracketedNoEscapeFinder.META};
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "DATEPART(day," + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "DATEPART(hh, " + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "DATEPART(mi, " + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "DATEPART(ss, " + inputDateExpression + ")";
            }
            case MILLISECOND_OF_SECOND: {
                return "DATEPART(ms, " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "DATEPART(m, " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "DATEPART(iso_week, " + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "DATEPART(quarter, " + inputDateExpression + ")";
            }
            case YEAR: {
                return "DATEPART(year, " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "DATEPART(dw, " + inputDateExpression + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "cast(DATEDIFF(s, '1970-01-01 00:00:00.000', " + inputDateExpression + " ) as bigint)";
            }
            case MILLIS_FROM_EPOCH: {
                return "DATEDIFF_BIG(ms, '1970-01-01 00:00:00.000', " + inputDateExpression + " )";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on SQL Server", part));
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        return this.datePartExpression(inputDateExpression, part);
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "DATEPART(day," + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "DATEPART(m, " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "DATEPART(iso_week, " + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "DATEPART(quarter, " + inputDateExpression + ")";
            }
            case YEAR: {
                return "DATEPART(year, " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "DATEPART(dw, " + inputDateExpression + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "cast(DATEDIFF(s, '1970-01-01 00:00:00.000', " + inputDateExpression + " ) as bigint)";
            }
            case MILLIS_FROM_EPOCH: {
                return "DATEDIFF_BIG(ms, '1970-01-01 00:00:00.000', " + inputDateExpression + " )";
            }
            case HOUR_OF_DAY: 
            case MINUTE_OF_HOUR: 
            case SECOND_OF_MINUTE: 
            case MILLISECOND_OF_SECOND: {
                throw new UnsupportedOperationException("No time part on date columns");
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on SQL Server", part));
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, "DATETIMEOFFSET");
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, "DATE");
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, "DATETIME2");
    }

    private String temporalTrunc(String inputDateExpression, DateRounding rounding, String convertTo) {
        String dateAtGmt = inputDateExpression;
        switch (rounding) {
            case DAY: {
                return "CONVERT(" + convertTo + ", CONVERT(DATE, " + dateAtGmt + "))";
            }
            case WEEK: {
                return "DATETRUNC(week, " + dateAtGmt + ")";
            }
            case MONTH: {
                return "CONVERT(" + convertTo + ", CONVERT(VARCHAR(7), " + dateAtGmt + ", 127) + '-01')";
            }
            case YEAR: {
                return "CONVERT(" + convertTo + ", CONVERT(VARCHAR(4), " + dateAtGmt + ", 127) + '-01-01')";
            }
            case QUARTER: {
                return "DATETRUNC(quarter, " + dateAtGmt + ")";
            }
            case HOUR: {
                if ("date".equalsIgnoreCase(convertTo)) {
                    throw new UnsupportedOperationException("time truncation not relevant for date");
                }
                return "CONVERT(" + convertTo + ", CONVERT(VARCHAR(13), " + dateAtGmt + ", 127) + ':00:00')";
            }
            case MINUTE: {
                if ("date".equalsIgnoreCase(convertTo)) {
                    throw new UnsupportedOperationException("time truncation not relevant for date");
                }
                return "CONVERT(" + convertTo + ", CONVERT(VARCHAR(16), " + dateAtGmt + ", 127) + ':00')";
            }
            case SECOND: {
                if ("date".equalsIgnoreCase(convertTo)) {
                    throw new UnsupportedOperationException("time truncation not relevant for date");
                }
                return dateAtGmt;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return true;
    }

    @Override
    public String getColumnExpressionForBoolean(String booleanExpression) {
        return "CASE WHEN " + booleanExpression + " THEN 1 ELSE 0 END";
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 128;
    }

    @Override
    public boolean supportsGreatest() {
        return false;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return false;
    }

    @Override
    public SQLDialect.NaturalJoinSupport getNaturalJoinSupport() {
        return SQLDialect.NaturalJoinSupport.NONE;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public String toDateFormat(String jodaFormat, boolean forParsing) {
        if (dateStyles.containsKey(jodaFormat)) {
            return dateStyles.get(jodaFormat);
        }
        throw new IllegalArgumentException("Format is not one of the accepted styles : " + jodaFormat);
    }

    @Override
    public SQLCapability canFormatDate(String jodaFormat, boolean forParsing) {
        if (dateStyles.containsKey(jodaFormat)) {
            return SQLCapability.ok();
        }
        return SQLCapability.nok("Format is not one of SQLServer's styles");
    }

    @Override
    public String getId() {
        return "SQLServer";
    }

    @Override
    public SQLDialect.RegexSupport regexSupport() {
        return SQLDialect.RegexSupport.NONE;
    }

    @Override
    public boolean supportsLookAroundExpressions() {
        return false;
    }

    private QueryUtils.Function hashingOperator(final QueryUtils.OperatorType hashingAlgo, final String functionName) {
        return new QueryUtils.Function(this, hashingAlgo, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "LOWER(CONVERT(VARCHAR(" + SQLServerSQLDialect.this.hashLength(hashingAlgo) + "), HASHBYTES('" + functionName + "', CONVERT(VARCHAR(max), " + column + ")), 2))";
            }
        };
    }

    private int hashLength(QueryUtils.OperatorType hashingAlgo) {
        switch (hashingAlgo) {
            case MD5: {
                return 32;
            }
            case SHA256: {
                return 64;
            }
            case SHA512: {
                return 128;
            }
        }
        throw new IllegalArgumentException("Unknown hashing algorithm " + String.valueOf((Object)hashingAlgo));
    }

    private boolean hasQuestionMarkInIdentifier(String sql) {
        boolean inQuote = false;
        boolean inBracket = false;
        boolean inLiteral = false;
        block7: for (int i = 0; i < sql.length(); ++i) {
            switch (sql.charAt(i)) {
                case '\'': {
                    inLiteral = !inLiteral;
                    continue block7;
                }
                case '\"': {
                    if (inLiteral) continue block7;
                    inQuote = !inQuote;
                    continue block7;
                }
                case '[': {
                    if (inLiteral) continue block7;
                    inBracket = true;
                    continue block7;
                }
                case ']': {
                    if (inLiteral) continue block7;
                    inBracket = false;
                    continue block7;
                }
                case '?': {
                    if (!inQuote && !inBracket) continue block7;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetMetadataOnPreparedStatement(String sql) {
        if (sql.contains("?")) {
            if (sql.contains("/*") || sql.contains("--")) {
                return false;
            }
            return !this.hasQuestionMarkInIdentifier(sql);
        }
        return true;
    }

    @Override
    public boolean supportsTransactionalDdl() {
        return true;
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        return "SELECT schema_name(schema_id), name FROM sys.views WHERE name LIKE 'DSSVIEW@_%' ESCAPE '@'" + this.getSchemaConditionForListingViews(schema, "schema_name(schema_id)", "");
    }

    @Override
    public String getLogClause(double base, String argument) {
        return "LOG(" + argument + ", " + base + ")";
    }

    @Override
    public boolean canCastDSSFormatToTemporal() {
        return true;
    }

    @Override
    public boolean shouldForceFormatForDateComparison() {
        return true;
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return new SQLUtils.MergeIntoUpsertWriter(this, false, false, false, false){

            @Override
            public boolean canUpsertConcurrently() {
                return false;
            }
        };
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return new SQLUtils.UpdateFromJoinUpdateSelectWriter(this);
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableMaterializedTemporaryTableWriter(this, true){

            @Override
            protected String generateCTASTemp(String tempFullName, String targetFullName, String fieldsDef) {
                return String.format("SELECT TOP 0 * INTO %s FROM %s", tempFullName, targetFullName);
            }
        };
    }

    @Override
    public boolean supportGroupByIndex() {
        return false;
    }

    static {
        dateStyles.put("MMMM dd yy KK:mma", "0");
        dateStyles.put("MMMM dd yyyy KK:mma", "100");
        dateStyles.put("MM/dd/yy", "1");
        dateStyles.put("MM/dd/yyyy", "101");
        dateStyles.put("yy.MM.dd", "2");
        dateStyles.put("yyyy.MM.dd", "102");
        dateStyles.put("dd/MM/yy", "3");
        dateStyles.put("dd/MM/yyyy", "103");
        dateStyles.put("dd.MM.yy", "4");
        dateStyles.put("dd.MM.yyyy", "104");
        dateStyles.put("dd-MM-yy", "5");
        dateStyles.put("dd-MM-yyyy", "105");
        dateStyles.put("dd MMM yy", "6");
        dateStyles.put("dd MMM yyyy", "106");
        dateStyles.put("MMM dd, yy", "7");
        dateStyles.put("MMM dd, yyyy", "107");
        dateStyles.put("HH:mm:ss", "8");
        dateStyles.put("MMMM dd yy KK:mm:ss:SSSa", "9");
        dateStyles.put("MMMM dd yyyy KK:mm:ss:SSSa", "109");
        dateStyles.put("MM-dd-yy", "10");
        dateStyles.put("MM-dd-yyyy", "110");
        dateStyles.put("yy/MM/dd", "11");
        dateStyles.put("yyyy/MM/dd", "111");
        dateStyles.put("yyMMdd", "12");
        dateStyles.put("yyyyMMdd", "112");
        dateStyles.put("dd MMM yy HH:mm:ss:SSS", "13");
        dateStyles.put("dd MMM yyyy HH:mm:ss:SSS", "113");
        dateStyles.put("HH:mm:ss:SSS", "14");
        dateStyles.put("yy-MM-dd HH:mm:ss", "20");
        dateStyles.put("yyyy-MM-dd HH:mm:ss", "120");
        dateStyles.put("yy-MM-dd HH:mm:ss.SSS", "21");
        dateStyles.put("yyyy-MM-dd HH:mm:ss.SSS", "121");
        dateStyles.put("yyyy-MM-dd'T'HH:mm:ss.SSS", "126");
        dateStyles.put("yyyy-MM-dd'T'HH:mm:ss.SSSZ", "127");
        dateStyles.put("dd MMMM yyyy KK:mm:ss:SSSa", "130");
        dateStyles.put("dd/MM/yyyy KK:mm:ss:SSSa", "131");
        UNITS = new HashSet<String>();
        UNITS.add("year");
        UNITS.add("quarter");
        UNITS.add("month");
        UNITS.add("dayofyear");
        UNITS.add("week");
        UNITS.add("day");
        UNITS.add("hour");
        UNITS.add("minute");
        UNITS.add("second");
        UNITS.add("millisecond");
        UNITS.add("microsecond");
        UNITS.add("nanosecond");
        logger = Logger.getLogger((String)"dku.sql.sqlserver");
    }
}

