/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractQueryBuilderWithWheres {
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    protected final SQLUtils.SQLTable table;
    private List<ExpressionBuilder> wheres = new ArrayList<ExpressionBuilder>();

    AbstractQueryBuilderWithWheres(SQLUtils.SQLTable table) {
        this.table = table;
    }

    public AbstractQueryBuilderWithWheres withParameterizedEqualWheres(String ... wheres) {
        for (String where : wheres) {
            this.wheres.add(EBF.parameterizedColumnOperation(where, QueryUtils.OperatorType.NULL_UNSAFE_EQ));
        }
        return this;
    }

    public AbstractQueryBuilderWithWheres where(ExpressionBuilder where) {
        this.wheres.add(where);
        return this;
    }

    public String toSql(SQLDialect dialect) {
        this.validateQuery();
        StringBuilder result = new StringBuilder();
        result.append(this.queryStart(dialect));
        result.append(" WHERE ");
        for (int i = 0; i < this.wheres.size(); ++i) {
            if (i > 0) {
                result.append(" AND ");
            }
            ExpressionBuilder where = this.wheres.get(i);
            result.append(where.toSQL(dialect));
        }
        return result.toString();
    }

    protected void validateQuery() {
        Preconditions.checkState((!this.wheres.isEmpty() ? 1 : 0) != 0, (Object)"No columns specified for the where.");
    }

    protected abstract String queryStart(SQLDialect var1);
}

