/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.AbstractQueryBuilder;
import com.dataiku.dip.sql.queries.QueryBuilderUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InsertQueryBuilder
extends AbstractQueryBuilder {
    private static final Function<SchemaColumn, String> TO_PARAMETER = new Function<SchemaColumn, String>(){

        public String apply(SchemaColumn schemaColumn) {
            return "?";
        }
    };
    protected List<SchemaColumn> columns = new ArrayList<SchemaColumn>();
    private SelectQueryBuilder fromQuery = null;

    protected InsertQueryBuilder(SQLUtils.SQLTable table) {
        super(table);
    }

    public static InsertQueryBuilder insertInto(SQLUtils.SQLTable table) {
        return new InsertQueryBuilder(table);
    }

    public InsertQueryBuilder fromQuery(SelectQueryBuilder fromQuery) {
        this.fromQuery = fromQuery;
        return this;
    }

    @Override
    protected void assertBuilderIsValid() {
        super.assertBuilderIsValid();
        Preconditions.checkState((!this.columns.isEmpty() ? 1 : 0) != 0, (Object)"No columns selected for INSERT statement.");
    }

    @Override
    void buildSQLQueries() {
        if (this.dialect instanceof H2SQLDialect) {
            this.queries.add(this.toH2());
        } else if (this.dialect instanceof PostgreSQLDialect) {
            this.queries.add(this.toPostgre());
        } else if (this.dialect instanceof MySQLDialect) {
            this.queries.add(this.toMySQL());
        } else {
            throw new NotImplementedException(String.format("INSERT not yet implemented for %s", this.dialect.getClass().getSimpleName()));
        }
    }

    public InsertQueryBuilder addColumns(String ... columnNames) {
        return this.addColumns((SchemaColumn[])Arrays.stream(columnNames).map(columnName -> new SchemaColumn(columnName, Type.STRING)).toArray(SchemaColumn[]::new));
    }

    public InsertQueryBuilder addColumns(SchemaColumn ... columns) {
        for (SchemaColumn column : columns) {
            this.columns.add(new SchemaColumn(column));
        }
        return this;
    }

    public InsertQueryBuilder addColumns(SchemaColumn[] ... columnsGroups) {
        SchemaColumn[][] schemaColumnArray = columnsGroups;
        int n = schemaColumnArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaColumn[] columnGroup;
            for (SchemaColumn column : columnGroup = schemaColumnArray[i]) {
                this.addColumns(column);
            }
        }
        return this;
    }

    protected String toH2() {
        return this.buildInsertInstruction();
    }

    protected String toPostgre() {
        return this.buildInsertInstruction();
    }

    protected String toMySQL() {
        return this.buildInsertInstruction();
    }

    private String buildInsertInstruction() {
        return this.header("INSERT INTO") + this.parameterizedValue();
    }

    protected String header(String operation) {
        return operation + " " + this.dialect.getQuotedTableFullName(this.table) + " " + this.joinTableColumns();
    }

    protected String parameterizedValue() {
        if (this.fromQuery == null) {
            return " VALUES " + this.buildParameterizedValue();
        }
        return " " + this.fromQuery.toSQL(this.dialect);
    }

    private String buildParameterizedValue() {
        return this.transformAndJoinSchemaColumns(TO_PARAMETER);
    }

    private String joinTableColumns() {
        return this.transformAndJoinSchemaColumns(this.toColumnName());
    }

    private String transformAndJoinSchemaColumns(Function<SchemaColumn, String> transformation) {
        return this.transformAndJoinSchemaColumns(transformation, true);
    }

    protected String transformAndJoinSchemaColumns(Function<SchemaColumn, String> transformation, boolean wrap) {
        String result = FluentIterable.from(this.columns).transform(transformation).join(QueryBuilderUtils.COMMA_JOINER);
        if (wrap) {
            return "(" + result + ")";
        }
        return result;
    }

    private Function<SchemaColumn, String> toColumnName() {
        return new Function<SchemaColumn, String>(){

            public String apply(SchemaColumn schemaColumn) {
                return InsertQueryBuilder.this.dialect.quoteIdentifier(schemaColumn.getName());
            }
        };
    }
}

