/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kafka;

import com.dataiku.dip.streaming.endpoints.kafka.AvroKafkaFormat;
import com.dataiku.dip.streaming.endpoints.kafka.JSONKafkaFormat;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatSerializer;
import com.dataiku.dip.streaming.endpoints.kafka.SingleValueKafkaFormat;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

public class KafkaFormatsFactory {
    public static <T> T getParamsAs(String formatType, JsonObject formatParams, Class<? extends T> clazz) {
        if (StringUtils.isBlank((String)formatType)) {
            return null;
        }
        switch (formatType) {
            case "single": {
                SingleValueKafkaFormat.SingleValueKafkaFormatParams fparams = (SingleValueKafkaFormat.SingleValueKafkaFormatParams)JSON.parse((String)JSON.json((Object)formatParams), SingleValueKafkaFormat.SingleValueKafkaFormatParams.class);
                return clazz.cast(fparams);
            }
            case "json": {
                JSONKafkaFormat.JSONKafkaFormatParams fparams = (JSONKafkaFormat.JSONKafkaFormatParams)JSON.parse((String)JSON.json((Object)formatParams), JSONKafkaFormat.JSONKafkaFormatParams.class);
                return clazz.cast(fparams);
            }
        }
        throw new Error("invalid format");
    }

    public static KafkaFormatDeserializer getDeserializer(String formatType, JsonObject formatParams) {
        if (StringUtils.isBlank((String)formatType)) {
            return null;
        }
        switch (formatType) {
            case "single": {
                SingleValueKafkaFormat.SingleValueKafkaFormatParams fparams = (SingleValueKafkaFormat.SingleValueKafkaFormatParams)JSON.parse((String)JSON.json((Object)formatParams), SingleValueKafkaFormat.SingleValueKafkaFormatParams.class);
                return new SingleValueKafkaFormat.SingleValueKafkaFormatDeserializer(fparams);
            }
            case "json": {
                JSONKafkaFormat.JSONKafkaFormatParams fparams = (JSONKafkaFormat.JSONKafkaFormatParams)JSON.parse((String)JSON.json((Object)formatParams), JSONKafkaFormat.JSONKafkaFormatParams.class);
                return new JSONKafkaFormat.JSONKafkaFormatDeserializer(fparams);
            }
            case "avro": {
                AvroKafkaFormat.AvroKafkaFormatParams fparams = (AvroKafkaFormat.AvroKafkaFormatParams)JSON.parse((String)JSON.json((Object)formatParams), AvroKafkaFormat.AvroKafkaFormatParams.class);
                return new AvroKafkaFormat.AvroKafkaFormatDeserializer(fparams);
            }
        }
        throw new Error("invalid format");
    }

    public static KafkaFormatSerializer getSerializer(String formatType, JsonObject formatParams) {
        if (StringUtils.isBlank((String)formatType)) {
            return null;
        }
        switch (formatType) {
            case "single": {
                SingleValueKafkaFormat.SingleValueKafkaFormatParams fparams = (SingleValueKafkaFormat.SingleValueKafkaFormatParams)JSON.parse((String)JSON.json((Object)formatParams), SingleValueKafkaFormat.SingleValueKafkaFormatParams.class);
                return new SingleValueKafkaFormat.SingleValueKafkaFormatSerializer(fparams);
            }
            case "json": {
                JSONKafkaFormat.JSONKafkaFormatParams fparams = (JSONKafkaFormat.JSONKafkaFormatParams)JSON.parse((String)JSON.json((Object)formatParams), JSONKafkaFormat.JSONKafkaFormatParams.class);
                return new JSONKafkaFormat.JSONKafkaFormatSerializer(fparams);
            }
            case "avro": {
                AvroKafkaFormat.AvroKafkaFormatParams fparams = (AvroKafkaFormat.AvroKafkaFormatParams)JSON.parse((String)JSON.json((Object)formatParams), AvroKafkaFormat.AvroKafkaFormatParams.class);
                return new AvroKafkaFormat.AvroKafkaFormatSerializer(fparams);
            }
        }
        throw new Error("invalid format");
    }
}

