/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kafka;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleWriter;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatSerializer;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatsFactory;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.beans.factory.annotation.Autowired;

public class ToKafkaStreamer
implements StreamingEndpointSimpleWriter {
    private final AuthCtx authCtx;
    private final KafkaStreamingEndpointParams seParams;
    private final StreamingEndpoint streamingEndpoint;
    private final ColumnFactory cf;
    private KafkaFormatSerializer serializer;
    private KafkaFormatSerializer keySerializer;
    private Column timestampColumn;
    private DateTimeFormatter timestampParser = DKUtils.getISODateFormatter();
    private KafkaProducer<Object, Object> producer;
    private KafkaConnection conn;
    private String transactionalId;
    private String transactionCheckpointTopic;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.kafka.writer");

    public ToKafkaStreamer(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, ColumnFactory cf, WarningsContext warningsContext) throws Exception {
        this.authCtx = authCtx;
        this.streamingEndpoint = streamingEndpoint;
        this.cf = cf;
        this.seParams = StreamingEndpointsRegistry.getMeta(streamingEndpoint).getExpandedParams(streamingEndpoint.projectKey, streamingEndpoint, KafkaStreamingEndpointParams.class);
        this.serializer = KafkaFormatsFactory.getSerializer(this.seParams.formatType, this.seParams.formatParams);
        this.keySerializer = KafkaFormatsFactory.getSerializer(this.seParams.keyFormatType, this.seParams.keyFormatParams);
        assert (this.serializer != null);
        SpringUtils.getInstance().autowire((Object)this);
    }

    public ToKafkaStreamer withTransactional(String transactionalId, String checkpointTopic) {
        this.transactionalId = transactionalId;
        this.transactionCheckpointTopic = checkpointTopic;
        return this;
    }

    @Override
    public void init() throws Exception {
        if (this.seParams.producerParams.provideTimestamp && StringUtils.isNotBlank((String)this.seParams.timestampColumn)) {
            this.timestampColumn = this.cf.column(this.seParams.timestampColumn);
        }
        this.serializer.init(this.cf, this.streamingEndpoint.schema);
        this.keySerializer.init(this.cf, this.streamingEndpoint.schema);
        this.conn = (KafkaConnection)this.connectionsDAO.getConnection(this.authCtx, this.seParams.connection);
        Properties props = this.conn.buildBasicProperties(this.authCtx, this.streamingEndpoint.projectKey);
        String keyKafkaSerializer = this.keySerializer.getKafkaSerializer();
        String valueKafkaSerializer = this.serializer.getKafkaSerializer();
        if (StringUtils.isNotBlank((String)this.transactionalId)) {
            logger.info((Object)("Setup Kafka producer as transactional with id : " + this.transactionalId));
            props.put("enable.idempotence", (Object)true);
            props.put("transactional.id", this.transactionalId);
            props.put("key.serializer", "com.dataiku.dip.streaming.endpoints.kafka.CompositeSerializer");
            props.put("value.serializer", "com.dataiku.dip.streaming.endpoints.kafka.CompositeSerializer");
            props.put("dku.key.serializer", keyKafkaSerializer);
            props.put("dku.value.serializer", valueKafkaSerializer);
            props.put("dku." + this.transactionCheckpointTopic + ".key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            props.put("dku." + this.transactionCheckpointTopic + ".value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        } else {
            props.put("key.serializer", keyKafkaSerializer);
            props.put("value.serializer", valueKafkaSerializer);
        }
        this.producer = new KafkaProducer(props);
        if (StringUtils.isNotBlank((String)this.transactionalId)) {
            this.producer.initTransactions();
            this.producer.beginTransaction();
        }
    }

    public void addToCurrentTransaction(String key, String value) {
        this.producer.send(new ProducerRecord(this.transactionCheckpointTopic, (Object)key, (Object)value));
    }

    public void commitAndRenewTransaction() {
        this.producer.commitTransaction();
        this.producer.beginTransaction();
    }

    public void processRow(Row row) throws Exception {
        String timestampStr;
        Object key = this.keySerializer.serialize(row);
        Object value = this.serializer.serialize(row);
        if (logger.isTraceEnabled()) {
            logger.infoV("Serializing record topic=%s data=%s k=%s v=%s", new Object[]{this.seParams.topic, row, key, value});
        }
        Long timestamp = null;
        if (this.timestampColumn != null && StringUtils.isNotBlank((String)(timestampStr = row.get(this.timestampColumn)))) {
            timestamp = this.timestampParser.parseMillis(timestampStr);
        }
        ProducerRecord record = new ProducerRecord(this.seParams.topic, null, timestamp, key, value);
        this.producer.send(record);
    }

    public void postProcess() throws Exception {
        if (this.producer != null) {
            if (StringUtils.isNotBlank((String)this.transactionalId)) {
                logger.info((Object)"Commit final transaction");
                this.producer.commitTransaction();
            }
            this.producer.close();
            this.producer = null;
        }
    }

    @Override
    public void setFactories(ColumnFactory cf, RowFactory rf) {
    }

    public void cancel() throws Exception {
        if (this.producer != null) {
            if (StringUtils.isNotBlank((String)this.transactionalId)) {
                logger.info((Object)"Abort final transaction");
                this.producer.abortTransaction();
            }
            this.producer.close();
            this.producer = null;
        }
    }
}

