/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.model;

import com.dataiku.dip.coremodel.Checklists;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum StreamingEndpointDeserializer implements JsonDeserializer<StreamingEndpoint>
{
    INSTANCE;

    private static final Map<String, Class<? extends StreamingEndpoint.StreamingEndpointParams>> paramsMap;

    public static void registerType(String type, Class<? extends StreamingEndpoint.StreamingEndpointParams> paramsClass) {
        paramsMap.put(type, paramsClass);
    }

    public StreamingEndpoint deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Class<? extends StreamingEndpoint.StreamingEndpointParams> paramsClass;
        StreamingEndpoint ret = new StreamingEndpoint();
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.has("projectKey")) {
            ret.projectKey = jsonObj.get("projectKey").getAsString();
        }
        if (jsonObj.has("id") && !jsonObj.get("id").isJsonNull()) {
            ret.id = jsonObj.get("id").getAsString();
        }
        ret.type = jsonObj.get("type").getAsString();
        if (jsonObj.has("schema")) {
            ret.schema = (Schema)jsonDeserializationContext.deserialize(jsonObj.get("schema"), Schema.class);
        }
        if (jsonObj.has("tags")) {
            ret.tags = (List)jsonDeserializationContext.deserialize(jsonObj.get("tags"), List.class);
        }
        if (jsonObj.has("checklists")) {
            ret.checklists = (Checklists)jsonDeserializationContext.deserialize(jsonObj.get("checklists"), Checklists.class);
        }
        if (jsonObj.has("description")) {
            ret.description = jsonObj.get("description").getAsString();
        }
        if (jsonObj.has("shortDesc")) {
            ret.shortDesc = jsonObj.get("shortDesc").getAsString();
        }
        if (jsonObj.has("versionTag")) {
            ret.versionTag = (VersionTag)jsonDeserializationContext.deserialize(jsonObj.get("versionTag"), VersionTag.class);
        }
        if (jsonObj.has("creationTag")) {
            ret.creationTag = (VersionTag)jsonDeserializationContext.deserialize(jsonObj.get("creationTag"), VersionTag.class);
        }
        if (jsonObj.has("customFields")) {
            ret.customFields = jsonObj.getAsJsonObject("customFields");
        }
        if ((paramsClass = paramsMap.get(ret.type)) == null) {
            throw new JsonParseException("SE type " + ret.type + " is unknown");
        }
        JsonElement paramJson = jsonObj.get("params");
        if (paramJson != null) {
            ret.params = (StreamingEndpoint.StreamingEndpointParams)jsonDeserializationContext.deserialize(paramJson, paramsClass);
        }
        return ret;
    }

    static {
        JSON.registerAdapter(StreamingEndpoint.class, (Object)((Object)INSTANCE));
        paramsMap = Collections.synchronizedMap(new HashMap());
    }
}

