/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.externalendpoint;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.savedmodels.externalmodelidentifier.ExternalEndpointIdentifier;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringStatus;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.AbstractMonitoredApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScope;
import com.dataiku.dip.unifiedmonitoring.settings.SourceNodeWithLocalInfo;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class MonitoredExternalApiEndpoint
extends AbstractMonitoredApiEndpoint {
    public static final String ENDPOINT_TYPE = "EXTERNAL_API_ENDPOINT";
    @Nullable
    public String resourceLink;
    @Nonnull
    public List<SavedModelVersionOfProxyModel> proxifiedSavedModelVersions = new ArrayList<SavedModelVersionOfProxyModel>();
    public int nbProxifiedSavedModelVersions;
    @Nonnull
    public ExternalEndpointIdentifier externalEndpointIdentifier;
    @Nonnull
    public UnifiedMonitoringExternalEndpointsScope externalEndpointsScope;
    public boolean isNotFound;

    public MonitoredExternalApiEndpoint(String endpointName, String resourceLink, DeploymentHealth deploymentHealth, InfoMessage.InfoMessages deploymentHealthMessages, ExternalEndpointIdentifier externalEndpointIdentifier, UnifiedMonitoringExternalEndpointsScope externalEndpointsScope) {
        this.deploymentId = endpointName;
        this.endpointName = endpointName;
        this.displayedName = endpointName;
        this.resourceLink = resourceLink;
        this.deploymentHealth = deploymentHealth;
        this.deploymentHealthMessages = deploymentHealthMessages;
        this.externalEndpointIdentifier = externalEndpointIdentifier;
        this.stage = externalEndpointsScope.stage;
        this.externalEndpointsScope = externalEndpointsScope;
    }

    public MonitoredExternalApiEndpoint() {
    }

    public static MonitoredExternalApiEndpoint readMonitoredExternalApiEndpoint(File monitoredEndpointFile) throws IOException {
        String endpointName = monitoredEndpointFile.getName().replaceAll(".json$", "");
        MonitoredExternalApiEndpoint ret = (MonitoredExternalApiEndpoint)JSON.parseFile((File)monitoredEndpointFile, MonitoredExternalApiEndpoint.class);
        ret.endpointName = endpointName;
        return ret;
    }

    public void resetMonitoringAttributes() {
        this.nbProxifiedSavedModelVersions = 0;
        this.proxifiedSavedModelVersions = new ArrayList<SavedModelVersionOfProxyModel>();
        this.modelStatus = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitoredExternalApiEndpoint that = (MonitoredExternalApiEndpoint)o;
        return Objects.equals(this.externalEndpointIdentifier, that.externalEndpointIdentifier) && Objects.equals(this.externalEndpointsScope, that.externalEndpointsScope);
    }

    public int hashCode() {
        return Objects.hash(this.externalEndpointIdentifier, this.externalEndpointsScope);
    }

    @Override
    public void computeUMStatuses() {
        this.umDeploymentStatus = UnifiedMonitoringStatus.map(this.deploymentHealth);
        this.umModelStatus = UnifiedMonitoringStatus.map(this.modelStatus);
        if (this.modelStatus == null && this.modelStatusMessages.anyMessage && this.modelStatusMessages.maxSeverity != null) {
            this.umModelStatus = UnifiedMonitoringStatus.worstStatus(this.umModelStatus, UnifiedMonitoringStatus.map(this.modelStatusMessages.maxSeverity));
        }
        this.umGlobalStatus = UnifiedMonitoringStatus.worstStatus(this.umDeploymentStatus, this.umModelStatus);
    }

    public static class SavedModelVersionOfProxyModel {
        @Nonnull
        public FullModelId smvId;
        @Nonnull
        public SourceNodeWithLocalInfo designNodeInfo;

        public SavedModelVersionOfProxyModel(@Nonnull FullModelId smvId, @Nonnull SourceNodeWithLocalInfo designNodeInfo) {
            this.smvId = smvId;
            this.designNodeInfo = designNodeInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SavedModelVersionOfProxyModel that = (SavedModelVersionOfProxyModel)o;
            return Objects.equals(this.smvId, that.smvId) && Objects.equals(this.designNodeInfo, that.designNodeInfo);
        }

        public int hashCode() {
            return Objects.hash(this.smvId, this.designNodeInfo);
        }
    }
}

