/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.shaker.text.StringNormalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SafeColumnNamer {
    private List<String> originalColumnNames = new ArrayList<String>();
    public String invalidName = "null";
    private static final Pattern validNamePattern = Pattern.compile("^[a-zA-Z][A-Za-z0-9_]*$");

    public void addUnsafe(String str) {
        this.originalColumnNames.add(str);
    }

    private static boolean isValid(String name) {
        if (StringUtils.isBlank((String)name)) {
            return false;
        }
        return validNamePattern.matcher(name).find();
    }

    public List<String> getSafeNames() {
        String unsafeName;
        int i;
        ArrayList<String> safeNames = new ArrayList<String>();
        CaseInsensitiveTransmogrifier transmogrifier = new CaseInsensitiveTransmogrifier();
        for (i = 0; i < this.originalColumnNames.size(); ++i) {
            unsafeName = this.originalColumnNames.get(i);
            if (SafeColumnNamer.isValid(unsafeName)) {
                safeNames.add(transmogrifier.transmogrify(unsafeName));
                continue;
            }
            safeNames.add(null);
        }
        if (!transmogrifier.contains(this.invalidName)) {
            transmogrifier.transmogrify(this.invalidName);
        }
        for (i = 0; i < safeNames.size(); ++i) {
            char firstChar;
            if (safeNames.get(i) != null) continue;
            unsafeName = this.originalColumnNames.get(i);
            if (unsafeName == null) {
                unsafeName = this.invalidName;
            }
            unsafeName = StringNormalizer.normalize((String)unsafeName);
            unsafeName = unsafeName.trim();
            unsafeName = unsafeName.replaceAll("[^A-Za-z0-9_]", "_");
            while (!(unsafeName.length() <= 0 || (firstChar = unsafeName.charAt(0)) >= 'a' && firstChar <= 'z' || firstChar >= 'A' && firstChar <= 'Z')) {
                unsafeName = unsafeName.substring(1);
            }
            if (unsafeName.isEmpty()) {
                unsafeName = this.invalidName;
            }
            assert (SafeColumnNamer.isValid(unsafeName));
            safeNames.set(i, transmogrifier.transmogrify(unsafeName));
        }
        return safeNames;
    }

    private static class CaseInsensitiveTransmogrifier {
        private Set<String> assigned = new HashSet<String>();
        private String delimiter = "_";

        private CaseInsensitiveTransmogrifier() {
        }

        public String transmogrify(String input) {
            Object cur = input;
            int i = 0;
            while (this.assigned.contains(((String)cur).toLowerCase())) {
                cur = input + this.delimiter + ++i;
            }
            this.assigned.add(((String)cur).toLowerCase());
            return cur;
        }

        public boolean contains(String str) {
            return this.assigned.contains(str);
        }
    }
}

