/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PrettyString;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpRequestFactory;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpRequestInitializer;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpResponse;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.apache.ApacheHttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GoogleCloudUtils {
    private static final String NEW_LINE = PrettyString.eol();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.utils.googlecloud");

    public static GoogleCredential setupCredentialsForProxy(GoogleCredential credentials, HttpTransport httpTransport) {
        try {
            credentials = credentials.toBuilder().setTransport(httpTransport).setTokenServerEncodedUrl(credentials.getTokenServerEncodedUrl()).setRequestInitializer(credentials.getRequestInitializer()).build().setAccessToken(credentials.getAccessToken()).setRefreshToken(credentials.getRefreshToken());
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to set transport on credentials, proxying might fail", (Throwable)e);
        }
        return credentials;
    }

    public static HttpRequestFactory buildRequestFactory(final ProxySettings proxySettings, GoogleCredential credentials, boolean useApache) throws GeneralSecurityException, IOException {
        NetHttpTransport httpTransport;
        boolean hasProxy = proxySettings.hasProxy();
        logger.trace(() -> "Setup httpTransport hasProxy=" + hasProxy + " useApache=" + useApache);
        if (useApache) {
            ApacheHttpTransport.Builder builder = new ApacheHttpTransport.Builder();
            if (hasProxy) {
                builder.setProxySelector(new ProxySelector(){

                    @Override
                    public List<Proxy> select(URI uri) {
                        return Lists.newArrayList((Object[])new Proxy[]{proxySettings.getProxy()});
                    }

                    @Override
                    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                    }
                });
            }
            httpTransport = builder.build();
        } else {
            httpTransport = ProxyUtils.getNetHttpTransport((ProxySettings)proxySettings);
        }
        if (hasProxy) {
            credentials = GoogleCloudUtils.setupCredentialsForProxy(credentials, (HttpTransport)httpTransport);
        }
        return httpTransport.createRequestFactory((HttpRequestInitializer)credentials);
    }

    public static String extractMessage(GoogleCloudErrorResponse response) {
        GoogleCloudError error;
        GoogleCloudError googleCloudError = error = response == null ? null : response.error;
        if (error != null) {
            if (StringUtils.isNotBlank((String)error.message)) {
                return error.message;
            }
            if (error.errors != null) {
                for (GoogleCloudSubError subError : error.errors) {
                    if (subError == null) continue;
                    if (StringUtils.isNotBlank((String)subError.message)) {
                        return subError.message;
                    }
                    if (!StringUtils.isNotBlank((String)subError.reason)) continue;
                    return subError.reason;
                }
            }
        }
        return "Unknown error";
    }

    public static String extractErrorMessage(HttpResponse response, String responseBody) {
        String statusMessage;
        StringBuilder builder = new StringBuilder();
        int statusCode = response.getStatusCode();
        if (statusCode != 0) {
            builder.append(statusCode);
        }
        if ((statusMessage = response.getStatusMessage()) != null) {
            if (statusCode != 0) {
                builder.append(' ');
            }
            builder.append(statusMessage);
        }
        if (StringUtils.isNotBlank((String)responseBody)) {
            builder.append(NEW_LINE).append(responseBody);
        }
        return builder.toString();
    }

    private GoogleCloudUtils() {
    }

    public static class GoogleCloudErrorResponse {
        public GoogleCloudError error;
    }

    public static class GoogleCloudError {
        public int code;
        public String message;
        public List<GoogleCloudSubError> errors = new ArrayList<GoogleCloudSubError>();
        public String status;
    }

    public static class GoogleCloudSubError {
        public String domain;
        public String reason;
        public String message;
    }
}

