/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.shiny.backend;

import com.dataiku.dip.autorestart.AutoRestartingProcessRunner;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IImpersonatedKernel;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.AbstractWebAppLocalProcessKernel;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.dataiku.dip.webapps.shiny.ShinyWebAppMeta;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class ShinyWebAppLocalKernel
extends AbstractWebAppLocalProcessKernel
implements IImpersonatedKernel {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ImpersonationResolverService impersonationResolverService;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.shiny");

    public ShinyWebAppLocalKernel(WebApp webApp, AuthCtx authCtx, JsonObject userVariables, WebAppLaunchInfo launchInfo, WebAppSecurityInfo securityInfo, File workingDir, APITicketService.Ticket ticket, DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        super(webApp, authCtx, workingDir, mainLog, smartLogTailBuilder, userVariables, launchInfo, securityInfo, ticket);
        SpringUtils.getInstance().autowire((Object)this);
    }

    private void writeTempFiles() throws IOException, AutoRestartingProcessRunner.BackendStartFailedException {
        ShinyWebAppMeta.ShinyWebAppParams params = this.webApp.getParamsAs(ShinyWebAppMeta.ShinyWebAppParams.class);
        if (StringUtils.isBlank((String)params.ui)) {
            throw new AutoRestartingProcessRunner.BackendStartFailedException("Empty ui.R script", null, null);
        }
        if (StringUtils.isBlank((String)params.server)) {
            throw new AutoRestartingProcessRunner.BackendStartFailedException("Empty server.R script", null, null);
        }
        Map variables = this.variablesService.getForProject(this.webApp.projectKey).getAllVariables();
        String ui = StrSubstitutor.replace((Object)params.ui, (Map)variables);
        File uiFile = new File(this.workingDir, "ui.R");
        FileUtils.write((File)uiFile, (CharSequence)ui, (String)"utf8");
        String server = StrSubstitutor.replace((Object)params.server, (Map)variables);
        File serverFile = new File(this.workingDir, "server.R");
        FileUtils.write((File)serverFile, (CharSequence)server, (String)"utf8");
    }

    private List<String> getRunCmd(File tmpFolder) throws IOException {
        ArrayList args = Lists.newArrayList();
        args.add("-e");
        args.add("shiny::runApp('" + tmpFolder.getAbsolutePath().replace("\\", "/") + "')");
        return ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getRCmd(this.launchInfo.envName, this.webApp.projectKey, args);
    }

    @Override
    public WebAppBackendKernel.MainKernelProcess prepareRun(WebAppBackendInstance webAppBackendInstance, ExposedEndpointConsumer.ExposedEndpoint expectedExposedEndpoint) throws Exception {
        List<String> cmd;
        this.writeTempFiles();
        try {
            cmd = this.getRunCmd(this.workingDir);
        }
        catch (IOException e) {
            throw new AutoRestartingProcessRunner.BackendStartFailedException("Failed to build Shiny server command", e, null);
        }
        logger.info((Object)("Start Shiny with [\"" + Joiner.on((String)"\", \"").join(cmd) + "\"]"));
        ProcessBuilder builder = this.getProcessBuilder(cmd, false, null, this.impersonationResolverService);
        return new WebAppBackendKernel.LocalMainKernelProcess(builder, this.outputConsumer, this.workingDir, this.securityInfo);
    }

    @Override
    protected String getLogPrefix() {
        return "[local] ";
    }

    @Override
    protected boolean impersonate() {
        return true;
    }
}

