/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.streamlit;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.DkuComponentMetadataWithCategory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.dataiku.dip.webapps.plugins.WebAppDesc;
import com.dataiku.dip.webapps.streamlit.CustomStreamlitWebAppHandler;
import com.dataiku.dip.webapps.streamlit.StreamlitWebAppHandler;
import com.dataiku.dip.webapps.streamlit.backend.StreamlitWebAppBackendRunner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StreamlitWebAppMeta
implements WebAppMeta,
MetaWithSelectableCodeEnv {
    public static final String TYPE = "STREAMLIT";
    public static final String LIVENESS_CHECK_PATH = "/__ping";
    private static final WebAppDesc desc = StreamlitWebAppMeta.makeDesc();
    public static final StreamlitWebAppMeta META = new StreamlitWebAppMeta();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.streamlit");

    @Override
    public Class<? extends WebApp.WebAppParams> getParamsClass() {
        return StreamlitWebAppParams.class;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isCustomWebApp() {
        return false;
    }

    @Override
    public WebAppBackendRunner buildRunner(WebApp webApp, WebAppBackend webAppBackend, JsonObject variables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        return new StreamlitWebAppBackendRunner(webApp, webAppBackend, variables, user, webAppBackendInstance);
    }

    @Override
    public WebAppHandler buildHandler(WebApp webapp) {
        return new StreamlitWebAppHandler(webapp);
    }

    @Override
    public WebAppHandler buildCustomHandler(WebApp webApp, File webappFolder) {
        return new CustomStreamlitWebAppHandler(webApp, webappFolder);
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.PYTHON;
    }

    private static WebAppDesc makeDesc() {
        String shortDesc = "Use <a target=\"_blank\" rel=\"noopener noreferrer\" href=\"https://streamlit.io/\">Streamlit</a> to generate interactive visualizations using Python";
        DkuComponentMetadataWithCategory data = new DkuComponentMetadataWithCategory("Streamlit", shortDesc, "dku-icon-streamlit-48", null);
        return new WebAppDesc(TYPE, data);
    }

    @Override
    public WebAppDesc getWebAppDesc() {
        return desc;
    }

    @Override
    public List<Object> getHashElements(WebApp webApp) {
        StreamlitWebAppParams params = webApp.getParamsAs(StreamlitWebAppParams.class);
        return params.getHashElements();
    }

    private StreamlitWebAppMeta() {
    }

    public static class StreamlitWebAppParams
    extends WebApp.WebAppParams
    implements ParamsWithSelectableCodeEnv {
        @JSON.FileTransient
        public String python;
        @JSON.FileTransient
        public String config;
        public boolean autoStartBackend;
        public CodeEnvSelection envSelection = new CodeEnvSelection();

        @Override
        public boolean isBackendEnabled() {
            return true;
        }

        @Override
        public boolean isAutoStartBackend() {
            return this.autoStartBackend;
        }

        @Override
        public JsonObject getSensitiveSettings(AuthCtx authCtx) throws IOException, DKUSecurityException {
            Preconditions.checkNotNull((Object)this.python);
            JsonObject ret = super.getSensitiveSettings(authCtx);
            ret.addProperty("type", StreamlitWebAppMeta.TYPE);
            ret.addProperty("python", this.python);
            ret.addProperty("config", this.config);
            return ret;
        }

        @Override
        public boolean isLoadingPythonLibraries() {
            return true;
        }

        @Override
        public boolean isLoadingRLibraries() {
            return false;
        }

        @Override
        public List<Object> getHashElements() {
            return Lists.newArrayList((Object[])new Object[]{this.forceAuthentication, this.python, this.config, this.envSelection});
        }

        @Override
        public void setCodeForFile(String code, String filename, String filenameExtension) {
            if ("toml".equals(filenameExtension)) {
                this.config = code;
            } else if ("py".equals(filenameExtension)) {
                this.python = code;
            } else {
                logger.warn((Object)("Streamlit app does not contain a file name with extension " + filenameExtension));
            }
        }

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.WEBAPP, object.getProjectKey(), object.getId()));
            }
            return usages;
        }
    }
}

