/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.LocalTime;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class AsDatetimeTz
implements Function {
    DKUFormulaUtils formulaUtils = new DKUFormulaUtils();

    private DateTime parseDate(String date, String format) {
        try {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format).withZone(DateTimeZone.UTC);
            return formatter.parseDateTime(date);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Object call(Properties bindings, Object[] args) {
        String strDate;
        if (args.length == 0 || args[0] == null) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " requires at least an argument");
        }
        if (args[0] instanceof Date || args[0] instanceof DateTime) {
            return args[0];
        }
        if (args[0] instanceof LocalDate) {
            return ((LocalDate)args[0]).toDateTime(LocalTime.MIDNIGHT, DateTimeZone.UTC);
        }
        if (args[0] instanceof LocalDateTime) {
            return ((LocalDateTime)args[0]).toDateTime(DateTimeZone.UTC);
        }
        if (args[0] instanceof Calendar) {
            return ((Calendar)args[0]).getTime();
        }
        if (args[0] instanceof Long) {
            strDate = ((Long)args[0]).toString();
        } else if (args[0] instanceof String) {
            strDate = (String)args[0];
            if (strDate.isEmpty()) {
                return new EvalError("Empty string (in " + GrelControlFunctionRegistry.getInstance().getFunctionName(this) + ")");
            }
        } else {
            return new EvalError("Not a String - cannot parse to date");
        }
        if (args.length >= 2) {
            for (int i = 1; i < args.length; ++i) {
                DateTime date;
                if (!(args[i] instanceof String) || (date = this.parseDate(strDate, (String)args[i])) == null) continue;
                return date;
            }
        } else {
            DateTime date = this.formulaUtils.asDate(strDate, bindings);
            if (date != null) {
                return date;
            }
        }
        return new EvalError("Unable to parse as datetime with zone: " + String.valueOf(args[0]));
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.AsDatetimeTz.DOCUMENTATION", "Returns <code>o</code> converted to <code>datetime with tz</code>. If you don't give a format, ISO-8601 is used. You can give an ordered list of possible formats using this syntax: <a href=\"https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html\" target=\"dss_formula\">DateTimeFormat</a>. The <code>format</code> arguments are ignored when using the SQL engine.").withParams("o, [format1 ...]").withReturns("datetime with tz").withCategory("GREL.FUNCTIONS.CATEGORY.DATE", "Date functions").withExample(Example.with("\"2020-04-15\"", "\"yyyy-MM-dd\"").returns("2020-04-15T00:00:00.000Z"));
    }
}

