/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.arrays;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class ArrayDedup
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1) {
            Object v = args[0];
            List<?> list = DKUFormulaUtils.asList(v);
            HashSet set = new HashSet(list.size());
            set.addAll(list);
            return set.toArray();
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects an array");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ArrayDedup.DOCUMENTATION", "Returns array <code>a</code> with duplicates removed.").withParams("array a").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.ARRAY", "Array functions").withExample(Example.with("[0, 1, 0, 7]", "2").returns("[0, 1, 7]"));
    }
}

