/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.date;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Calendar;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class DatePart
implements Function {
    public static final String[] DAYS_OF_WEEK = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private final Locale locale;
    private final DKUFormulaUtils formulaUtils = new DKUFormulaUtils();

    public DatePart() {
        this(null);
    }

    public DatePart(Locale locale) {
        this.locale = locale;
    }

    public Object execute(DateTime date, String part) {
        return this.execute(date, part, null);
    }

    public Object execute(Object date, String part, String timezone) {
        Calendar c2 = this.locale == null ? Calendar.getInstance() : Calendar.getInstance(this.locale);
        DateTimeZone dtz = !StringUtils.isBlank((String)timezone) ? DateTimeZone.forID((String)timezone) : DateTimeZone.UTC;
        if (date instanceof DateTime) {
            c2.setTime(((DateTime)date).toDate());
        } else if (date instanceof LocalDate) {
            DateTime dt = ((LocalDate)date).toDateTimeAtStartOfDay(dtz);
            c2.setTime(dt.toDate());
        } else if (date instanceof LocalDateTime) {
            DateTime dt = ((LocalDateTime)date).toDateTime(dtz);
            c2.setTime(dt.toDate());
        } else {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a date for first argument");
        }
        c2.setTimeZone(dtz.toTimeZone());
        return this.getPart(c2, part);
    }

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length < 2 || args.length > 3) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects 2 or 3 arguments: a date, a string (part) and an optional string (time zone)");
        }
        if (args[0] == null || !DKUFormulaUtils.isNotABlankString(args[0]) || !(args[1] instanceof String)) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a date and a string");
        }
        if (args.length == 3 && args[2] != null && !(args[2] instanceof String)) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a string representing a timezone as optional third argument");
        }
        String part = (String)args[1];
        Object date = this.formulaUtils.asTemporal(args[0], bindings);
        String timezone = args.length == 3 ? (String)args[2] : null;
        try {
            return this.execute(date, part, timezone);
        }
        catch (IllegalArgumentException e) {
            return new EvalError(e.getMessage());
        }
    }

    private Object getPart(Calendar c2, String part) {
        DateUnit unit = DatePart.parseUnit(part);
        switch (unit) {
            case HOUR_OF_DAY: {
                return c2.get(11);
            }
            case MINUTE_OF_HOUR: {
                return c2.get(12);
            }
            case SECOND_OF_MINUTE: {
                return c2.get(13);
            }
            case YEAR: {
                return c2.get(1);
            }
            case MONTH_OF_YEAR: {
                return c2.get(2) + 1;
            }
            case QUARTER_OF_YEAR: {
                return c2.get(2) / 3 + 1;
            }
            case DAY_OF_MONTH: {
                return c2.get(5);
            }
            case WEEK_DAY: {
                return DAYS_OF_WEEK[(c2.get(7) + 5) % 7];
            }
            case DAY_OF_WEEK: {
                return 1 + (c2.get(7) + 5) % 7;
            }
            case WEEK_OF_MONTH: {
                return c2.get(4);
            }
            case WEEK_OF_YEAR: {
                return c2.get(3);
            }
            case WEEK_OF_MONTH_ISO: {
                return DatePart.withIsoWeeksDefinition(c2).get(4);
            }
            case WEEK_OF_YEAR_ISO: {
                return DatePart.withIsoWeeksDefinition(c2).get(3);
            }
            case WEEK_YEAR_ISO: {
                return DatePart.withIsoWeeksDefinition(c2).getWeekYear();
            }
            case TIME: {
                return c2.getTimeInMillis();
            }
            case UNIX_TIME: {
                return c2.getTimeInMillis() / 1000L;
            }
            case MILLISECOND_OF_SECOND: {
                return c2.get(14);
            }
        }
        throw new IllegalArgumentException("Date unit '" + String.valueOf((Object)unit) + "' not handled.");
    }

    public static DateUnit parseUnit(String part) {
        switch (part.toLowerCase(Locale.ROOT)) {
            case "hours": 
            case "hour": 
            case "h": {
                return DateUnit.HOUR_OF_DAY;
            }
            case "minutes": 
            case "minute": 
            case "min": {
                return DateUnit.MINUTE_OF_HOUR;
            }
            case "seconds": 
            case "second": 
            case "sec": 
            case "s": {
                return DateUnit.SECOND_OF_MINUTE;
            }
            case "years": 
            case "year": {
                return DateUnit.YEAR;
            }
            case "months": 
            case "month": {
                return DateUnit.MONTH_OF_YEAR;
            }
            case "days": 
            case "day": 
            case "d": {
                return DateUnit.DAY_OF_MONTH;
            }
            case "weekday": {
                return DateUnit.WEEK_DAY;
            }
            case "dayofweek": {
                return DateUnit.DAY_OF_WEEK;
            }
            case "weeks": 
            case "weekofmonth": 
            case "week": 
            case "w": {
                return DateUnit.WEEK_OF_MONTH;
            }
            case "weekofyear": {
                return DateUnit.WEEK_OF_YEAR;
            }
            case "isoweeks": 
            case "isoweekofmonth": 
            case "isoweek": {
                return DateUnit.WEEK_OF_MONTH_ISO;
            }
            case "isoweekofyear": {
                return DateUnit.WEEK_OF_YEAR_ISO;
            }
            case "isoweekyear": {
                return DateUnit.WEEK_YEAR_ISO;
            }
            case "time": {
                return DateUnit.TIME;
            }
            case "unixtime": {
                return DateUnit.UNIX_TIME;
            }
            case "milliseconds": 
            case "millisecond": 
            case "ms": {
                return DateUnit.MILLISECOND_OF_SECOND;
            }
            case "quarters": 
            case "quarter": 
            case "q": {
                return DateUnit.QUARTER_OF_YEAR;
            }
        }
        throw new IllegalArgumentException("Date unit '" + part + "' not recognized.");
    }

    private static Calendar withIsoWeeksDefinition(Calendar c2) {
        c2.setFirstDayOfWeek(2);
        c2.setMinimalDaysInFirstWeek(4);
        return c2;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.DatePart.DOCUMENTATION", "Returns part of a date. The available parts are: hours, minutes, seconds, milliseconds, years, months, days, weeks, dayOfWeek, weekDay, weekOfYear, isoWeekOfYear, isoWeekYear, time, unixTime.").withParams("date d, string part, [string timezone]").withReturns("number or string").withCategory("GREL.FUNCTIONS.CATEGORY.DATE", "Date functions").withExample(Example.with("\"2020-04-15T00:00:00.000Z\"", "\"weekDay\"").returns("\"Wednesday\"")).withExample(Example.with("\"2020-01-01T00:00:00.000Z\"", "\"year\"", "\"-08:00\"").returns("2019"));
    }

    public static enum DateUnit {
        YEAR,
        QUARTER_OF_YEAR,
        MONTH_OF_YEAR,
        DAY_OF_MONTH,
        HOUR_OF_DAY,
        MINUTE_OF_HOUR,
        SECOND_OF_MINUTE,
        MILLISECOND_OF_SECOND,
        WEEK_DAY,
        DAY_OF_WEEK,
        WEEK_OF_MONTH,
        WEEK_OF_YEAR,
        WEEK_OF_MONTH_ISO,
        WEEK_OF_YEAR_ISO,
        WEEK_YEAR_ISO,
        TIME,
        UNIX_TIME;

    }
}

