/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;

public class SHA1
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1 && args[0] != null) {
            Object o = args[0];
            String s = o instanceof String ? (String)o : o.toString();
            return DigestUtils.shaHex((String)s);
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a string");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.SHA1.DOCUMENTATION", "Returns the SHA-1 hash of a string.").withParams("string s").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"goo\"").returns("\"3f95edc0399d06d4b84e7811dd79272c69c8ed3a\""));
    }
}

