/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import com.dataiku.dip.input.formats.hive.serde.DSSInspectionException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DSSArrayObjectInspector
extends StandardListObjectInspector
implements DSSBaseInspector {
    private DSSBaseInspector parent;

    public DSSArrayObjectInspector(ObjectInspector listElementObjectInspector) {
        super(listElementObjectInspector);
    }

    private JSONArray get(Object o) {
        if (o != null && !JSONObject.NULL.equals(o)) {
            if (o instanceof JSONArray) {
                return (JSONArray)o;
            }
            throw new DSSInspectionException((DSSBaseInspector)this, "JSONArray expected: " + String.valueOf(o));
        }
        return null;
    }

    public int getListLength(Object data) {
        JSONArray arr = this.get(data);
        if (arr != null) {
            return arr.length();
        }
        return -1;
    }

    public Object getListElement(Object data, int index) {
        JSONArray arr = this.get(data);
        if (arr != null) {
            try {
                Object o = arr.get(index);
                if (JSONObject.NULL.equals(o)) {
                    o = null;
                }
                return o;
            }
            catch (JSONException e) {
                throw new DSSInspectionException((DSSBaseInspector)this, (Throwable)e);
            }
        }
        return null;
    }

    public List<?> getList(Object data) {
        JSONArray arr = this.get(data);
        if (arr != null) {
            ArrayList<Object> out = new ArrayList<Object>(arr.length());
            for (int i = 0; i < arr.length(); ++i) {
                out.add(this.getListElement(arr, i));
            }
            return out;
        }
        return null;
    }

    @Override
    public DSSBaseInspector getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DSSBaseInspector parent) {
        this.parent = parent;
    }
}

