/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.auth;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.AWSCredentials;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.AWSCredentialsProvider;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.BasicAWSCredentials;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.BasicSessionCredentials;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class SystemPropertiesCredentialsProvider
implements AWSCredentialsProvider {
    private static final String PROVIDER_NAME = "SystemPropertyCredentialsProvider";

    @Override
    public AWSCredentials getCredentials() {
        String accessKey = StringUtils.trim(System.getProperty("aws.accessKeyId"));
        String secretKey = StringUtils.trim(System.getProperty("aws.secretKey"));
        String sessionToken = StringUtils.trim(System.getProperty("aws.sessionToken"));
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            throw new SdkClientException("Unable to load AWS credentials from Java system properties (aws.accessKeyId and aws.secretKey)");
        }
        if (StringUtils.isNullOrEmpty(sessionToken)) {
            return new BasicAWSCredentials(accessKey, secretKey, null, PROVIDER_NAME);
        }
        return new BasicSessionCredentials(accessKey, secretKey, sessionToken, null, PROVIDER_NAME);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

