/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.PutCompositeAlarmRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class PutCompositeAlarmRequestMarshaller
implements Marshaller<Request<PutCompositeAlarmRequest>, PutCompositeAlarmRequest> {
    @Override
    public Request<PutCompositeAlarmRequest> marshall(PutCompositeAlarmRequest putCompositeAlarmRequest) {
        if (putCompositeAlarmRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutCompositeAlarmRequest> request = new DefaultRequest<PutCompositeAlarmRequest>(putCompositeAlarmRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutCompositeAlarm");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putCompositeAlarmRequest.getActionsEnabled() != null) {
            request.addParameter("ActionsEnabled", StringUtils.fromBoolean(putCompositeAlarmRequest.getActionsEnabled()));
        }
        if (!putCompositeAlarmRequest.getAlarmActions().isEmpty() || !((SdkInternalList)putCompositeAlarmRequest.getAlarmActions()).isAutoConstruct()) {
            SdkInternalList alarmActionsList = (SdkInternalList)putCompositeAlarmRequest.getAlarmActions();
            int alarmActionsListIndex = 1;
            for (String alarmActionsListValue : alarmActionsList) {
                if (alarmActionsListValue != null) {
                    request.addParameter("AlarmActions.member." + alarmActionsListIndex, StringUtils.fromString(alarmActionsListValue));
                }
                ++alarmActionsListIndex;
            }
        }
        if (putCompositeAlarmRequest.getAlarmDescription() != null) {
            request.addParameter("AlarmDescription", StringUtils.fromString(putCompositeAlarmRequest.getAlarmDescription()));
        }
        if (putCompositeAlarmRequest.getAlarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString(putCompositeAlarmRequest.getAlarmName()));
        }
        if (putCompositeAlarmRequest.getAlarmRule() != null) {
            request.addParameter("AlarmRule", StringUtils.fromString(putCompositeAlarmRequest.getAlarmRule()));
        }
        if (!putCompositeAlarmRequest.getInsufficientDataActions().isEmpty() || !((SdkInternalList)putCompositeAlarmRequest.getInsufficientDataActions()).isAutoConstruct()) {
            SdkInternalList insufficientDataActionsList = (SdkInternalList)putCompositeAlarmRequest.getInsufficientDataActions();
            int insufficientDataActionsListIndex = 1;
            for (String insufficientDataActionsListValue : insufficientDataActionsList) {
                if (insufficientDataActionsListValue != null) {
                    request.addParameter("InsufficientDataActions.member." + insufficientDataActionsListIndex, StringUtils.fromString(insufficientDataActionsListValue));
                }
                ++insufficientDataActionsListIndex;
            }
        }
        if (!putCompositeAlarmRequest.getOKActions().isEmpty() || !((SdkInternalList)putCompositeAlarmRequest.getOKActions()).isAutoConstruct()) {
            SdkInternalList oKActionsList = (SdkInternalList)putCompositeAlarmRequest.getOKActions();
            int oKActionsListIndex = 1;
            for (String oKActionsListValue : oKActionsList) {
                if (oKActionsListValue != null) {
                    request.addParameter("OKActions.member." + oKActionsListIndex, StringUtils.fromString(oKActionsListValue));
                }
                ++oKActionsListIndex;
            }
        }
        if (!putCompositeAlarmRequest.getTags().isEmpty() || !((SdkInternalList)putCompositeAlarmRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)putCompositeAlarmRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (putCompositeAlarmRequest.getActionsSuppressor() != null) {
            request.addParameter("ActionsSuppressor", StringUtils.fromString(putCompositeAlarmRequest.getActionsSuppressor()));
        }
        if (putCompositeAlarmRequest.getActionsSuppressorWaitPeriod() != null) {
            request.addParameter("ActionsSuppressorWaitPeriod", StringUtils.fromInteger(putCompositeAlarmRequest.getActionsSuppressorWaitPeriod()));
        }
        if (putCompositeAlarmRequest.getActionsSuppressorExtensionPeriod() != null) {
            request.addParameter("ActionsSuppressorExtensionPeriod", StringUtils.fromInteger(putCompositeAlarmRequest.getActionsSuppressorExtensionPeriod()));
        }
        return request;
    }
}

