/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DiskImage;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DiskImageDetail;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ImportInstanceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Placement;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.UserData;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VolumeDetail;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ImportInstanceRequestMarshaller
implements Marshaller<Request<ImportInstanceRequest>, ImportInstanceRequest> {
    @Override
    public Request<ImportInstanceRequest> marshall(ImportInstanceRequest importInstanceRequest) {
        ImportInstanceLaunchSpecification launchSpecification;
        SdkInternalList importInstanceRequestDiskImagesList;
        if (importInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportInstanceRequest> request = new DefaultRequest<ImportInstanceRequest>(importInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "ImportInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importInstanceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(importInstanceRequest.getDescription()));
        }
        if (!(importInstanceRequestDiskImagesList = (SdkInternalList)importInstanceRequest.getDiskImages()).isEmpty() || !importInstanceRequestDiskImagesList.isAutoConstruct()) {
            int diskImagesListIndex = 1;
            for (DiskImage importInstanceRequestDiskImagesListValue : importInstanceRequestDiskImagesList) {
                VolumeDetail volume;
                Object image;
                if (importInstanceRequestDiskImagesListValue.getDescription() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Description", StringUtils.fromString(importInstanceRequestDiskImagesListValue.getDescription()));
                }
                if ((image = importInstanceRequestDiskImagesListValue.getImage()) != null) {
                    if (((DiskImageDetail)image).getBytes() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Bytes", StringUtils.fromLong(((DiskImageDetail)image).getBytes()));
                    }
                    if (((DiskImageDetail)image).getFormat() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Format", StringUtils.fromString(((DiskImageDetail)image).getFormat()));
                    }
                    if (((DiskImageDetail)image).getImportManifestUrl() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.ImportManifestUrl", StringUtils.fromString(((DiskImageDetail)image).getImportManifestUrl()));
                    }
                }
                if ((volume = importInstanceRequestDiskImagesListValue.getVolume()) != null && volume.getSize() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Volume.Size", StringUtils.fromLong(volume.getSize()));
                }
                ++diskImagesListIndex;
            }
        }
        if ((launchSpecification = importInstanceRequest.getLaunchSpecification()) != null) {
            UserData userData;
            Placement placement;
            SdkInternalList importInstanceLaunchSpecificationGroupNamesList;
            SdkInternalList importInstanceLaunchSpecificationGroupIdsList;
            if (launchSpecification.getAdditionalInfo() != null) {
                request.addParameter("LaunchSpecification.AdditionalInfo", StringUtils.fromString(launchSpecification.getAdditionalInfo()));
            }
            if (launchSpecification.getArchitecture() != null) {
                request.addParameter("LaunchSpecification.Architecture", StringUtils.fromString(launchSpecification.getArchitecture()));
            }
            if (!(importInstanceLaunchSpecificationGroupIdsList = (SdkInternalList)launchSpecification.getGroupIds()).isEmpty() || !importInstanceLaunchSpecificationGroupIdsList.isAutoConstruct()) {
                int groupIdsListIndex = 1;
                for (Object importInstanceLaunchSpecificationGroupIdsListValue : importInstanceLaunchSpecificationGroupIdsList) {
                    if (importInstanceLaunchSpecificationGroupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.GroupId." + groupIdsListIndex, StringUtils.fromString((String)importInstanceLaunchSpecificationGroupIdsListValue));
                    }
                    ++groupIdsListIndex;
                }
            }
            if (!(importInstanceLaunchSpecificationGroupNamesList = (SdkInternalList)launchSpecification.getGroupNames()).isEmpty() || !importInstanceLaunchSpecificationGroupNamesList.isAutoConstruct()) {
                int groupNamesListIndex = 1;
                for (String importInstanceLaunchSpecificationGroupNamesListValue : importInstanceLaunchSpecificationGroupNamesList) {
                    if (importInstanceLaunchSpecificationGroupNamesListValue != null) {
                        request.addParameter("LaunchSpecification.GroupName." + groupNamesListIndex, StringUtils.fromString(importInstanceLaunchSpecificationGroupNamesListValue));
                    }
                    ++groupNamesListIndex;
                }
            }
            if (launchSpecification.getInstanceInitiatedShutdownBehavior() != null) {
                request.addParameter("LaunchSpecification.InstanceInitiatedShutdownBehavior", StringUtils.fromString(launchSpecification.getInstanceInitiatedShutdownBehavior()));
            }
            if (launchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString(launchSpecification.getInstanceType()));
            }
            if (launchSpecification.getMonitoring() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean(launchSpecification.getMonitoring()));
            }
            if ((placement = launchSpecification.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
                }
                if (placement.getAffinity() != null) {
                    request.addParameter("LaunchSpecification.Placement.Affinity", StringUtils.fromString(placement.getAffinity()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString(placement.getGroupName()));
                }
                if (placement.getPartitionNumber() != null) {
                    request.addParameter("LaunchSpecification.Placement.PartitionNumber", StringUtils.fromInteger(placement.getPartitionNumber()));
                }
                if (placement.getHostId() != null) {
                    request.addParameter("LaunchSpecification.Placement.HostId", StringUtils.fromString(placement.getHostId()));
                }
                if (placement.getTenancy() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringUtils.fromString(placement.getTenancy()));
                }
                if (placement.getSpreadDomain() != null) {
                    request.addParameter("LaunchSpecification.Placement.SpreadDomain", StringUtils.fromString(placement.getSpreadDomain()));
                }
                if (placement.getHostResourceGroupArn() != null) {
                    request.addParameter("LaunchSpecification.Placement.HostResourceGroupArn", StringUtils.fromString(placement.getHostResourceGroupArn()));
                }
                if (placement.getGroupId() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupId", StringUtils.fromString(placement.getGroupId()));
                }
            }
            if (launchSpecification.getPrivateIpAddress() != null) {
                request.addParameter("LaunchSpecification.PrivateIpAddress", StringUtils.fromString(launchSpecification.getPrivateIpAddress()));
            }
            if (launchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString(launchSpecification.getSubnetId()));
            }
            if ((userData = launchSpecification.getUserData()) != null && userData.getData() != null) {
                request.addParameter("LaunchSpecification.UserData.Data", StringUtils.fromString(userData.getData()));
            }
        }
        if (importInstanceRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString(importInstanceRequest.getPlatform()));
        }
        return request;
    }
}

