/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.TargetDescription;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.List;

public class DeregisterTargetsRequestMarshaller
implements Marshaller<Request<DeregisterTargetsRequest>, DeregisterTargetsRequest> {
    @Override
    public Request<DeregisterTargetsRequest> marshall(DeregisterTargetsRequest deregisterTargetsRequest) {
        if (deregisterTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeregisterTargetsRequest> request = new DefaultRequest<DeregisterTargetsRequest>(deregisterTargetsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DeregisterTargets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deregisterTargetsRequest.getTargetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString(deregisterTargetsRequest.getTargetGroupArn()));
        }
        if (deregisterTargetsRequest.getTargets() != null) {
            List<TargetDescription> targetsList = deregisterTargetsRequest.getTargets();
            if (targetsList.isEmpty()) {
                request.addParameter("Targets", "");
            } else {
                int targetsListIndex = 1;
                for (TargetDescription targetsListValue : targetsList) {
                    if (targetsListValue != null) {
                        if (targetsListValue.getId() != null) {
                            request.addParameter("Targets.member." + targetsListIndex + ".Id", StringUtils.fromString(targetsListValue.getId()));
                        }
                        if (targetsListValue.getPort() != null) {
                            request.addParameter("Targets.member." + targetsListIndex + ".Port", StringUtils.fromInteger(targetsListValue.getPort()));
                        }
                        if (targetsListValue.getAvailabilityZone() != null) {
                            request.addParameter("Targets.member." + targetsListIndex + ".AvailabilityZone", StringUtils.fromString(targetsListValue.getAvailabilityZone()));
                        }
                    }
                    ++targetsListIndex;
                }
            }
        }
        return request;
    }
}

