/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import org.geotools.data.shapefile.shp.MultiLineHandler;
import org.geotools.data.shapefile.shp.MultiPointHandler;
import org.geotools.data.shapefile.shp.PointHandler;
import org.geotools.data.shapefile.shp.PolygonHandler;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.locationtech.jts.geom.GeometryFactory;

public enum ShapeType {
    NULL(0, "Null"),
    POINT(1, "Point"),
    POINTZ(11, "PointZ"),
    POINTM(21, "PointM"),
    ARC(3, "Arc"),
    ARCZ(13, "ArcZ"),
    ARCM(23, "ArcM"),
    POLYGON(5, "Polygon"),
    POLYGONZ(15, "PolygonZ"),
    POLYGONM(25, "PolygonM"),
    MULTIPOINT(8, "MultiPoint"),
    MULTIPOINTZ(18, "MultiPointZ"),
    MULTIPOINTM(28, "MultiPointM"),
    UNDEFINED(-1, "Undefined");

    public final int id;
    public final String name;

    private ShapeType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isMultiPoint() {
        if (this == UNDEFINED) {
            return false;
        }
        if (this == NULL) {
            return false;
        }
        return this != POINT && this != POINTM && this != POINTZ;
    }

    public boolean isPointType() {
        return this.id % 10 == 1;
    }

    public boolean isLineType() {
        return this.id % 10 == 3;
    }

    public boolean isPolygonType() {
        return this.id % 10 == 5;
    }

    public boolean isMultiPointType() {
        return this.id % 10 == 8;
    }

    public static ShapeType forID(int id) {
        switch (id) {
            case 0: {
                return NULL;
            }
            case 1: {
                return POINT;
            }
            case 11: {
                return POINTZ;
            }
            case 21: {
                return POINTM;
            }
            case 3: {
                return ARC;
            }
            case 13: {
                return ARCZ;
            }
            case 23: {
                return ARCM;
            }
            case 5: {
                return POLYGON;
            }
            case 15: {
                return POLYGONZ;
            }
            case 25: {
                return POLYGONM;
            }
            case 8: {
                return MULTIPOINT;
            }
            case 18: {
                return MULTIPOINTZ;
            }
            case 28: {
                return MULTIPOINTM;
            }
        }
        return UNDEFINED;
    }

    public ShapeHandler getShapeHandler(GeometryFactory gf) throws ShapefileException {
        switch (this.id) {
            case 1: 
            case 11: 
            case 21: {
                return new PointHandler(this, gf);
            }
            case 3: 
            case 13: 
            case 23: {
                return new MultiLineHandler(this, gf);
            }
            case 5: 
            case 15: 
            case 25: {
                return new PolygonHandler(this, gf);
            }
            case 8: 
            case 18: 
            case 28: {
                return new MultiPointHandler(this, gf);
            }
        }
        return null;
    }
}

