/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.ExactValueDimensionValue;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;

public class Partition
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected PartitioningScheme scheme;
    private boolean all;
    protected Map<String, DimensionValue> dimensionValues = new HashMap<String, DimensionValue>();

    public Partition(PartitioningScheme scheme) {
        this.scheme = scheme;
    }

    public static Partition newNP() {
        return new Partition(null);
    }

    public static Partition newALL(PartitioningScheme scheme) {
        Partition p = new Partition(scheme);
        p.all = true;
        return p;
    }

    public static DimensionValue randomSamplePartition(Dimension dim) {
        if (dim instanceof TimeDimension) {
            TimeDimension td = (TimeDimension)dim;
            ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
            switch (td.mappedPeriod) {
                case DAY: {
                    return new TimeDimensionValue(td, now.getYear(), now.getMonthValue(), now.getDayOfMonth());
                }
                case HOUR: {
                    return new TimeDimensionValue(td, now.getYear(), now.getMonthValue(), now.getDayOfMonth(), now.getHour());
                }
                case MONTH: {
                    return new TimeDimensionValue(td, now.getYear(), now.getMonthValue());
                }
                case YEAR: {
                    return new TimeDimensionValue(td, now.getYear());
                }
            }
            throw new Error("Unsupported period: " + String.valueOf((Object)td.mappedPeriod));
        }
        if (dim instanceof ExactValueDimension) {
            return new ExactValueDimensionValue("sampleval");
        }
        throw new NotImplementedException("Unsupported dimension type: " + dim.getClass().getSimpleName());
    }

    public static Partition randomSamplePartition(PartitioningScheme scheme) {
        Partition p = new Partition(scheme);
        for (String dimName : scheme.getDimensionNames()) {
            Dimension dim = scheme.getDimension(dimName);
            if (dim instanceof TimeDimension) {
                TimeDimension td = (TimeDimension)dim;
                switch (td.mappedPeriod) {
                    case DAY: {
                        p.dimensionValues.put(dim.getName(), new TimeDimensionValue(td, 2013, 12, 31));
                        break;
                    }
                    case HOUR: {
                        p.dimensionValues.put(dim.getName(), new TimeDimensionValue(td, 2013, 12, 31, 23));
                        break;
                    }
                    case MONTH: {
                        p.dimensionValues.put(dim.getName(), new TimeDimensionValue(td, 2013, 12));
                        break;
                    }
                    case YEAR: {
                        p.dimensionValues.put(dim.getName(), new TimeDimensionValue(td, 2013));
                        break;
                    }
                    default: {
                        throw new Error("Unsupported period: " + String.valueOf((Object)td.mappedPeriod));
                    }
                }
                continue;
            }
            if (dim instanceof ExactValueDimension) {
                p.dimensionValues.put(dim.getName(), new ExactValueDimensionValue("sampleval"));
                continue;
            }
            throw new NotImplementedException("Unsupported dimension type: " + dim.getClass().getSimpleName());
        }
        return p;
    }

    public PartitioningScheme getScheme() {
        return this.scheme;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean isNP() {
        return this.scheme == null;
    }

    public Partition copy() {
        Partition copy = new Partition(this.scheme);
        for (Map.Entry<String, DimensionValue> dv : this.dimensionValues.entrySet()) {
            copy.dimensionValues.put(dv.getKey(), dv.getValue().copy());
        }
        return copy;
    }

    public String toString() {
        return "<partition:" + this.id() + ">";
    }

    public String id() {
        if (this.isAll()) {
            return "ALL";
        }
        if (this.scheme == null || this.dimensionValues.size() == 0) {
            assert (this.dimensionValues.size() == 0);
            return "NP";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : this.scheme.getDimensionNames()) {
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            if (this.dimensionValues.containsKey(name)) {
                sb.append(this.dimensionValues.get(name).id());
                continue;
            }
            sb.append("*");
        }
        return sb.toString();
    }

    public boolean isComplete() {
        for (String dname : this.scheme.getDimensionNames()) {
            if (this.dimensionValues.get(dname) != null) continue;
            return false;
        }
        return true;
    }

    public void setDimensionValue(String dimension, DimensionValue val) {
        this.dimensionValues.put(dimension, val);
    }

    public Map<String, DimensionValue> getDimensionValues() {
        return ImmutableMap.copyOf(this.dimensionValues);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimensionValues == null ? 0 : this.dimensionValues.hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Partition other = (Partition)obj;
        if (this.dimensionValues == null ? other.dimensionValues != null : !this.dimensionValues.equals(other.dimensionValues)) {
            return false;
        }
        return !(this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme));
    }

    public Partition clone() {
        return this.copy();
    }
}

