/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import org.bson.BsonDocument;
import org.bson.codecs.Decoder;

public class CommandReadOperation<T>
implements AsyncReadOperation<T>,
ReadOperation<T> {
    private final String databaseName;
    private final CommandOperationHelper.CommandCreator commandCreator;
    private final Decoder<T> decoder;

    public CommandReadOperation(String databaseName, BsonDocument command, Decoder<T> decoder) {
        this(databaseName, (OperationContext operationContext, ServerDescription serverDescription, ConnectionDescription connectionDescription) -> command, decoder);
    }

    public CommandReadOperation(String databaseName, CommandOperationHelper.CommandCreator commandCreator, Decoder<T> decoder) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.commandCreator = Assertions.notNull("commandCreator", commandCreator);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public T execute(ReadBinding binding) {
        return (T)SyncOperationHelper.executeRetryableRead(binding, this.databaseName, this.commandCreator, this.decoder, (result, source, connection) -> result, false);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<T> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, this.databaseName, this.commandCreator, this.decoder, (result, source, connection) -> result, false, callback);
    }
}

