/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.auth.GroupProfile;
import com.dataiku.dip.security.auth.UserRemappingRule;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.auth.UserSupplierSettings;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@UIModel
public class SSOSettings
implements UserSupplierSettings {
    public SSOProtocol protocol = SSOProtocol.SAML;
    public List<UserRemappingRule> remappingRules = new ArrayList<UserRemappingRule>();
    public String samlIDPMetadata;
    public SAMLSPParams samlSPParams = new SAMLSPParams();
    public String samlLoginAttribute;
    public OpenIDParams openIDParams = new OpenIDParams();
    public String spnegoKrb5File;
    public SPNEGOMode spnegoMode = SPNEGOMode.PREAUTH_KEYTAB;
    public String spnegoPreauthLogin;
    public String spnegoPreauthPassword;
    public String spnegoPreauthKeytab;
    public String spnegoPreauthPrincipal;
    public String spnegoLoginConfFile;
    public boolean spnegoStripRealm = true;
    public boolean enabled = false;
    @UINullable
    public Integer order;
    public boolean autoProvisionUsersAtLoginTime = true;
    public boolean autoSyncUsersAtLoginTime = false;
    public String defaultUserProfile;
    public List<GroupProfile> groupProfiles = new ArrayList<GroupProfile>();
    public List<String> authorizedGroups = new ArrayList<String>();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isUsersAutoProvisioningAtLoginTimeEnabled() {
        return this.autoProvisionUsersAtLoginTime;
    }

    @Override
    public boolean isUsersAutoSyncAtLoginTimeEnabled() {
        return this.autoSyncUsersAtLoginTime;
    }

    @Override
    public boolean isOnDemandUsersSyncEnabled() {
        return false;
    }

    @Override
    public String getDefaultUserProfile() {
        return this.defaultUserProfile;
    }

    @Override
    public Integer getOrder() {
        return this.order != null ? this.order.intValue() : this.getUserSourceType().getDefaultOrder();
    }

    @Override
    public UserSourceType getUserSourceType() {
        return UserSourceType.LOCAL_NO_AUTH;
    }

    public void encryptFields(PasswordEncryptionService cryptoService) {
        if (this.samlSPParams != null) {
            this.samlSPParams.encryptFields(cryptoService);
        }
        if (this.openIDParams != null) {
            this.openIDParams.encryptFields(cryptoService);
        }
    }

    @Override
    public List<GroupProfile> getProfileMappings() {
        return this.groupProfiles;
    }

    @Override
    public Set<String> getAuthorizedGroups() {
        return this.areGroupsEnabled() ? this.authorizedGroups.stream().map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet()) : Collections.emptySet();
    }

    private boolean areGroupsEnabled() {
        switch (this.protocol) {
            case OPENID: {
                return this.openIDParams.enableGroups;
            }
            case SAML: {
                return this.samlSPParams.enableGroups;
            }
        }
        return false;
    }

    @Override
    public List<UserRemappingRule> getUserRemappingRules() {
        return this.remappingRules;
    }

    @Override
    public boolean isOnDemandUsersProvisioningEnabled() {
        return false;
    }

    public static enum SSOProtocol {
        SAML,
        SPNEGO,
        OPENID;

    }

    public static class SAMLSPParams {
        public String entityId;
        public String acsURL;
        public boolean signRequests;
        public String keystoreFile;
        public String keystorePassword;
        public String keyAlias;
        public String hashingAlgorithm = "SHA256";
        public String displayNameAttribute = "firstName";
        public String emailAttribute = "email";
        public boolean enableGroups = false;
        public String groupsAttribute = "member";
        public boolean enableRelayState = false;

        public void encryptFields(PasswordEncryptionService cryptoService) {
            this.keystorePassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.keystorePassword);
        }

        public Optional<String> decryptKeystorePassword(PasswordEncryptionService cryptoService) {
            String ksPassword = cryptoService.decryptIfEncrypted(this.keystorePassword);
            return Optional.ofNullable(ksPassword);
        }
    }

    public static class OpenIDParams {
        public String clientId;
        public String clientSecret;
        public String scope = "openid email";
        public String issuer;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String jwksUri;
        public String claimKeyIdentifier = "email";
        public boolean lowercaseIdentifier = false;
        public String claimKeyDisplayName = "displayName";
        public String claimKeyEmail = "email";
        public boolean enableGroups = false;
        public String claimKeyGroups = "groups";
        public boolean useGlobalProxy = true;
        public boolean usePKCE = true;
        public String prompt;
        public OpenIDTokenEndpointAuthMethod tokenEndpointAuthMethod = OpenIDTokenEndpointAuthMethod.CLIENT_SECRET_BASIC;

        public String getClientSecretDecrypted(PasswordEncryptionService passwordEncryptionService) {
            return passwordEncryptionService.decryptIfEncrypted(this.clientSecret);
        }

        public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
            this.clientSecret = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(this.clientSecret);
        }
    }

    public static enum SPNEGOMode {
        PREAUTH_KEYTAB,
        CUSTOM_LOGIN_CONF;

    }

    public static enum OpenIDTokenEndpointAuthMethod {
        CLIENT_SECRET_BASIC,
        CLIENT_SECRET_POST;

    }
}

