/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.sso;

import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Jul2Log4JHandler;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import net.sourceforge.spnego.SpnegoAuthenticator;
import net.sourceforge.spnego.SpnegoHttpServletResponse;
import net.sourceforge.spnego.SpnegoPrincipal;
import org.apache.commons.lang.StringUtils;
import org.ietf.jgss.GSSException;

public class SpnegoHelper {
    private final SpnegoAuthenticator spnegoAuthenticator;
    private final File loginConfFile;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth.sso");

    public SpnegoHelper(SSOSettings ssoSettings, File loginConfFile) throws GSSException, PrivilegedActionException, LoginException, IOException, URISyntaxException {
        this.loginConfFile = loginConfFile;
        this.spnegoAuthenticator = this.initSPNEGO(ssoSettings);
    }

    private SpnegoAuthenticator initSPNEGO(SSOSettings ssoSettings) throws IOException, LoginException, GSSException, PrivilegedActionException, URISyntaxException {
        logger.info((Object)"Init SPNEGO authenticator");
        new Jul2Log4JHandler(DKULogger.getRealLogger((String)"dku.auth.spnego")).bridge(Logger.getLogger("SpnegoHttpFilter"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spnego.allow.basic", "false");
        map.put("spnego.allow.localhost", "false");
        map.put("spnego.prompt.ntlm", "false");
        map.put("spnego.allow.unsecure.basic", "true");
        switch (ssoSettings.spnegoMode) {
            case CUSTOM_LOGIN_CONF: {
                map.put("spnego.login.conf", "file://" + ssoSettings.spnegoLoginConfFile);
                if (StringUtils.isNotBlank((String)ssoSettings.spnegoPreauthLogin)) {
                    map.put("spnego.preauth.username", ssoSettings.spnegoPreauthLogin);
                } else {
                    map.put("spnego.preauth.username", "");
                }
                if (StringUtils.isNotBlank((String)ssoSettings.spnegoPreauthPassword)) {
                    map.put("spnego.preauth.password", ssoSettings.spnegoPreauthPassword);
                    break;
                }
                map.put("spnego.preauth.password", "");
                break;
            }
            case PREAUTH_KEYTAB: {
                Object loginConf = "dss-spnego-client { com.sun.security.auth.module.Krb5LoginModule required; };\n";
                loginConf = (String)loginConf + String.format("dss-spnego-server { com.sun.security.auth.module.Krb5LoginModule required storeKey=true isInitiator=false\n   useKeyTab=true keyTab=\"%s\" principal = \"%s\" debug=true; };", ssoSettings.spnegoPreauthKeytab, ssoSettings.spnegoPreauthPrincipal);
                FileUtils.writeStringToFile((File)this.loginConfFile, (String)loginConf, (Charset)StandardCharsets.UTF_8);
                map.put("spnego.login.conf", "file://" + this.loginConfFile.getAbsolutePath());
                map.put("spnego.preauth.username", "");
                map.put("spnego.preauth.password", "");
                break;
            }
        }
        map.put("spnego.login.client.module", "dss-spnego-client");
        map.put("spnego.login.server.module", "dss-spnego-server");
        if (StringUtils.isNotBlank((String)ssoSettings.spnegoKrb5File)) {
            map.put("spnego.krb5.conf", "file://" + ssoSettings.spnegoKrb5File);
        } else {
            map.put("spnego.krb5.conf", System.getProperty("java.security.krb5.conf", "/etc/krb5.conf"));
        }
        map.put("spnego.allow.delegation", "true");
        map.put("spnego.logger.level", "1");
        return new SpnegoAuthenticator(map);
    }

    public SpnegoPrincipal authenticate(HttpServletRequest req, SpnegoHttpServletResponse spnegoResponse) throws SPNEGOAuthenticationFailure, SPNEGONegotiationPending, SPNEGOAuthenticationBadRequest {
        String authHeader = req.getHeader("Authorization");
        if (authHeader != null && (authHeader.equals("Basic") || authHeader.equals("Negotiate"))) {
            throw new SPNEGOAuthenticationBadRequest("Invalid authorization header: " + authHeader);
        }
        try {
            SpnegoPrincipal principal = this.spnegoAuthenticator.authenticate(req, spnegoResponse);
            if (principal == null) {
                if (spnegoResponse.isStatusSet()) {
                    throw new SPNEGONegotiationPending("SPNEGO negotiation in progress.");
                }
                throw new SPNEGOAuthenticationFailure("SPNEGO Authentication failed.");
            }
            return principal;
        }
        catch (IOException | GSSException e) {
            throw new SPNEGOAuthenticationFailure("SPNEGO Authentication failed.", e);
        }
    }

    public static class SPNEGOAuthenticationBadRequest
    extends Exception {
        public SPNEGOAuthenticationBadRequest(String message) {
            super(message);
        }
    }

    public static class SPNEGONegotiationPending
    extends Exception {
        public SPNEGONegotiationPending(String message) {
            super(message);
        }
    }

    public static class SPNEGOAuthenticationFailure
    extends Exception {
        public SPNEGOAuthenticationFailure(String message, Throwable cause) {
            super(message, cause);
        }

        public SPNEGOAuthenticationFailure(String message) {
            super(message);
        }
    }
}

