/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.tickets;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.security.tickets.ContextAwareTicketPayload;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class APITicketService {
    public ExpirableTicket createExpiringTicket(AuthCtx authCtx, String description, Object payload) {
        return new ExpirableTicket(this.createTicket(authCtx, description, payload));
    }

    public abstract Ticket createTicket(AuthCtx var1, String var2, Object var3);

    public abstract Ticket getTicket(String var1) throws IOException, DKUSecurityException;

    public abstract Ticket getSingleTicket();

    public abstract AuthCtx getTicketAuthCtx(String var1) throws IOException, DKUSecurityException;

    public abstract TicketUsage getAndUseTicket(String var1) throws IOException, DKUSecurityException;

    public abstract TicketUsage getAndUseSingleTicket();

    public abstract AuthCtx getTicketUser(String var1) throws IOException, DKUSecurityException;

    public abstract void expireTicket(Ticket var1);

    public abstract void registerFutureUsingTicket(Ticket var1, FutureThreadBase<?> var2);

    public abstract void deregisterFutureUsingTicket(Ticket var1, FutureThreadBase<?> var2);

    public abstract void abortFutureUsingTicket(Ticket var1);

    public class ExpirableTicket
    implements AutoCloseable {
        private final Ticket t;

        public ExpirableTicket(Ticket t) {
            this.t = t;
        }

        public String getSecret() {
            return this.t.getSecret();
        }

        @Override
        public void close() {
            APITicketService.this.expireTicket(this.t);
        }
    }

    public static class Ticket {
        public long creationTime = System.currentTimeMillis();
        public String id;
        public String secret;
        public String description;
        protected AuthCtx user;
        public boolean refreshableAuthCtx = true;
        public PublicAPIKey key;
        public LocalFolderAwareWorkload localFolderAwareWorkload;
        public Object payload;
        public Map<String, String> metadata = new HashMap<String, String>();
        public ComputeResourceUsageContext cruContext;
        private boolean isProxied;
        public Map<AuthCtx, Ticket> obtainedUsingCookies = Maps.newHashMap();

        public String getSecret() {
            return this.secret;
        }

        public String getDescription() {
            return this.description;
        }

        public AuthCtx getOriginalUser() {
            return this.user;
        }

        public PublicAPIKey getKey() {
            return this.key;
        }

        public Object getPayload() {
            return this.payload;
        }

        public String getId() {
            return this.id;
        }

        public Map<AuthCtx, Ticket> getTicketsObtainedUsingCookies() {
            return this.obtainedUsingCookies;
        }

        public Ticket withSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public Ticket withDescription(String description) {
            this.description = description;
            return this;
        }

        public Ticket withUser(AuthCtx user) {
            this.user = user;
            return this;
        }

        public Ticket withKey(PublicAPIKey key) {
            this.key = key;
            return this;
        }

        public Ticket withPayload(Object payload) {
            this.payload = payload;
            return this;
        }

        public Ticket withId(String id) {
            this.id = id;
            return this;
        }

        public Ticket withRefreshableAuthCtx(boolean refreshableAuthCtx) {
            this.refreshableAuthCtx = refreshableAuthCtx;
            return this;
        }

        public AuthCtx getViaAuthCtx() {
            AuthCtx authCtx = this.getOriginalUser().deepCopy();
            authCtx.addVia("ticket:" + this.getDescription());
            return authCtx;
        }

        public Ticket withTicketObtainedUsingCookies(AuthCtx authCtx, Ticket ticket) throws DKUSecurityException {
            if (this.isProxied) {
                throw new DKUSecurityException("Cannot chain ticket proxying");
            }
            this.obtainedUsingCookies.put(authCtx, ticket);
            ticket.isProxied = true;
            return this;
        }
    }

    public static class TicketUsage
    implements AuthCtxUsage {
        private final Ticket ticket;
        private final AutoCloseable ctx;
        private final AuthCtx authCtx;

        protected TicketUsage(Ticket ticket) {
            this.ticket = ticket;
            this.ctx = ticket.getPayload() != null && ticket.getPayload() instanceof ContextAwareTicketPayload ? ((ContextAwareTicketPayload)ticket.getPayload()).openTicketContext() : null;
            this.authCtx = ticket.getViaAuthCtx();
        }

        public TicketUsage(TicketUsage ticketUsage, AuthCtx authCtx) {
            this.ticket = ticketUsage.ticket;
            this.ctx = ticketUsage.ctx;
            this.authCtx = authCtx;
        }

        @Override
        public void close() throws Exception {
            if (this.ctx != null) {
                this.ctx.close();
            }
        }

        public Ticket getTicket() {
            return this.ticket;
        }

        @Override
        public AuthCtx getAuthCtx() {
            return this.authCtx;
        }

        @Override
        public Object getPayload() {
            return this.ticket;
        }
    }

    public static class LocalFolderAwareWorkload {
        public String projectKey;
        public String workloadId;
        public LocalFolderAwareWorkloadType type;

        public LocalFolderAwareWorkload() {
        }

        public LocalFolderAwareWorkload(LocalFolderAwareWorkloadType type, String projectKey, String workloadId) {
            this.type = type;
            this.projectKey = projectKey;
            this.workloadId = workloadId;
        }
    }

    public static enum LocalFolderAwareWorkloadType {
        WEBAPP,
        AGENT,
        AGENT_TOOL;

    }
}

