/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.tickets;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractAPITicketService
extends APITicketService {
    private Map<String, List<FutureThreadBase<?>>> futuresUsingTicket = Maps.newHashMap();
    private static DKULogger logger = DKULogger.getLogger((String)"dip.tickets.abstract");

    @Override
    public APITicketService.TicketUsage getAndUseTicket(String secret) throws IOException, DKUSecurityException {
        APITicketService.Ticket ticket = this.getTicket(secret);
        if (ticket == null) {
            return null;
        }
        return new APITicketService.TicketUsage(ticket);
    }

    @Override
    public AuthCtx getTicketAuthCtx(String secret) throws IOException, DKUSecurityException {
        APITicketService.Ticket ticket = this.getTicket(secret);
        if (ticket == null) {
            return null;
        }
        return ticket.getViaAuthCtx();
    }

    @Override
    public APITicketService.TicketUsage getAndUseSingleTicket() {
        APITicketService.Ticket ticket = this.getSingleTicket();
        if (ticket == null) {
            return null;
        }
        return new APITicketService.TicketUsage(ticket);
    }

    @Override
    public synchronized void registerFutureUsingTicket(APITicketService.Ticket ticket, FutureThreadBase<?> future) {
        ArrayList futures = this.futuresUsingTicket.get(ticket.getSecret());
        if (futures == null) {
            futures = Lists.newArrayList();
            this.futuresUsingTicket.put(ticket.getSecret(), futures);
        }
        if (futures.indexOf(future) >= 0) {
            throw new IllegalArgumentException("The future is already registered as using this API ticket");
        }
        futures.add(future);
    }

    @Override
    public synchronized void deregisterFutureUsingTicket(APITicketService.Ticket ticket, FutureThreadBase<?> future) {
        List<FutureThreadBase<?>> futures = this.futuresUsingTicket.get(ticket.getSecret());
        if (futures == null) {
            throw new IllegalArgumentException("No future declared an usage of this API ticket");
        }
        if (futures.indexOf(future) < 0) {
            throw new IllegalArgumentException("The future is not registered as using this API ticket");
        }
        futures.remove(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortFutureUsingTicket(APITicketService.Ticket ticket) {
        ArrayList futures;
        AbstractAPITicketService abstractAPITicketService = this;
        synchronized (abstractAPITicketService) {
            futures = this.futuresUsingTicket.containsKey(ticket.getSecret()) ? Lists.newArrayList((Iterable)this.futuresUsingTicket.get(ticket.getSecret())) : null;
        }
        if (futures != null) {
            for (FutureThreadBase future : futures) {
                future.abort();
            }
            logger.info((Object)("Aborted " + futures.size() + " futures having reported using ticket " + ticket.getSecret()));
        }
    }
}

