/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.FileContentCompressor;
import com.dataiku.dip.transactions.fs.ifaces.StreamSupplier;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.ByteArrayOutputStream;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class FileContentFactory
implements AutoCloseable {
    @Nullable
    private AutoDelete storageDirectory;
    private final Supplier<AutoDelete> storageDirectorySupplier;
    private final FileContentCompressor compressor;
    public static final FileContentFactory DEFAULT = new FileContentFactory(null, FileContentCompressor.NOOP_COMPRESSOR);

    public OutputStream fromOutputStream(FileContentConsumer consumer) throws IOException {
        return new WritableFileData(consumer);
    }

    public <T> FileContent fromObject(T obj) {
        FileContent fc = new FileContent();
        fc.object = Preconditions.checkNotNull(obj);
        fc.compressedBytes = null;
        fc.compressor = this.compressor;
        return fc;
    }

    public FileContent fromUncompressedStreamSupplier(StreamSupplier streamSupplier, long length) {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"A valid length must be provided");
        FileContent fc = new FileContent();
        fc.object = null;
        fc.compressedBytes = null;
        fc.uncompressedLength = length;
        fc.uncompressedStreamSupplier = (StreamSupplier)Preconditions.checkNotNull((Object)streamSupplier);
        fc.compressor = this.compressor;
        return fc;
    }

    public FileContent fromString(String string) {
        FileContent fc = new FileContent();
        fc.object = null;
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        fc.compressedBytes = this.compressor.compressBytes(string.getBytes(StandardCharsets.UTF_8));
        fc.uncompressedLength = bytes.length;
        fc.compressor = this.compressor;
        return fc;
    }

    public FileContent fromUncompressedBytes(byte[] bytes) {
        return this.fromCompressedBytes(this.compressor.compressBytes(bytes), bytes.length, this.compressor);
    }

    public FileContent fromCompressedBytes(byte[] compressedBytes, long uncompressedLength, FileContentCompressor usedCompressor) {
        FileContent fc = new FileContent();
        fc.object = null;
        fc.compressedBytes = (byte[])Preconditions.checkNotNull((Object)compressedBytes);
        fc.uncompressedLength = uncompressedLength;
        fc.compressor = usedCompressor;
        return fc;
    }

    public FileContentFactory(@Nullable Supplier<AutoDelete> storageDirectorySupplier, FileContentCompressor compressor) {
        this.storageDirectorySupplier = storageDirectorySupplier;
        this.compressor = compressor;
    }

    @Override
    public synchronized void close() {
        if (this.storageDirectory != null) {
            this.storageDirectory.close();
        }
    }

    private synchronized File nextTempFile() {
        this.storageDirectory = this.storageDirectorySupplier.get();
        this.storageDirectory.mkdirs();
        return new File(this.storageDirectory, "data_" + SecretKeyGenerator.generateSmall());
    }

    private class WritableFileData
    extends OutputStream {
        private final FileContentConsumer consumer;
        private final OutputStream compressedOutputStream;
        private OutputStream diskStream;
        private ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
        private File tempFile;
        private long uncompressedLength;
        private final byte[] oneByte = new byte[1];

        private WritableFileData(final FileContentConsumer consumer) throws IOException {
            this.consumer = consumer;
            this.compressedOutputStream = FileContentFactory.this.compressor.compressStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    WritableFileData.this.oneByte[0] = (byte)b;
                    this.write(WritableFileData.this.oneByte);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.write(b, 0, b.length);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    if (WritableFileData.this.memoryStream != null) {
                        WritableFileData.this.memoryStream.write(b, off, len);
                    } else if (WritableFileData.this.diskStream != null) {
                        WritableFileData.this.diskStream.write(b, off, len);
                    } else {
                        throw new IOException("Broken stream");
                    }
                }

                @Override
                public void close() throws IOException {
                    if (WritableFileData.this.memoryStream != null) {
                        byte[] data = WritableFileData.this.memoryStream.toByteArray();
                        WritableFileData.this.memoryStream = null;
                        consumer.consume(FileContentFactory.this.fromCompressedBytes(data, WritableFileData.this.uncompressedLength, FileContentFactory.this.compressor));
                    } else if (WritableFileData.this.diskStream != null && FileContentFactory.this.storageDirectorySupplier != null) {
                        OutputStream copiedDiskStream = WritableFileData.this.diskStream;
                        WritableFileData.this.diskStream = null;
                        copiedDiskStream.close();
                        consumer.consume(FileContentFactory.this.fromUncompressedStreamSupplier(() -> FileContentFactory.this.compressor.uncompressStream(Files.newInputStream(WritableFileData.this.tempFile.toPath(), new OpenOption[0])), WritableFileData.this.uncompressedLength));
                    }
                }
            });
        }

        private void switchToDiskIfLarge() throws IOException {
            if (FileContentFactory.this.storageDirectorySupplier != null && this.memoryStream != null && this.diskStream == null && this.uncompressedLength > 0x100000L) {
                this.tempFile = FileContentFactory.this.nextTempFile();
                byte[] data = this.memoryStream.toByteArray();
                this.memoryStream = null;
                this.diskStream = Files.newOutputStream(this.tempFile.toPath(), new OpenOption[0]);
                this.tempFile.deleteOnExit();
                IOUtils.write((byte[])data, (OutputStream)this.diskStream);
            }
        }

        @Override
        public void write(int b) throws IOException {
            ++this.uncompressedLength;
            this.switchToDiskIfLarge();
            this.compressedOutputStream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.uncompressedLength += (long)b.length;
            this.switchToDiskIfLarge();
            this.compressedOutputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.uncompressedLength += (long)len;
            this.switchToDiskIfLarge();
            this.compressedOutputStream.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.compressedOutputStream.close();
        }
    }

    public static interface FileContentConsumer {
        public void consume(FileContent var1) throws IOException;
    }
}

