/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.FileContentFactory;
import com.dataiku.dip.transactions.fs.ReadOnlyFSBase;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileOutputStream;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ReadWriteFSBase
extends ReadOnlyFSBase
implements ReadWriteFS {
    protected final FileContentFactory fileContentFactory;

    public ReadWriteFSBase(FileContentFactory fileContentFactory) {
        this.fileContentFactory = fileContentFactory;
    }

    @Override
    public <T> void writeObjectNoMkdir(String path, T obj) throws IOException {
        this.writeObjectNoMkdir(RelFile.fromPath(path), obj);
    }

    @Override
    public boolean deleteFile(String path) throws IOException {
        return this.deleteFile(RelFile.fromPath(path));
    }

    @Override
    public boolean deleteDirectory(String path) throws IOException {
        return this.deleteDirectory(RelFile.fromPath(path));
    }

    @Override
    public boolean makeDirectory(String path) throws IOException {
        return this.makeDirectory(RelFile.fromPath(path));
    }

    @Override
    public void writeStringUTF8NoMkdir(String path, String content) throws IOException {
        this.writeStringUTF8NoMkdir(RelFile.fromPath(path), content);
    }

    @Override
    public <T> void writeObjectUnsafeNoMkdir(String path, T obj) throws IOException {
        this.writeObjectUnsafeNoMkdir(RelFile.fromPath(path), obj);
    }

    @Override
    public <T> void writeObjectNoMkdir(RelFile file, T obj) throws IOException {
        try (RelFileOutputStream os = this.writeStreamNoMkdir(file);){
            JSON.prettyToStreamAsFile(obj, (OutputStream)((Object)os));
        }
    }

    @Override
    public <T> void writeObject(RelFile file, T obj) throws IOException {
        if (file.getParent() != null) {
            this.makeDirectory(file.getParent());
        }
        this.writeObjectNoMkdir(file, obj);
    }

    @Override
    public <T> void writeObject(String path, T obj) throws IOException {
        this.writeObject(RelFile.fromPath(path), obj);
    }

    @Override
    public void writeStringUTF8(String path, String str) throws IOException {
        this.writeStringUTF8(RelFile.fromPath(path), str);
    }

    @Override
    public void writeStringUTF8(RelFile file, String str) throws IOException {
        if (file.getParent() != null) {
            this.makeDirectory(file.getParent());
        }
        this.writeStringUTF8NoMkdir(file, str);
    }

    @Override
    public void copyFile(RelFile src, RelFile dst) throws IOException {
        if (!this.isFile(src)) {
            throw new IOException(String.valueOf(src) + " is not a file");
        }
        if (dst.isRoot()) {
            throw new IOException("/ is not a valid destination filename");
        }
        if (dst.getParent() != null) {
            this.makeDirectory(dst.getParent());
        }
        if (!src.equals(dst)) {
            this.writeContentUnsafeNoMkdir(dst, this.readContentUnsafe(src));
        }
    }

    @Override
    public void copyRelFile(RelFile orig, RelFile copy) throws IOException {
        if (this.isFile(orig)) {
            this.copyFile(orig, copy);
        } else {
            this.makeDirectory(copy);
            for (RelFile o : this.listFiles(orig)) {
                RelFile c = new RelFile(copy, o.getLeafName());
                this.copyRelFile(o, c);
            }
        }
    }

    @Override
    public void moveFile(String srcPath, String dstPath) throws IOException {
        this.moveFile(RelFile.fromPath(srcPath), RelFile.fromPath(dstPath));
    }

    @Override
    public void moveFile(RelFile src, RelFile dst) throws IOException {
        if (src == null) {
            throw new IOException("src is null");
        }
        if (dst == null) {
            throw new IOException("dst is null");
        }
        if (src.equals(dst)) {
            return;
        }
        if (dst.isStrictChildOf(src)) {
            throw new IOException("Cannot move '" + String.valueOf(src) + "' to '" + String.valueOf(dst) + "' because cannot copy directory in subdirectory");
        }
        this.copyFile(src, dst);
        this.deleteFile(src);
    }

    @Override
    public void writeBytes(RelFile file, byte[] bytes) throws IOException {
        if (file.getParent() != null) {
            this.makeDirectory(file.getParent());
        }
        this.writeContentUnsafeNoMkdir(file, this.fileContentFactory.fromUncompressedBytes(bytes));
    }

    @Override
    public void writeBytes(String path, byte[] bytes) throws IOException {
        this.writeBytes(RelFile.fromPath(path), bytes);
    }

    @Override
    public void writeStringUTF8NoMkdir(RelFile file, String content) throws IOException {
        this.writeContentUnsafeNoMkdir(file, this.fileContentFactory.fromString(content));
    }

    @Override
    public <T> void writeObjectUnsafeNoMkdir(RelFile file, T obj) throws IOException {
        this.writeContentUnsafeNoMkdir(file, this.fileContentFactory.fromObject(obj));
    }

    @Override
    public void writeCompressedBytesUnsafeNoMkdir(RelFile file, ReadOnlyFS.CompressedFileData compressedFileData) throws IOException {
        this.writeContentUnsafeNoMkdir(file, this.fileContentFactory.fromCompressedBytes(compressedFileData.data, compressedFileData.uncompressedLength, compressedFileData.compressor));
    }

    @Override
    public RelFileOutputStream writeStreamNoMkdir(RelFile file) throws IOException {
        if (this.isDirectory(file) || file.getParent() != null && !this.isDirectory(file.getParent())) {
            throw new IOException("Cannot write file " + String.valueOf(file));
        }
        return new RelFileOutputStream(file, this.fileContentFactory.fromOutputStream(content -> this.writeContentUnsafeNoMkdir(file, content)));
    }

    @Override
    public RelFileOutputStream writeStream(RelFile file) throws IOException {
        if (file.getParent() != null) {
            this.makeDirectory(file.getParent());
        }
        return this.writeStreamNoMkdir(file);
    }

    @Override
    public RelFileOutputStream writeStream(String path) throws IOException {
        return this.writeStream(RelFile.fromPath(path));
    }

    @Override
    public ZipWriteFS writeZip(RelFile file) throws IOException {
        return new ZipWriteFS((OutputStream)((Object)this.writeStream(file)));
    }
}

