/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.FileContentFactory;
import com.dataiku.dip.transactions.fs.ProxiedReadOnlyFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.imfs.InMemoryDiff;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipReadFS
extends ProxiedReadOnlyFS
implements AutoCloseable {
    private final ZipFile zipFile;
    private final InMemoryDiff imfs = new InMemoryDiff();

    public ZipReadFS(File file) throws IOException {
        this.zipFile = new ZipFile(file);
        this.populateInMemoryFS();
    }

    private void populateInMemoryFS() throws IOException {
        Enumeration entries = this.zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            RelFile path = RelFile.fromPath(entry.getName());
            if (entry.isDirectory()) {
                this.imfs.makeDirectory(path);
                continue;
            }
            if (!path.isRoot()) {
                this.imfs.makeDirectory(path.getParent());
            }
            FileContent lazyContent = FileContentFactory.DEFAULT.fromUncompressedStreamSupplier(() -> this.zipFile.getInputStream(entry), entry.getSize());
            this.imfs.writeContentUnsafeNoMkdir(path, lazyContent);
        }
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    @Override
    protected ReadOnlyFS getDelegateFS() {
        return this.imfs;
    }
}

